/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.httpclient.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int chunkSize;
    private int pos;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;
    private HttpMethod method = null;
    private static final Log LOG = LogFactory.getLog(ChunkedInputStream.class);

    public ChunkedInputStream(InputStream inputStream, HttpMethod httpMethod) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream parameter may not be null");
        }
        this.in = inputStream;
        this.method = httpMethod;
        this.pos = 0;
    }

    public ChunkedInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        n2 = Math.min(n2, this.chunkSize - this.pos);
        int n3 = this.in.read(byArray, n, n2);
        this.pos += n3;
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private void readCRLF() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n != 13 || n2 != 10) {
            throw new IOException("CRLF expected at end of chunk: " + n + "/" + n2);
        }
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCRLF();
        }
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.in);
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private static int getChunkSizeFromInputStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        block15: while (n2 != -1) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            switch (n2) {
                case 0: {
                    switch (n3) {
                        case 13: {
                            n2 = 1;
                            continue block15;
                        }
                        case 34: {
                            n2 = 2;
                        }
                    }
                    byteArrayOutputStream.write(n3);
                    continue block15;
                }
                case 1: {
                    if (n3 == 10) {
                        n2 = -1;
                        continue block15;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (n3) {
                        case 92: {
                            n3 = inputStream.read();
                            byteArrayOutputStream.write(n3);
                            continue block15;
                        }
                        case 34: {
                            n2 = 0;
                        }
                    }
                    byteArrayOutputStream.write(n3);
                    continue block15;
                }
            }
            throw new RuntimeException("assertion failed");
        }
        String string = EncodingUtil.getAsciiString(byteArrayOutputStream.toByteArray());
        int n4 = string.indexOf(59);
        string = n4 > 0 ? string.substring(0, n4).trim() : string.trim();
        try {
            n = Integer.parseInt(string.trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad chunk size: " + string);
        }
        return n;
    }

    private void parseTrailerHeaders() throws IOException {
        Header[] headerArray = null;
        try {
            String string = "US-ASCII";
            if (this.method != null) {
                string = this.method.getParams().getHttpElementCharset();
            }
            headerArray = HttpParser.parseHeaders(this.in, string);
        }
        catch (HttpException httpException) {
            LOG.error((Object)"Error parsing trailer headers", (Throwable)httpException);
            IOException iOException = new IOException(httpException.getMessage());
            ExceptionUtil.initCause(iOException, httpException);
            throw iOException;
        }
        if (this.method != null) {
            for (int i = 0; i < headerArray.length; ++i) {
                this.method.addResponseFooter(headerArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof) {
                    ChunkedInputStream.exhaustInputStream(this);
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    static void exhaustInputStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) >= 0) {
        }
    }
}

