/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class AnnotationIntrospector
implements Versioned,
Serializable {
    public static AnnotationIntrospector nopInstance() {
        return NopAnnotationIntrospector.instance;
    }

    public static AnnotationIntrospector pair(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        return new AnnotationIntrospectorPair(annotationIntrospector, annotationIntrospector2);
    }

    public Collection<AnnotationIntrospector> allIntrospectors() {
        return Collections.singletonList(this);
    }

    public Collection<AnnotationIntrospector> allIntrospectors(Collection<AnnotationIntrospector> collection) {
        collection.add(this);
        return collection;
    }

    public abstract Version version();

    public boolean isAnnotationBundle(Annotation annotation) {
        return false;
    }

    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        return null;
    }

    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        return objectIdInfo;
    }

    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        return null;
    }

    public JsonIgnoreProperties.Value findPropertyIgnorals(Annotated annotated) {
        JsonIgnoreProperties.Value value;
        Boolean bl;
        String[] stringArray = this.findPropertiesToIgnore(annotated, true);
        Boolean bl2 = bl = annotated instanceof AnnotatedClass ? this.findIgnoreUnknownProperties((AnnotatedClass)annotated) : null;
        if (stringArray == null) {
            if (bl == null) {
                return null;
            }
            value = JsonIgnoreProperties.Value.empty();
        } else {
            value = JsonIgnoreProperties.Value.forIgnoredProperties((String[])stringArray);
        }
        if (bl != null) {
            value = bl != false ? value.withIgnoreUnknown() : value.withoutIgnoreUnknown();
        }
        return value;
    }

    @Deprecated
    public String[] findPropertiesToIgnore(Annotated annotated, boolean bl) {
        return null;
    }

    @Deprecated
    public String[] findPropertiesToIgnore(Annotated annotated) {
        return null;
    }

    @Deprecated
    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        return null;
    }

    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        return null;
    }

    public Object findFilterId(Annotated annotated) {
        return null;
    }

    public Object findNamingStrategy(AnnotatedClass annotatedClass) {
        return null;
    }

    public String findClassDescription(AnnotatedClass annotatedClass) {
        return null;
    }

    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        return visibilityChecker;
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return null;
    }

    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        return null;
    }

    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        return null;
    }

    public List<NamedType> findSubtypes(Annotated annotated) {
        return null;
    }

    public String findTypeName(AnnotatedClass annotatedClass) {
        return null;
    }

    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return null;
    }

    public ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        return null;
    }

    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        return null;
    }

    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return false;
    }

    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        return null;
    }

    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        return null;
    }

    public Class<?>[] findViews(Annotated annotated) {
        return null;
    }

    public JsonFormat.Value findFormat(Annotated annotated) {
        return null;
    }

    public PropertyName findWrapperName(Annotated annotated) {
        return null;
    }

    public String findPropertyDefaultValue(Annotated annotated) {
        return null;
    }

    public String findPropertyDescription(Annotated annotated) {
        return null;
    }

    public Integer findPropertyIndex(Annotated annotated) {
        return null;
    }

    public String findImplicitPropertyName(AnnotatedMember annotatedMember) {
        return null;
    }

    public JsonProperty.Access findPropertyAccess(Annotated annotated) {
        return null;
    }

    public AnnotatedMethod resolveSetterConflict(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, AnnotatedMethod annotatedMethod2) {
        return null;
    }

    public Object findSerializer(Annotated annotated) {
        return null;
    }

    public Object findKeySerializer(Annotated annotated) {
        return null;
    }

    public Object findContentSerializer(Annotated annotated) {
        return null;
    }

    public Object findNullSerializer(Annotated annotated) {
        return null;
    }

    public JsonSerialize.Typing findSerializationTyping(Annotated annotated) {
        return null;
    }

    public Object findSerializationConverter(Annotated annotated) {
        return null;
    }

    public Object findSerializationContentConverter(AnnotatedMember annotatedMember) {
        return null;
    }

    @Deprecated
    public JsonInclude.Include findSerializationInclusion(Annotated annotated, JsonInclude.Include include) {
        return include;
    }

    @Deprecated
    public JsonInclude.Include findSerializationInclusionForContent(Annotated annotated, JsonInclude.Include include) {
        return include;
    }

    public JsonInclude.Value findPropertyInclusion(Annotated annotated) {
        return JsonInclude.Value.empty();
    }

    @Deprecated
    public Class<?> findSerializationType(Annotated annotated) {
        return null;
    }

    @Deprecated
    public Class<?> findSerializationKeyType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Deprecated
    public Class<?> findSerializationContentType(Annotated annotated, JavaType javaType) {
        return null;
    }

    public JavaType refineSerializationType(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) throws JsonMappingException {
        Class<?> clazz;
        Class<?> clazz2;
        Type type;
        TypeFactory typeFactory;
        JavaType javaType2;
        block21: {
            javaType2 = javaType;
            typeFactory = mapperConfig.getTypeFactory();
            Class<?> clazz3 = this.findSerializationType(annotated);
            if (clazz3 != null) {
                if (javaType2.hasRawClass(clazz3)) {
                    javaType2 = javaType2.withStaticTyping();
                } else {
                    type = javaType2.getRawClass();
                    try {
                        if (clazz3.isAssignableFrom((Class<?>)type)) {
                            javaType2 = typeFactory.constructGeneralizedType(javaType2, clazz3);
                            break block21;
                        }
                        if (((Class)type).isAssignableFrom(clazz3)) {
                            javaType2 = typeFactory.constructSpecializedType(javaType2, clazz3);
                            break block21;
                        }
                        throw new JsonMappingException(null, String.format("Can not refine serialization type %s into %s; types not related", javaType2, clazz3.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new JsonMappingException(null, String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", javaType2, clazz3.getName(), annotated.getName(), illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
                    }
                }
            }
        }
        if (javaType2.isMapLikeType() && (clazz2 = this.findSerializationKeyType(annotated, (JavaType)(type = javaType2.getKeyType()))) != null) {
            block22: {
                if (((JavaType)type).hasRawClass(clazz2)) {
                    type = ((JavaType)type).withStaticTyping();
                } else {
                    clazz = ((JavaType)type).getRawClass();
                    try {
                        if (clazz2.isAssignableFrom(clazz)) {
                            type = typeFactory.constructGeneralizedType((JavaType)type, clazz2);
                            break block22;
                        }
                        if (clazz.isAssignableFrom(clazz2)) {
                            type = typeFactory.constructSpecializedType((JavaType)type, clazz2);
                            break block22;
                        }
                        throw new JsonMappingException(null, String.format("Can not refine serialization key type %s into %s; types not related", type, clazz2.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new JsonMappingException(null, String.format("Failed to widen key type of %s with concrete-type annotation (value %s), from '%s': %s", javaType2, clazz2.getName(), annotated.getName(), illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
                    }
                }
            }
            javaType2 = ((MapLikeType)javaType2).withKeyType((JavaType)type);
        }
        if ((type = javaType2.getContentType()) != null && (clazz2 = this.findSerializationContentType(annotated, (JavaType)type)) != null) {
            block23: {
                if (((JavaType)type).hasRawClass(clazz2)) {
                    type = ((JavaType)type).withStaticTyping();
                } else {
                    clazz = ((JavaType)type).getRawClass();
                    try {
                        if (clazz2.isAssignableFrom(clazz)) {
                            type = typeFactory.constructGeneralizedType((JavaType)type, clazz2);
                            break block23;
                        }
                        if (clazz.isAssignableFrom(clazz2)) {
                            type = typeFactory.constructSpecializedType((JavaType)type, clazz2);
                            break block23;
                        }
                        throw new JsonMappingException(null, String.format("Can not refine serialization content type %s into %s; types not related", type, clazz2.getName()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new JsonMappingException(null, String.format("Internal error: failed to refine value type of %s with concrete-type annotation (value %s), from '%s': %s", javaType2, clazz2.getName(), annotated.getName(), illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
                    }
                }
            }
            javaType2 = javaType2.withContentType((JavaType)type);
        }
        return javaType2;
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        return null;
    }

    public Boolean findSerializationSortAlphabetically(Annotated annotated) {
        return null;
    }

    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
    }

    public PropertyName findNameForSerialization(Annotated annotated) {
        return null;
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    @Deprecated
    public String findEnumValue(Enum<?> enum_) {
        return enum_.name();
    }

    public String[] findEnumValues(Class<?> clazz, Enum<?>[] enumArray, String[] stringArray) {
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] != null) continue;
            stringArray[i] = this.findEnumValue(enumArray[i]);
        }
        return stringArray;
    }

    public Enum<?> findDefaultEnumValue(Class<Enum<?>> clazz) {
        return null;
    }

    public Object findDeserializer(Annotated annotated) {
        return null;
    }

    public Object findKeyDeserializer(Annotated annotated) {
        return null;
    }

    public Object findContentDeserializer(Annotated annotated) {
        return null;
    }

    public Object findDeserializationConverter(Annotated annotated) {
        return null;
    }

    public Object findDeserializationContentConverter(AnnotatedMember annotatedMember) {
        return null;
    }

    public JavaType refineDeserializationType(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) throws JsonMappingException {
        JavaType javaType2;
        Class<?> clazz;
        JavaType javaType3 = javaType;
        TypeFactory typeFactory = mapperConfig.getTypeFactory();
        Class<?> clazz2 = this.findDeserializationType(annotated, javaType3);
        if (clazz2 != null && !javaType3.hasRawClass(clazz2)) {
            try {
                javaType3 = typeFactory.constructSpecializedType(javaType3, clazz2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException(null, String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", javaType3, clazz2.getName(), annotated.getName(), illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
            }
        }
        if (javaType3.isMapLikeType() && (clazz = this.findDeserializationKeyType(annotated, javaType2 = javaType3.getKeyType())) != null) {
            try {
                javaType2 = typeFactory.constructSpecializedType(javaType2, clazz);
                javaType3 = ((MapLikeType)javaType3).withKeyType(javaType2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException(null, String.format("Failed to narrow key type of %s with concrete-type annotation (value %s), from '%s': %s", javaType3, clazz.getName(), annotated.getName(), illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
            }
        }
        if ((javaType2 = javaType3.getContentType()) != null && (clazz = this.findDeserializationContentType(annotated, javaType2)) != null) {
            try {
                javaType2 = typeFactory.constructSpecializedType(javaType2, clazz);
                javaType3 = javaType3.withContentType(javaType2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException(null, String.format("Failed to narrow value type of %s with concrete-type annotation (value %s), from '%s': %s", javaType3, clazz.getName(), annotated.getName(), illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
            }
        }
        return javaType3;
    }

    @Deprecated
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Deprecated
    public Class<?> findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        return null;
    }

    @Deprecated
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        return null;
    }

    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        return null;
    }

    public Class<?> findPOJOBuilder(AnnotatedClass annotatedClass) {
        return null;
    }

    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass annotatedClass) {
        return null;
    }

    public PropertyName findNameForDeserialization(Annotated annotated) {
        return null;
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    public boolean hasCreatorAnnotation(Annotated annotated) {
        return false;
    }

    public JsonCreator.Mode findCreatorBinding(Annotated annotated) {
        return null;
    }

    protected <A extends Annotation> A _findAnnotation(Annotated annotated, Class<A> clazz) {
        return annotated.getAnnotation(clazz);
    }

    protected boolean _hasAnnotation(Annotated annotated, Class<? extends Annotation> clazz) {
        return annotated.hasAnnotation(clazz);
    }

    protected boolean _hasOneOf(Annotated annotated, Class<? extends Annotation>[] classArray) {
        return annotated.hasOneOf(classArray);
    }

    public static class ReferenceProperty {
        private final Type _type;
        private final String _name;

        public ReferenceProperty(Type type, String string) {
            this._type = type;
            this._name = string;
        }

        public static ReferenceProperty managed(String string) {
            return new ReferenceProperty(Type.MANAGED_REFERENCE, string);
        }

        public static ReferenceProperty back(String string) {
            return new ReferenceProperty(Type.BACK_REFERENCE, string);
        }

        public Type getType() {
            return this._type;
        }

        public String getName() {
            return this._name;
        }

        public boolean isManagedReference() {
            return this._type == Type.MANAGED_REFERENCE;
        }

        public boolean isBackReference() {
            return this._type == Type.BACK_REFERENCE;
        }

        public static enum Type {
            MANAGED_REFERENCE,
            BACK_REFERENCE;

        }
    }
}

