/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DatabindContext {
    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public abstract boolean isEnabled(MapperFeature var1);

    public abstract boolean canOverrideAccessModifiers();

    public abstract Class<?> getActiveView();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        return this.getTypeFactory().constructType(type);
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (javaType.getRawClass() == clazz) {
            return javaType;
        }
        return this.getConfig().constructSpecializedType(javaType, clazz);
    }

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) throws JsonMappingException {
        ObjectIdGenerator<?> objectIdGenerator;
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator2 = objectIdGenerator = handlerInstantiator == null ? null : handlerInstantiator.objectIdGeneratorInstance(mapperConfig, annotated, clazz);
        if (objectIdGenerator == null) {
            objectIdGenerator = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    public ObjectIdResolver objectIdResolverInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        ObjectIdResolver objectIdResolver;
        Class<? extends ObjectIdResolver> clazz = objectIdInfo.getResolverType();
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        ObjectIdResolver objectIdResolver2 = objectIdResolver = handlerInstantiator == null ? null : handlerInstantiator.resolverIdGeneratorInstance(mapperConfig, annotated, clazz);
        if (objectIdResolver == null) {
            objectIdResolver = ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return objectIdResolver;
    }

    public Converter<Object, Object> converterInstance(Annotated annotated, Object object) throws JsonMappingException {
        Converter converter;
        if (object == null) {
            return null;
        }
        if (object instanceof Converter) {
            return (Converter)object;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object.getClass().getName() + "; expected type Converter or Class<Converter> instead");
        }
        Class clazz = (Class)object;
        if (clazz == Converter.None.class || ClassUtil.isBogusClass(clazz)) {
            return null;
        }
        if (!Converter.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<Converter>");
        }
        MapperConfig<?> mapperConfig = this.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        Converter converter2 = converter = handlerInstantiator == null ? null : handlerInstantiator.converterInstance(mapperConfig, annotated, clazz);
        if (converter == null) {
            converter = (Converter)ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return converter;
    }
}

