/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public class PropertyNamingStrategy
implements Serializable {
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new PropertyNamingStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    @Deprecated
    public static final PropertyNamingStrategy CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES = SNAKE_CASE;
    @Deprecated
    public static final PropertyNamingStrategy PASCAL_CASE_TO_CAMEL_CASE = UPPER_CAMEL_CASE;

    public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
        return string;
    }

    public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
        return string;
    }

    public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
        return string;
    }

    @Deprecated
    public static class PascalCaseStrategy
    extends UpperCamelCaseStrategy {
    }

    @Deprecated
    public static class LowerCaseWithUnderscoresStrategy
    extends SnakeCaseStrategy {
    }

    public static class KebabCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n = string.length();
            if (n == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(n + (n >> 1));
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                char c2 = Character.toLowerCase(c);
                if (c2 == c) {
                    if (n2 > 1) {
                        stringBuilder.insert(stringBuilder.length() - 1, '-');
                    }
                    n2 = 0;
                } else {
                    if (n2 == 0 && i > 0) {
                        stringBuilder.append('-');
                    }
                    ++n2;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
    }

    public static class LowerCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            return string.toLowerCase();
        }
    }

    public static class UpperCamelCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            char c;
            if (string == null || string.length() == 0) {
                return string;
            }
            char c2 = string.charAt(0);
            if (c2 == (c = Character.toUpperCase(c2))) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, c);
            return stringBuilder.toString();
        }
    }

    public static class SnakeCaseStrategy
    extends PropertyNamingStrategyBase {
        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n * 2);
            int n2 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (i <= 0 && c == '_') continue;
                if (Character.isUpperCase(c)) {
                    if (!bl && n2 > 0 && stringBuilder.charAt(n2 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n2;
                    }
                    c = Character.toLowerCase(c);
                    bl = true;
                } else {
                    bl = false;
                }
                stringBuilder.append(c);
                ++n2;
            }
            return n2 > 0 ? stringBuilder.toString() : string;
        }
    }

    public static abstract class PropertyNamingStrategyBase
    extends PropertyNamingStrategy {
        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);
    }
}

