/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class POJOPropertyBuilder
extends BeanPropertyDefinition
implements Comparable<POJOPropertyBuilder> {
    protected final boolean _forSerialization;
    protected final MapperConfig<?> _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final PropertyName _name;
    protected final PropertyName _internalName;
    protected Linked<AnnotatedField> _fields;
    protected Linked<AnnotatedParameter> _ctorParameters;
    protected Linked<AnnotatedMethod> _getters;
    protected Linked<AnnotatedMethod> _setters;

    public POJOPropertyBuilder(MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, boolean bl, PropertyName propertyName) {
        this(mapperConfig, annotationIntrospector, bl, propertyName, propertyName);
    }

    protected POJOPropertyBuilder(MapperConfig<?> mapperConfig, AnnotationIntrospector annotationIntrospector, boolean bl, PropertyName propertyName, PropertyName propertyName2) {
        this._config = mapperConfig;
        this._annotationIntrospector = annotationIntrospector;
        this._internalName = propertyName;
        this._name = propertyName2;
        this._forSerialization = bl;
    }

    public POJOPropertyBuilder(POJOPropertyBuilder pOJOPropertyBuilder, PropertyName propertyName) {
        this._config = pOJOPropertyBuilder._config;
        this._annotationIntrospector = pOJOPropertyBuilder._annotationIntrospector;
        this._internalName = pOJOPropertyBuilder._internalName;
        this._name = propertyName;
        this._fields = pOJOPropertyBuilder._fields;
        this._ctorParameters = pOJOPropertyBuilder._ctorParameters;
        this._getters = pOJOPropertyBuilder._getters;
        this._setters = pOJOPropertyBuilder._setters;
        this._forSerialization = pOJOPropertyBuilder._forSerialization;
    }

    @Override
    public POJOPropertyBuilder withName(PropertyName propertyName) {
        return new POJOPropertyBuilder(this, propertyName);
    }

    @Override
    public POJOPropertyBuilder withSimpleName(String string) {
        PropertyName propertyName = this._name.withSimpleName(string);
        return propertyName == this._name ? this : new POJOPropertyBuilder(this, propertyName);
    }

    @Override
    public int compareTo(POJOPropertyBuilder pOJOPropertyBuilder) {
        if (this._ctorParameters != null) {
            if (pOJOPropertyBuilder._ctorParameters == null) {
                return -1;
            }
        } else if (pOJOPropertyBuilder._ctorParameters != null) {
            return 1;
        }
        return this.getName().compareTo(pOJOPropertyBuilder.getName());
    }

    @Override
    public String getName() {
        return this._name == null ? null : this._name.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._name;
    }

    @Override
    public boolean hasName(PropertyName propertyName) {
        return this._name.equals(propertyName);
    }

    @Override
    public String getInternalName() {
        return this._internalName.getSimpleName();
    }

    @Override
    public PropertyName getWrapperName() {
        AnnotatedMember annotatedMember = this.getPrimaryMember();
        return annotatedMember == null || this._annotationIntrospector == null ? null : this._annotationIntrospector.findWrapperName(annotatedMember);
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return this._anyExplicits(this._fields) || this._anyExplicits(this._getters) || this._anyExplicits(this._setters) || this._anyExplicits(this._ctorParameters);
    }

    @Override
    public boolean isExplicitlyNamed() {
        return this._anyExplicitNames(this._fields) || this._anyExplicitNames(this._getters) || this._anyExplicitNames(this._setters) || this._anyExplicitNames(this._ctorParameters);
    }

    @Override
    public boolean hasGetter() {
        return this._getters != null;
    }

    @Override
    public boolean hasSetter() {
        return this._setters != null;
    }

    @Override
    public boolean hasField() {
        return this._fields != null;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._ctorParameters != null;
    }

    @Override
    public boolean couldDeserialize() {
        return this._ctorParameters != null || this._setters != null || this._fields != null;
    }

    @Override
    public boolean couldSerialize() {
        return this._getters != null || this._fields != null;
    }

    @Override
    public AnnotatedMethod getGetter() {
        Linked<AnnotatedMethod> linked = this._getters;
        if (linked == null) {
            return null;
        }
        Linked linked2 = linked.next;
        if (linked2 == null) {
            return (AnnotatedMethod)linked.value;
        }
        while (linked2 != null) {
            block11: {
                int n;
                int n2;
                block9: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block10: {
                        clazz2 = ((AnnotatedMethod)linked.value).getDeclaringClass();
                        if (clazz2 == (clazz = ((AnnotatedMethod)linked2.value).getDeclaringClass())) break block9;
                        if (!clazz2.isAssignableFrom(clazz)) break block10;
                        linked = linked2;
                        break block11;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block11;
                }
                if ((n2 = this._getterPriority((AnnotatedMethod)linked2.value)) != (n = this._getterPriority((AnnotatedMethod)linked.value))) {
                    if (n2 < n) {
                        linked = linked2;
                    }
                } else {
                    throw new IllegalArgumentException("Conflicting getter definitions for property \"" + this.getName() + "\": " + ((AnnotatedMethod)linked.value).getFullName() + " vs " + ((AnnotatedMethod)linked2.value).getFullName());
                }
            }
            linked2 = linked2.next;
        }
        this._getters = linked.withoutNext();
        return (AnnotatedMethod)linked.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnnotatedMethod getSetter() {
        Linked<AnnotatedMethod> linked = this._setters;
        if (linked == null) {
            return null;
        }
        Linked linked2 = linked.next;
        if (linked2 == null) {
            return (AnnotatedMethod)linked.value;
        }
        while (linked2 != null) {
            block12: {
                int n;
                block10: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block11: {
                        clazz2 = ((AnnotatedMethod)linked.value).getDeclaringClass();
                        if (clazz2 == (clazz = ((AnnotatedMethod)linked2.value).getDeclaringClass())) break block10;
                        if (!clazz2.isAssignableFrom(clazz)) break block11;
                        linked = linked2;
                        break block12;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block12;
                }
                AnnotatedMethod annotatedMethod = (AnnotatedMethod)linked2.value;
                AnnotatedMethod annotatedMethod2 = (AnnotatedMethod)linked.value;
                int n2 = this._setterPriority(annotatedMethod);
                if (n2 != (n = this._setterPriority(annotatedMethod2))) {
                    if (n2 < n) {
                        linked = linked2;
                    }
                } else {
                    if (this._annotationIntrospector == null) throw new IllegalArgumentException(String.format("Conflicting setter definitions for property \"%s\": %s vs %s", this.getName(), ((AnnotatedMethod)linked.value).getFullName(), ((AnnotatedMethod)linked2.value).getFullName()));
                    AnnotatedMethod annotatedMethod3 = this._annotationIntrospector.resolveSetterConflict(this._config, annotatedMethod2, annotatedMethod);
                    if (annotatedMethod3 != annotatedMethod2) {
                        if (annotatedMethod3 != annotatedMethod) throw new IllegalArgumentException(String.format("Conflicting setter definitions for property \"%s\": %s vs %s", this.getName(), ((AnnotatedMethod)linked.value).getFullName(), ((AnnotatedMethod)linked2.value).getFullName()));
                        linked = linked2;
                    }
                }
            }
            linked2 = linked2.next;
        }
        this._setters = linked.withoutNext();
        return (AnnotatedMethod)linked.value;
    }

    @Override
    public AnnotatedField getField() {
        if (this._fields == null) {
            return null;
        }
        AnnotatedField annotatedField = (AnnotatedField)this._fields.value;
        Linked linked = this._fields.next;
        while (linked != null) {
            block7: {
                AnnotatedField annotatedField2;
                block5: {
                    Class<?> clazz;
                    Class<?> clazz2;
                    block6: {
                        annotatedField2 = (AnnotatedField)linked.value;
                        clazz2 = annotatedField.getDeclaringClass();
                        if (clazz2 == (clazz = annotatedField2.getDeclaringClass())) break block5;
                        if (!clazz2.isAssignableFrom(clazz)) break block6;
                        annotatedField = annotatedField2;
                        break block7;
                    }
                    if (clazz.isAssignableFrom(clazz2)) break block7;
                }
                throw new IllegalArgumentException("Multiple fields representing property \"" + this.getName() + "\": " + annotatedField.getFullName() + " vs " + annotatedField2.getFullName());
            }
            linked = linked.next;
        }
        return annotatedField;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        if (this._ctorParameters == null) {
            return null;
        }
        Linked<AnnotatedParameter> linked = this._ctorParameters;
        do {
            if (!(((AnnotatedParameter)linked.value).getOwner() instanceof AnnotatedConstructor)) continue;
            return (AnnotatedParameter)linked.value;
        } while ((linked = linked.next) != null);
        return (AnnotatedParameter)this._ctorParameters.value;
    }

    @Override
    public Iterator<AnnotatedParameter> getConstructorParameters() {
        if (this._ctorParameters == null) {
            return ClassUtil.emptyIterator();
        }
        return new MemberIterator<AnnotatedParameter>(this._ctorParameters);
    }

    @Override
    public AnnotatedMember getAccessor() {
        AnnotatedMember annotatedMember = this.getGetter();
        if (annotatedMember == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember getMutator() {
        AnnotatedMember annotatedMember = this.getConstructorParameter();
        if (annotatedMember == null && (annotatedMember = this.getSetter()) == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember getNonConstructorMutator() {
        AnnotatedMember annotatedMember = this.getSetter();
        if (annotatedMember == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        if (this._forSerialization) {
            return this.getAccessor();
        }
        return this.getMutator();
    }

    protected int _getterPriority(AnnotatedMethod annotatedMethod) {
        String string = annotatedMethod.getName();
        if (string.startsWith("get") && string.length() > 3) {
            return 1;
        }
        if (string.startsWith("is") && string.length() > 2) {
            return 2;
        }
        return 3;
    }

    protected int _setterPriority(AnnotatedMethod annotatedMethod) {
        String string = annotatedMethod.getName();
        if (string.startsWith("set") && string.length() > 3) {
            return 1;
        }
        return 2;
    }

    @Override
    public Class<?>[] findViews() {
        return this.fromMemberAnnotations(new WithMember<Class<?>[]>(){

            @Override
            public Class<?>[] withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findViews(annotatedMember);
            }
        });
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType() {
        return this.fromMemberAnnotations(new WithMember<AnnotationIntrospector.ReferenceProperty>(){

            @Override
            public AnnotationIntrospector.ReferenceProperty withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findReferenceType(annotatedMember);
            }
        });
    }

    @Override
    public boolean isTypeId() {
        Boolean bl = this.fromMemberAnnotations(new WithMember<Boolean>(){

            @Override
            public Boolean withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.isTypeId(annotatedMember);
            }
        });
        return bl != null && bl != false;
    }

    @Override
    public PropertyMetadata getMetadata() {
        Boolean bl = this._findRequired();
        String string = this._findDescription();
        Integer n = this._findIndex();
        String string2 = this._findDefaultValue();
        if (bl == null && n == null && string2 == null) {
            return string == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : PropertyMetadata.STD_REQUIRED_OR_OPTIONAL.withDescription(string);
        }
        return PropertyMetadata.construct(bl, string, n, string2);
    }

    protected Boolean _findRequired() {
        return this.fromMemberAnnotations(new WithMember<Boolean>(){

            @Override
            public Boolean withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.hasRequiredMarker(annotatedMember);
            }
        });
    }

    protected String _findDescription() {
        return this.fromMemberAnnotations(new WithMember<String>(){

            @Override
            public String withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findPropertyDescription(annotatedMember);
            }
        });
    }

    protected Integer _findIndex() {
        return this.fromMemberAnnotations(new WithMember<Integer>(){

            @Override
            public Integer withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findPropertyIndex(annotatedMember);
            }
        });
    }

    protected String _findDefaultValue() {
        return this.fromMemberAnnotations(new WithMember<String>(){

            @Override
            public String withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findPropertyDefaultValue(annotatedMember);
            }
        });
    }

    @Override
    public ObjectIdInfo findObjectIdInfo() {
        return this.fromMemberAnnotations(new WithMember<ObjectIdInfo>(){

            @Override
            public ObjectIdInfo withMember(AnnotatedMember annotatedMember) {
                ObjectIdInfo objectIdInfo = POJOPropertyBuilder.this._annotationIntrospector.findObjectIdInfo(annotatedMember);
                if (objectIdInfo != null) {
                    objectIdInfo = POJOPropertyBuilder.this._annotationIntrospector.findObjectReferenceInfo(annotatedMember, objectIdInfo);
                }
                return objectIdInfo;
            }
        });
    }

    @Override
    public JsonInclude.Value findInclusion() {
        AnnotatedMember annotatedMember = this.getAccessor();
        JsonInclude.Value value = this._annotationIntrospector == null ? null : this._annotationIntrospector.findPropertyInclusion(annotatedMember);
        return value == null ? JsonInclude.Value.empty() : value;
    }

    public JsonProperty.Access findAccess() {
        return this.fromMemberAnnotationsExcept(new WithMember<JsonProperty.Access>(){

            @Override
            public JsonProperty.Access withMember(AnnotatedMember annotatedMember) {
                return POJOPropertyBuilder.this._annotationIntrospector.findPropertyAccess(annotatedMember);
            }
        }, JsonProperty.Access.AUTO);
    }

    public void addField(AnnotatedField annotatedField, PropertyName propertyName, boolean bl, boolean bl2, boolean bl3) {
        this._fields = new Linked<AnnotatedField>(annotatedField, this._fields, propertyName, bl, bl2, bl3);
    }

    public void addCtor(AnnotatedParameter annotatedParameter, PropertyName propertyName, boolean bl, boolean bl2, boolean bl3) {
        this._ctorParameters = new Linked<AnnotatedParameter>(annotatedParameter, this._ctorParameters, propertyName, bl, bl2, bl3);
    }

    public void addGetter(AnnotatedMethod annotatedMethod, PropertyName propertyName, boolean bl, boolean bl2, boolean bl3) {
        this._getters = new Linked<AnnotatedMethod>(annotatedMethod, this._getters, propertyName, bl, bl2, bl3);
    }

    public void addSetter(AnnotatedMethod annotatedMethod, PropertyName propertyName, boolean bl, boolean bl2, boolean bl3) {
        this._setters = new Linked<AnnotatedMethod>(annotatedMethod, this._setters, propertyName, bl, bl2, bl3);
    }

    public void addAll(POJOPropertyBuilder pOJOPropertyBuilder) {
        this._fields = POJOPropertyBuilder.merge(this._fields, pOJOPropertyBuilder._fields);
        this._ctorParameters = POJOPropertyBuilder.merge(this._ctorParameters, pOJOPropertyBuilder._ctorParameters);
        this._getters = POJOPropertyBuilder.merge(this._getters, pOJOPropertyBuilder._getters);
        this._setters = POJOPropertyBuilder.merge(this._setters, pOJOPropertyBuilder._setters);
    }

    private static <T> Linked<T> merge(Linked<T> linked, Linked<T> linked2) {
        if (linked == null) {
            return linked2;
        }
        if (linked2 == null) {
            return linked;
        }
        return linked.append(linked2);
    }

    public void removeIgnored() {
        this._fields = this._removeIgnored(this._fields);
        this._getters = this._removeIgnored(this._getters);
        this._setters = this._removeIgnored(this._setters);
        this._ctorParameters = this._removeIgnored(this._ctorParameters);
    }

    public void removeNonVisible(boolean bl) {
        JsonProperty.Access access = this.findAccess();
        if (access == null) {
            access = JsonProperty.Access.AUTO;
        }
        switch (access) {
            case READ_ONLY: {
                this._setters = null;
                this._ctorParameters = null;
                if (this._forSerialization) break;
                this._fields = null;
                break;
            }
            case READ_WRITE: {
                break;
            }
            case WRITE_ONLY: {
                this._getters = null;
                if (!this._forSerialization) break;
                this._fields = null;
                break;
            }
            default: {
                this._getters = this._removeNonVisible(this._getters);
                this._ctorParameters = this._removeNonVisible(this._ctorParameters);
                if (bl && this._getters != null) break;
                this._fields = this._removeNonVisible(this._fields);
                this._setters = this._removeNonVisible(this._setters);
            }
        }
    }

    public void removeConstructors() {
        this._ctorParameters = null;
    }

    public void trimByVisibility() {
        this._fields = this._trimByVisibility(this._fields);
        this._getters = this._trimByVisibility(this._getters);
        this._setters = this._trimByVisibility(this._setters);
        this._ctorParameters = this._trimByVisibility(this._ctorParameters);
    }

    public void mergeAnnotations(boolean bl) {
        if (bl) {
            if (this._getters != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._getters, this._fields, this._ctorParameters, this._setters);
                this._getters = this._applyAnnotations(this._getters, annotationMap);
            } else if (this._fields != null) {
                AnnotationMap annotationMap = this._mergeAnnotations(0, this._fields, this._ctorParameters, this._setters);
                this._fields = this._applyAnnotations(this._fields, annotationMap);
            }
        } else if (this._ctorParameters != null) {
            AnnotationMap annotationMap = this._mergeAnnotations(0, this._ctorParameters, this._setters, this._fields, this._getters);
            this._ctorParameters = this._applyAnnotations(this._ctorParameters, annotationMap);
        } else if (this._setters != null) {
            AnnotationMap annotationMap = this._mergeAnnotations(0, this._setters, this._fields, this._getters);
            this._setters = this._applyAnnotations(this._setters, annotationMap);
        } else if (this._fields != null) {
            AnnotationMap annotationMap = this._mergeAnnotations(0, this._fields, this._getters);
            this._fields = this._applyAnnotations(this._fields, annotationMap);
        }
    }

    private AnnotationMap _mergeAnnotations(int n, Linked<? extends AnnotatedMember> ... linkedArray) {
        AnnotationMap annotationMap = this._getAllAnnotations(linkedArray[n]);
        while (++n < linkedArray.length) {
            if (linkedArray[n] == null) continue;
            return AnnotationMap.merge(annotationMap, this._mergeAnnotations(n, linkedArray));
        }
        return annotationMap;
    }

    private <T extends AnnotatedMember> AnnotationMap _getAllAnnotations(Linked<T> linked) {
        AnnotationMap annotationMap = ((AnnotatedMember)linked.value).getAllAnnotations();
        if (linked.next != null) {
            annotationMap = AnnotationMap.merge(annotationMap, this._getAllAnnotations(linked.next));
        }
        return annotationMap;
    }

    private <T extends AnnotatedMember> Linked<T> _applyAnnotations(Linked<T> linked, AnnotationMap annotationMap) {
        AnnotatedMember annotatedMember = (AnnotatedMember)((AnnotatedMember)linked.value).withAnnotations(annotationMap);
        if (linked.next != null) {
            linked = linked.withNext(this._applyAnnotations(linked.next, annotationMap));
        }
        return linked.withValue(annotatedMember);
    }

    private <T> Linked<T> _removeIgnored(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.withoutIgnored();
    }

    private <T> Linked<T> _removeNonVisible(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.withoutNonVisible();
    }

    private <T> Linked<T> _trimByVisibility(Linked<T> linked) {
        if (linked == null) {
            return linked;
        }
        return linked.trimByVisibility();
    }

    private <T> boolean _anyExplicits(Linked<T> linked) {
        while (linked != null) {
            if (linked.name != null && linked.name.hasSimpleName()) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    private <T> boolean _anyExplicitNames(Linked<T> linked) {
        while (linked != null) {
            if (linked.name != null && linked.isNameExplicit) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyVisible() {
        return this._anyVisible(this._fields) || this._anyVisible(this._getters) || this._anyVisible(this._setters) || this._anyVisible(this._ctorParameters);
    }

    private <T> boolean _anyVisible(Linked<T> linked) {
        while (linked != null) {
            if (linked.isVisible) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public boolean anyIgnorals() {
        return this._anyIgnorals(this._fields) || this._anyIgnorals(this._getters) || this._anyIgnorals(this._setters) || this._anyIgnorals(this._ctorParameters);
    }

    private <T> boolean _anyIgnorals(Linked<T> linked) {
        while (linked != null) {
            if (linked.isMarkedIgnored) {
                return true;
            }
            linked = linked.next;
        }
        return false;
    }

    public Set<PropertyName> findExplicitNames() {
        Set<PropertyName> set = null;
        set = this._findExplicitNames(this._fields, set);
        set = this._findExplicitNames(this._getters, set);
        set = this._findExplicitNames(this._setters, set);
        if ((set = this._findExplicitNames(this._ctorParameters, set)) == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Collection<POJOPropertyBuilder> explode(Collection<PropertyName> collection) {
        HashMap<PropertyName, POJOPropertyBuilder> hashMap = new HashMap<PropertyName, POJOPropertyBuilder>();
        this._explode(collection, hashMap, this._fields);
        this._explode(collection, hashMap, this._getters);
        this._explode(collection, hashMap, this._setters);
        this._explode(collection, hashMap, this._ctorParameters);
        return hashMap.values();
    }

    private void _explode(Collection<PropertyName> collection, Map<PropertyName, POJOPropertyBuilder> map, Linked<?> linked) {
        Linked<?> linked2 = linked;
        Linked<Object> linked3 = linked;
        while (linked3 != null) {
            PropertyName propertyName = linked3.name;
            if (!linked3.isNameExplicit || propertyName == null) {
                if (linked3.isVisible) {
                    throw new IllegalStateException("Conflicting/ambiguous property name definitions (implicit name '" + this._name + "'): found multiple explicit names: " + collection + ", but also implicit accessor: " + linked3);
                }
            } else {
                Linked<Object> linked4;
                POJOPropertyBuilder pOJOPropertyBuilder = map.get(propertyName);
                if (pOJOPropertyBuilder == null) {
                    pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, this._internalName, propertyName);
                    map.put(propertyName, pOJOPropertyBuilder);
                }
                if (linked2 == this._fields) {
                    linked4 = linked3;
                    pOJOPropertyBuilder._fields = linked4.withNext(pOJOPropertyBuilder._fields);
                } else if (linked2 == this._getters) {
                    linked4 = linked3;
                    pOJOPropertyBuilder._getters = linked4.withNext(pOJOPropertyBuilder._getters);
                } else if (linked2 == this._setters) {
                    linked4 = linked3;
                    pOJOPropertyBuilder._setters = linked4.withNext(pOJOPropertyBuilder._setters);
                } else if (linked2 == this._ctorParameters) {
                    linked4 = linked3;
                    pOJOPropertyBuilder._ctorParameters = linked4.withNext(pOJOPropertyBuilder._ctorParameters);
                } else {
                    throw new IllegalStateException("Internal error: mismatched accessors, property: " + this);
                }
            }
            linked3 = linked3.next;
        }
    }

    private Set<PropertyName> _findExplicitNames(Linked<? extends AnnotatedMember> linked, Set<PropertyName> set) {
        while (linked != null) {
            if (linked.isNameExplicit && linked.name != null) {
                if (set == null) {
                    set = new HashSet<PropertyName>();
                }
                set.add(linked.name);
            }
            linked = linked.next;
        }
        return set;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Property '").append(this._name).append("'; ctors: ").append(this._ctorParameters).append(", field(s): ").append(this._fields).append(", getter(s): ").append(this._getters).append(", setter(s): ").append(this._setters);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected <T> T fromMemberAnnotations(WithMember<T> withMember) {
        T t = null;
        if (this._annotationIntrospector != null) {
            if (this._forSerialization) {
                if (this._getters != null) {
                    t = withMember.withMember((AnnotatedMember)this._getters.value);
                }
            } else {
                if (this._ctorParameters != null) {
                    t = withMember.withMember((AnnotatedMember)this._ctorParameters.value);
                }
                if (t == null && this._setters != null) {
                    t = withMember.withMember((AnnotatedMember)this._setters.value);
                }
            }
            if (t == null && this._fields != null) {
                t = withMember.withMember((AnnotatedMember)this._fields.value);
            }
        }
        return t;
    }

    protected <T> T fromMemberAnnotationsExcept(WithMember<T> withMember, T t) {
        T t2;
        if (this._annotationIntrospector == null) {
            return null;
        }
        if (this._forSerialization) {
            T t3;
            if (this._getters != null && (t3 = withMember.withMember((AnnotatedMember)this._getters.value)) != null && t3 != t) {
                return t3;
            }
            if (this._fields != null && (t3 = withMember.withMember((AnnotatedMember)this._fields.value)) != null && t3 != t) {
                return t3;
            }
            if (this._ctorParameters != null && (t3 = withMember.withMember((AnnotatedMember)this._ctorParameters.value)) != null && t3 != t) {
                return t3;
            }
            if (this._setters != null && (t3 = withMember.withMember((AnnotatedMember)this._setters.value)) != null && t3 != t) {
                return t3;
            }
            return null;
        }
        if (this._ctorParameters != null && (t2 = withMember.withMember((AnnotatedMember)this._ctorParameters.value)) != null && t2 != t) {
            return t2;
        }
        if (this._setters != null && (t2 = withMember.withMember((AnnotatedMember)this._setters.value)) != null && t2 != t) {
            return t2;
        }
        if (this._fields != null && (t2 = withMember.withMember((AnnotatedMember)this._fields.value)) != null && t2 != t) {
            return t2;
        }
        if (this._getters != null && (t2 = withMember.withMember((AnnotatedMember)this._getters.value)) != null && t2 != t) {
            return t2;
        }
        return null;
    }

    protected static final class Linked<T> {
        public final T value;
        public final Linked<T> next;
        public final PropertyName name;
        public final boolean isNameExplicit;
        public final boolean isVisible;
        public final boolean isMarkedIgnored;

        public Linked(T t, Linked<T> linked, PropertyName propertyName, boolean bl, boolean bl2, boolean bl3) {
            this.value = t;
            this.next = linked;
            PropertyName propertyName2 = this.name = propertyName == null || propertyName.isEmpty() ? null : propertyName;
            if (bl) {
                if (this.name == null) {
                    throw new IllegalArgumentException("Can not pass true for 'explName' if name is null/empty");
                }
                if (!propertyName.hasSimpleName()) {
                    bl = false;
                }
            }
            this.isNameExplicit = bl;
            this.isVisible = bl2;
            this.isMarkedIgnored = bl3;
        }

        public Linked<T> withoutNext() {
            if (this.next == null) {
                return this;
            }
            return new Linked<T>(this.value, null, this.name, this.isNameExplicit, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withValue(T t) {
            if (t == this.value) {
                return this;
            }
            return new Linked<T>(t, this.next, this.name, this.isNameExplicit, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withNext(Linked<T> linked) {
            if (linked == this.next) {
                return this;
            }
            return new Linked<T>(this.value, linked, this.name, this.isNameExplicit, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withoutIgnored() {
            Linked<T> linked;
            if (this.isMarkedIgnored) {
                return this.next == null ? null : this.next.withoutIgnored();
            }
            if (this.next != null && (linked = this.next.withoutIgnored()) != this.next) {
                return this.withNext(linked);
            }
            return this;
        }

        public Linked<T> withoutNonVisible() {
            Linked<T> linked = this.next == null ? null : this.next.withoutNonVisible();
            return this.isVisible ? this.withNext(linked) : linked;
        }

        protected Linked<T> append(Linked<T> linked) {
            if (this.next == null) {
                return this.withNext(linked);
            }
            return this.withNext(this.next.append(linked));
        }

        public Linked<T> trimByVisibility() {
            if (this.next == null) {
                return this;
            }
            Linked<T> linked = this.next.trimByVisibility();
            if (this.name != null) {
                if (linked.name == null) {
                    return this.withNext(null);
                }
                return this.withNext(linked);
            }
            if (linked.name != null) {
                return linked;
            }
            if (this.isVisible == linked.isVisible) {
                return this.withNext(linked);
            }
            return this.isVisible ? this.withNext(null) : linked;
        }

        public String toString() {
            String string = this.value.toString() + "[visible=" + this.isVisible + ",ignore=" + this.isMarkedIgnored + ",explicitName=" + this.isNameExplicit + "]";
            if (this.next != null) {
                string = string + ", " + this.next.toString();
            }
            return string;
        }
    }

    protected static class MemberIterator<T extends AnnotatedMember>
    implements Iterator<T> {
        private Linked<T> next;

        public MemberIterator(Linked<T> linked) {
            this.next = linked;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            AnnotatedMember annotatedMember = (AnnotatedMember)this.next.value;
            this.next = this.next.next;
            return (T)annotatedMember;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface WithMember<T> {
        public T withMember(AnnotatedMember var1);
    }
}

