/*
 * Decompiled with CFR 0.152.
 */
package org.fife.io;

import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class DocumentReader
extends Reader {
    private long position = 0L;
    private long mark = -1L;
    private Document document;
    private Segment segment;

    public DocumentReader(Document document) {
        this.document = document;
        this.segment = new Segment();
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int n) {
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.position >= (long)this.document.getLength()) {
            return -1;
        }
        try {
            this.document.getText((int)this.position, 1, this.segment);
            ++this.position;
            return this.segment.array[this.segment.offset];
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return -1;
        }
    }

    @Override
    public int read(char[] cArray) {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n, int n2) {
        if (this.position >= (long)this.document.getLength()) {
            return -1;
        }
        int n3 = n2;
        if (this.position + (long)n3 >= (long)this.document.getLength()) {
            n3 = this.document.getLength() - (int)this.position;
        }
        if (n + n3 >= cArray.length) {
            n3 = cArray.length - n;
        }
        try {
            this.document.getText((int)this.position, n3, this.segment);
            this.position += (long)n3;
            System.arraycopy(this.segment.array, this.segment.offset, cArray, n, n3);
            return n3;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void reset() {
        if (this.mark == -1L) {
            this.position = 0L;
        } else {
            this.position = this.mark;
            this.mark = -1L;
        }
    }

    @Override
    public long skip(long l) {
        if (this.position + l <= (long)this.document.getLength()) {
            this.position += l;
            return l;
        }
        long l2 = this.position;
        this.position = this.document.getLength();
        return (long)this.document.getLength() - l2;
    }

    public void seek(long l) {
        this.position = Math.min(l, (long)this.document.getLength());
    }
}

