/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.fife.ui.rsyntaxtextarea.FileFileLocation;
import org.fife.ui.rsyntaxtextarea.URLFileLocation;

public abstract class FileLocation {
    public static FileLocation create(String string) {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://")) {
            try {
                return new URLFileLocation(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Not a valid URL: " + string, malformedURLException);
            }
        }
        return new FileFileLocation(new File(string));
    }

    public static FileLocation create(File file) {
        return new FileFileLocation(file);
    }

    public static FileLocation create(URL uRL) {
        if ("file".equalsIgnoreCase(uRL.getProtocol())) {
            return new FileFileLocation(new File(uRL.getPath()));
        }
        return new URLFileLocation(uRL);
    }

    protected abstract long getActualLastModified();

    public abstract String getFileFullPath();

    public abstract String getFileName();

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    public abstract boolean isLocal();

    public abstract boolean isLocalAndExists();

    public boolean isRemote() {
        return !this.isLocal();
    }
}

