/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;

public class SyntaxView
extends View
implements TabExpander,
TokenOrientedView,
RSTAView {
    private Font font;
    private FontMetrics metrics;
    private Element longLine;
    private float longLineWidth;
    private int tabSize;
    private int tabBase;
    private RSyntaxTextArea host;
    private int lineHeight = 0;
    private int ascent;
    private int clipStart;
    private int clipEnd;
    private TokenImpl tempToken = new TokenImpl();

    public SyntaxView(Element element) {
        super(element);
    }

    void calculateLongestLine() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth(' ');
        Element element = this.getElement();
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            float f = this.getLineWidth(i);
            if (!(f > this.longLineWidth)) continue;
            this.longLineWidth = f;
            this.longLine = element2;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected void damageLineRange(int n, int n2, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n);
            Rectangle rectangle2 = this.lineToRect(shape, n2);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    private float drawLine(TokenPainter tokenPainter, Token token, Graphics2D graphics2D, float f, float f2, int n) {
        float f3 = f;
        boolean bl = this.host.getPaintTokenBackgrounds(n, f2);
        while (token != null && token.isPaintable() && f3 < (float)this.clipEnd) {
            f3 = tokenPainter.paint(token, graphics2D, f3, f2, this.host, this, this.clipStart, bl);
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            graphics2D.setColor(this.host.getForegroundForTokenType(21));
            graphics2D.setFont(this.host.getFontForTokenType(21));
            graphics2D.drawString("\u00b6", f3, f2);
        }
        return f3;
    }

    private float drawLineWithSelection(TokenPainter tokenPainter, Token token, Graphics2D graphics2D, float f, float f2, int n, int n2) {
        float f3 = f;
        boolean bl = this.host.getUseSelectedTextColor();
        while (token != null && token.isPaintable() && f3 < (float)this.clipEnd) {
            if (token.containsPosition(n)) {
                int n3;
                int n4;
                if (n > token.getOffset()) {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = n - this.tempToken.getOffset();
                    f3 = tokenPainter.paint(this.tempToken, graphics2D, f3, f2, this.host, this, this.clipStart);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(n);
                    token = new TokenImpl(this.tempToken);
                }
                if ((n4 = Math.min(n3 = token.length(), n2 - token.getOffset())) == n3) {
                    f3 = tokenPainter.paintSelected(token, graphics2D, f3, f2, this.host, this, this.clipStart, bl);
                } else {
                    this.tempToken.copyFrom(token);
                    this.tempToken.textCount = n4;
                    f3 = tokenPainter.paintSelected(this.tempToken, graphics2D, f3, f2, this.host, this, this.clipStart, bl);
                    this.tempToken.textCount = token.length();
                    this.tempToken.makeStartAt(token.getOffset() + n4);
                    token = this.tempToken;
                    f3 = tokenPainter.paint(token, graphics2D, f3, f2, this.host, this, this.clipStart);
                }
            } else if (token.containsPosition(n2)) {
                this.tempToken.copyFrom(token);
                this.tempToken.textCount = n2 - this.tempToken.getOffset();
                f3 = tokenPainter.paintSelected(this.tempToken, graphics2D, f3, f2, this.host, this, this.clipStart, bl);
                this.tempToken.textCount = token.length();
                this.tempToken.makeStartAt(n2);
                token = this.tempToken;
                f3 = tokenPainter.paint(token, graphics2D, f3, f2, this.host, this, this.clipStart);
            } else {
                f3 = token.getOffset() >= n && token.getEndOffset() <= n2 ? tokenPainter.paintSelected(token, graphics2D, f3, f2, this.host, this, this.clipStart, bl) : tokenPainter.paint(token, graphics2D, f3, f2, this.host, this, this.clipStart);
            }
            token = token.getNextToken();
        }
        if (this.host.getEOLMarkersVisible()) {
            graphics2D.setColor(this.host.getForegroundForTokenType(21));
            graphics2D.setFont(this.host.getFontForTokenType(21));
            graphics2D.drawString("\u00b6", f3, f2);
        }
        return f3;
    }

    private float getLineWidth(int n) {
        Token token = ((RSyntaxDocument)this.getDocument()).getTokenListForLine(n);
        return RSyntaxUtilities.getTokenListWidth(token, (RSyntaxTextArea)this.getContainer(), this);
    }

    @Override
    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return RSyntaxUtilities.getNextVisualPositionFrom(n, bias, shape, n2, biasArray, this);
    }

    @Override
    public float getPreferredSpan(int n) {
        this.updateMetrics();
        switch (n) {
            case 0: {
                float f = this.longLineWidth + (float)this.getRhsCorrection();
                if (this.host.getEOLMarkersVisible()) {
                    f += (float)this.metrics.charWidth('\u00b6');
                }
                return f;
            }
            case 1: {
                this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
                int n2 = this.getElement().getElementCount();
                if (this.host.isCodeFoldingEnabled()) {
                    n2 -= this.host.getFoldManager().getHiddenLineCount();
                }
                return n2 * this.lineHeight;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    private final int getRhsCorrection() {
        int n = 10;
        if (this.host != null) {
            n = this.host.getRightHandSideCorrection();
        }
        return n;
    }

    private int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 5;
        return n2;
    }

    @Override
    public Token getTokenListForPhysicalLineAbove(int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        FoldManager foldManager = this.host.getFoldManager();
        if (foldManager == null ? --n2 >= 0 : (n2 = foldManager.getVisibleLineAbove(n2)) >= 0) {
            return rSyntaxDocument.getTokenListForLine(n2);
        }
        return null;
    }

    @Override
    public Token getTokenListForPhysicalLineBelow(int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementCount();
        int n3 = element.getElementIndex(n);
        if (!this.host.isCodeFoldingEnabled()) {
            if (n3 < n2 - 1) {
                return rSyntaxDocument.getTokenListForLine(n3 + 1);
            }
        } else {
            FoldManager foldManager = this.host.getFoldManager();
            n3 = foldManager.getVisibleLineBelow(n3);
            if (n3 >= 0 && n3 < n2) {
                return rSyntaxDocument.getTokenListForLine(n3);
            }
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected Rectangle lineToRect(Shape shape, int n) {
        Rectangle rectangle = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            int n2 = this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            if (this.host.isCodeFoldingEnabled()) {
                FoldManager foldManager = this.host.getFoldManager();
                int n3 = foldManager.getHiddenLineCountAbove(n);
                n -= n3;
            }
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n * this.lineHeight, rectangle2.width, this.lineHeight);
        }
        return rectangle;
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Element element = this.getElement();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        int n2 = element.getElementIndex(n);
        Token token = rSyntaxDocument.getTokenListForLine(n2);
        Rectangle rectangle = this.lineToRect(shape, n2);
        this.tabBase = rectangle.x;
        rectangle = token.listOffsetToView((RSyntaxTextArea)this.getContainer(), this, n, this.tabBase, rectangle);
        return rectangle;
    }

    @Override
    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n2, shape, bias2);
        }
        rectangle2 = shape3 instanceof Rectangle ? (Rectangle)shape3 : shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        if (n2 > n) {
            rectangle2.width -= rectangle.width;
        }
        return rectangle2;
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Rectangle rectangle = shape.getBounds();
        this.tabBase = rectangle.x;
        this.host = (RSyntaxTextArea)this.getContainer();
        Rectangle rectangle2 = graphics.getClipBounds();
        this.clipStart = rectangle2.x;
        this.clipEnd = this.clipStart + rectangle2.width;
        this.lineHeight = this.host.getLineHeight();
        this.ascent = this.host.getMaxAscent();
        int n = rectangle2.y - rectangle.y;
        int n2 = Math.max(0, n / this.lineHeight);
        FoldManager foldManager = this.host.getFoldManager();
        n2 += foldManager.getHiddenLineCountAbove(n2, true);
        Rectangle rectangle3 = this.lineToRect(shape, n2);
        int n3 = rectangle3.y + this.ascent;
        int n4 = rectangle3.x;
        Element element = this.getElement();
        int n5 = element.getElementCount();
        int n6 = this.host.getSelectionStart();
        int n7 = this.host.getSelectionEnd();
        RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.host.getHighlighter();
        Graphics2D graphics2D = (Graphics2D)graphics;
        TokenPainter tokenPainter = this.host.getTokenPainter();
        for (int i = n2; n3 < rectangle2.y + rectangle2.height + this.ascent && i < n5; n3 += this.lineHeight, ++i) {
            int n8;
            Fold fold = foldManager.getFoldForLine(i);
            Element element2 = element.getElement(i);
            int n9 = element2.getStartOffset();
            int n10 = element2.getEndOffset() - 1;
            rSyntaxTextAreaHighlighter.paintLayeredHighlights(graphics2D, n9, n10, shape, this.host, this);
            Token token = rSyntaxDocument.getTokenListForLine(i);
            if (n6 == n7 || n9 >= n7 || n10 < n6) {
                this.drawLine(tokenPainter, token, graphics2D, n4, n3, i);
            } else {
                this.drawLineWithSelection(tokenPainter, token, graphics2D, n4, n3, n6, n7);
            }
            if (fold == null || !fold.isCollapsed()) continue;
            Color color = RSyntaxUtilities.getFoldedLineBottomColor(this.host);
            if (color != null) {
                graphics.setColor(color);
                graphics.drawLine(n4, n3 + this.lineHeight - this.ascent - 1, this.host.getWidth(), n3 + this.lineHeight - this.ascent - 1);
            }
            while ((n8 = fold.getLineCount()) != 0 && (fold = foldManager.getFoldForLine(i += n8)) != null && fold.isCollapsed()) {
            }
        }
    }

    private boolean possiblyUpdateLongLine(Element element, int n) {
        float f = this.getLineWidth(n);
        if (f > this.longLineWidth) {
            this.longLineWidth = f;
            this.longLine = element;
            return true;
        }
        return false;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    @Override
    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        this.updateMetrics();
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        Container container = this.getContainer();
        this.updateMetrics();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
        Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
        if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
            int n;
            if (elementArray2 != null) {
                n = elementChange.getIndex();
                for (int i = 0; i < elementArray2.length; ++i) {
                    this.possiblyUpdateLongLine(elementArray2[i], n + i);
                }
            }
            if (elementArray != null) {
                for (n = 0; n < elementArray.length; ++n) {
                    if (elementArray[n] != this.longLine) continue;
                    this.longLineWidth = -1.0f;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            container.repaint();
        } else if (documentEvent.getType() == DocumentEvent.EventType.CHANGE) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            this.damageLineRange(n, n2, shape, container);
        } else {
            Element element2 = this.getElement();
            int n = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n, n, shape, container);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                Element element3 = element2.getElement(n);
                if (element3 == this.longLine) {
                    this.longLineWidth = this.getLineWidth(n);
                    this.preferenceChanged(null, true, false);
                } else if (this.possiblyUpdateLongLine(element3, n)) {
                    this.preferenceChanged(null, true, false);
                }
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n) == this.longLine) {
                this.longLineWidth = -1.0f;
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    private void updateMetrics() {
        this.host = (RSyntaxTextArea)this.getContainer();
        Font font = this.host.getFont();
        if (this.font != font) {
            this.calculateLongestLine();
        }
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        int n = (int)f;
        int n2 = (int)f2;
        if (n2 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n2 > rectangle.y + rectangle.height) {
            return this.host.getLastVisibleOffset();
        }
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n3 = Math.abs((n2 - rectangle.y) / this.lineHeight);
        FoldManager foldManager = this.host.getFoldManager();
        if ((n3 += foldManager.getHiddenLineCountAbove(n3, true)) >= element.getElementCount()) {
            return this.host.getLastVisibleOffset();
        }
        Element element2 = element.getElement(n3);
        if (n < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        int n4 = element2.getStartOffset();
        Token token = rSyntaxDocument.getTokenListForLine(n3);
        this.tabBase = rectangle.x;
        int n5 = token.getListOffset((RSyntaxTextArea)this.getContainer(), this, this.tabBase, n);
        return n5 != -1 ? n5 : n4;
    }

    @Override
    public int yForLine(Rectangle rectangle, int n) throws BadLocationException {
        this.updateMetrics();
        if (this.metrics != null) {
            this.lineHeight = this.host != null ? this.host.getLineHeight() : this.lineHeight;
            FoldManager foldManager = this.host.getFoldManager();
            if (!foldManager.isLineHidden(n)) {
                n -= foldManager.getHiddenLineCountAbove(n);
                return rectangle.y + n * this.lineHeight;
            }
        }
        return -1;
    }

    @Override
    public int yForLineContaining(Rectangle rectangle, int n) throws BadLocationException {
        Element element = this.getElement();
        int n2 = element.getElementIndex(n);
        return this.yForLine(rectangle, n2);
    }
}

