/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.Color;
import net.java.sip.communicator.impl.protocol.irc.ControlChar;

public class ControlCharTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetTag() {
        Assert.assertEquals((String)"i", (String)new ControlChar.Italics().getTag());
    }

    public void testGetHtmlStartSimple() {
        Assert.assertEquals((String)"<b>", (String)new ControlChar.Bold().getHtmlStart());
    }

    public void testGetHtmlEnd() {
        Assert.assertEquals((String)"</u>", (String)new ControlChar.Underline().getHtmlEnd());
    }

    public void testColorFormatControlCharBoth() {
        ControlChar.ColorFormat control = new ControlChar.ColorFormat(Color.GREEN, Color.RED);
        Assert.assertEquals((String)"font", (String)control.getTag());
        Assert.assertEquals((String)"<font color=\"Green\" bgcolor=\"Red\">", (String)control.getHtmlStart());
        Assert.assertEquals((String)"</font>", (String)control.getHtmlEnd());
    }

    public void testColorFormatControlCharForeground() {
        ControlChar.ColorFormat control = new ControlChar.ColorFormat(Color.GREEN, null);
        Assert.assertEquals((String)"font", (String)control.getTag());
        Assert.assertEquals((String)"<font color=\"Green\">", (String)control.getHtmlStart());
        Assert.assertEquals((String)"</font>", (String)control.getHtmlEnd());
    }

    public void testColorFormatControlCharBackground() {
        ControlChar.ColorFormat control = new ControlChar.ColorFormat(null, Color.RED);
        Assert.assertEquals((String)"font", (String)control.getTag());
        Assert.assertEquals((String)"<font bgcolor=\"Red\">", (String)control.getHtmlStart());
        Assert.assertEquals((String)"</font>", (String)control.getHtmlEnd());
    }
}

