/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.Mode;
import net.java.sip.communicator.impl.protocol.irc.ModeParser;

public class ModeParserTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructionStringNull() {
        try {
            new ModeParser(null);
            Assert.fail((String)"Expected NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructionStringEmpty() {
        ModeParser parser = new ModeParser("");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)0, (int)modes.size());
    }

    public void testConstructionStringSingleBad() {
        try {
            new ModeParser("p");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testConstructionStringSingleGood() {
        ModeParser parser = new ModeParser("+p");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.PRIVATE), (Object)((Object)modes.get(0).getMode()));
        Assert.assertTrue((boolean)modes.get(0).isAdded());
        Assert.assertEquals((int)0, (int)modes.get(0).getParams().length);
    }

    public void testParseRemoval() {
        ModeParser parser = new ModeParser("-p");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.PRIVATE), (Object)((Object)modes.get(0).getMode()));
        Assert.assertFalse((boolean)modes.get(0).isAdded());
        Assert.assertEquals((int)0, (int)modes.get(0).getParams().length);
    }

    public void testParseUnknownMode() {
        ModeParser parser = new ModeParser("+?");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.UNKNOWN), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)1, (int)modes.get(0).getParams().length);
        Assert.assertEquals((String)"?", (String)modes.get(0).getParams()[0]);
    }

    public void testModeMissingExtraParameters() {
        try {
            new ModeParser("+l");
            Assert.fail((String)"this line should not be reached");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testModeExtraParameters() {
        ModeParser parser = new ModeParser("+l 123 141");
        Assert.assertEquals((int)1, (int)parser.getModes().size());
    }

    public void testModeOwner() {
        ModeParser parser = new ModeParser("+O dude");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.OWNER), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)1, (int)modes.get(0).getParams().length);
        Assert.assertEquals((String)"dude", (String)modes.get(0).getParams()[0]);
    }

    public void testModeOperator() {
        ModeParser parser = new ModeParser("+o dude");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.OPERATOR), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)1, (int)modes.get(0).getParams().length);
        Assert.assertEquals((String)"dude", (String)modes.get(0).getParams()[0]);
    }

    public void testModeVoice() {
        ModeParser parser = new ModeParser("+v dude");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.VOICE), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)1, (int)modes.get(0).getParams().length);
        Assert.assertEquals((String)"dude", (String)modes.get(0).getParams()[0]);
    }

    public void testModeLimitAddition() {
        ModeParser parser = new ModeParser("+l 13");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.LIMIT), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)1, (int)modes.get(0).getParams().length);
        Assert.assertEquals((String)"13", (String)modes.get(0).getParams()[0]);
    }

    public void testModeLimitRemoval() {
        ModeParser parser = new ModeParser("-l");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.LIMIT), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)0, (int)modes.get(0).getParams().length);
    }

    public void testModePrivate() {
        ModeParser parser = new ModeParser("+p");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.PRIVATE), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)0, (int)modes.get(0).getParams().length);
    }

    public void testModeSecret() {
        ModeParser parser = new ModeParser("+s");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.SECRET), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)0, (int)modes.get(0).getParams().length);
    }

    public void testModeInvite() {
        ModeParser parser = new ModeParser("+i");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        Assert.assertTrue((boolean)(modes.get(0) instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.INVITE), (Object)((Object)modes.get(0).getMode()));
        Assert.assertEquals((int)0, (int)modes.get(0).getParams().length);
    }

    public void testModeBan() {
        ModeParser parser = new ModeParser("+b *!*@some-ip.dynamicIP.provider.net");
        List<ModeParser.ModeEntry> modes = parser.getModes();
        Assert.assertNotNull(modes);
        Assert.assertEquals((int)1, (int)modes.size());
        ModeParser.ModeEntry entry = modes.get(0);
        Assert.assertTrue((boolean)(entry instanceof ModeParser.ModeEntry));
        Assert.assertEquals((Object)((Object)Mode.BAN), (Object)((Object)entry.getMode()));
        Assert.assertEquals((int)1, (int)entry.getParams().length);
        Assert.assertEquals((String)"*!*@some-ip.dynamicIP.provider.net", (String)entry.getParams()[0]);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

