/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class DynamicDifferenceSet<E>
implements Set<E> {
    private final Set<E> source;
    private final Set<E> removals;

    public DynamicDifferenceSet(Set<E> source, Set<E> removals) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        this.source = source;
        if (removals == null) {
            throw new IllegalArgumentException("removals cannot be null");
        }
        this.removals = removals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<E> calculate() {
        TreeSet<E> current;
        Set<E> set = this.source;
        synchronized (set) {
            current = new TreeSet<E>(this.source);
        }
        set = this.removals;
        synchronized (set) {
            current.removeAll(this.removals);
        }
        return current;
    }

    @Override
    public int size() {
        return this.calculate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.calculate().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.source.contains(o) && !this.removals.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.calculate().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.calculate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.calculate().toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.calculate().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

