/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.BasicPlugIn;

public abstract class BasicCodec
extends BasicPlugIn
implements Codec {
    private static final boolean DEBUG = true;
    protected Format inputFormat;
    protected Format outputFormat;
    protected boolean opened = false;
    protected Format[] inputFormats = new Format[0];
    protected Format[] outputFormats = new Format[0];
    protected boolean pendingEOM = false;

    protected int checkEOM(Buffer inputBuffer, Buffer outputBuffer) {
        this.processAtEOM(inputBuffer, outputBuffer);
        if (outputBuffer.getLength() > 0) {
            this.pendingEOM = true;
            return 2;
        }
        this.propagateEOM(outputBuffer);
        return 0;
    }

    protected boolean checkFormat(Format format) {
        return true;
    }

    protected boolean checkInputBuffer(Buffer inputBuffer) {
        boolean fError;
        boolean bl = fError = !this.isEOM(inputBuffer) && (inputBuffer == null || inputBuffer.getFormat() == null || !this.checkFormat(inputBuffer.getFormat()));
        if (fError) {
            System.out.println(this.getClass().getName() + " : [error] checkInputBuffer");
        }
        return !fError;
    }

    @Override
    public void close() {
        this.opened = false;
    }

    protected int getArrayElementSize(Class<?> type) {
        if (type == Format.intArray) {
            return 4;
        }
        if (type == Format.shortArray) {
            return 2;
        }
        if (type == Format.byteArray) {
            return 1;
        }
        return 0;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return this.inputFormats;
    }

    protected boolean isEOM(Buffer inputBuffer) {
        return inputBuffer.isEOM();
    }

    @Override
    public void open() throws ResourceUnavailableException {
        this.opened = true;
    }

    protected int processAtEOM(Buffer inputBuffer, Buffer outputBuffer) {
        return 0;
    }

    protected void propagateEOM(Buffer outputBuffer) {
        this.updateOutput(outputBuffer, this.getOutputFormat(), 0, 0);
        outputBuffer.setEOM(true);
    }

    @Override
    public void reset() {
    }

    @Override
    public Format setInputFormat(Format input) {
        this.inputFormat = input;
        return input;
    }

    @Override
    public Format setOutputFormat(Format output) {
        this.outputFormat = output;
        return output;
    }

    protected void updateOutput(Buffer outputBuffer, Format format, int length, int offset) {
        outputBuffer.setFormat(format);
        outputBuffer.setLength(length);
        outputBuffer.setOffset(offset);
    }

    protected RGBFormat updateRGBFormat(VideoFormat newFormat, RGBFormat outputFormat) {
        Dimension size = newFormat.getSize();
        RGBFormat oldFormat = outputFormat;
        int lineStride = size.width * oldFormat.getPixelStride();
        RGBFormat newRGB = new RGBFormat(size, lineStride * size.height, oldFormat.getDataType(), newFormat.getFrameRate(), oldFormat.getBitsPerPixel(), oldFormat.getRedMask(), oldFormat.getGreenMask(), oldFormat.getBlueMask(), oldFormat.getPixelStride(), lineStride, oldFormat.getFlipped(), oldFormat.getEndian());
        return newRGB;
    }
}

