/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.util.RTPUtils;

public class RTCPHeaderUtils {
    public static int getPacketType(byte[] buf, int off, int len) {
        if (!RTCPHeaderUtils.isValid(buf, off, len)) {
            return -1;
        }
        return buf[off + 1] & 0xFF;
    }

    public static int getPacketType(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RTCPHeaderUtils.getPacketType(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    private static int setSenderSSRC(byte[] buf, int off, int len, int senderSSRC) {
        if (!RTCPHeaderUtils.isValid(buf, off, len)) {
            return -1;
        }
        return RTPUtils.writeInt(buf, off + 4, senderSSRC);
    }

    public static int getLength(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 4) {
            return -1;
        }
        int lengthInWords = (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
        return (lengthInWords + 1) * 4;
    }

    public static int getVersion(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 1) {
            return -1;
        }
        return (buf[off] & 0xC0) >>> 6;
    }

    public static boolean isValid(byte[] buf, int off, int len) {
        int version = RTCPHeaderUtils.getVersion(buf, off, len);
        if (version != 2) {
            return false;
        }
        int pktLen = RTCPHeaderUtils.getLength(buf, off, len);
        return pktLen >= 8;
    }

    public static int setSenderSSRC(ByteArrayBuffer baf, int senderSSRC) {
        if (baf == null) {
            return -1;
        }
        return RTCPHeaderUtils.setSenderSSRC(baf.getBuffer(), baf.getOffset(), baf.getLength(), senderSSRC);
    }

    public static int getReportCount(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RTCPHeaderUtils.getReportCount(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    private static int getReportCount(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 1) {
            return -1;
        }
        return buf[off] & 0x1F;
    }

    public static int getLength(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RTCPHeaderUtils.getLength(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }
}

