/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.voice;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.TlvChain;

public class VoiceReqRvCmd
extends AbstractRequestRvCmd
implements ConnectionRequestRvCmd {
    public static final long VERSION_DEFAULT = 1L;
    private final long version;
    private final RvConnectionInfo connInfo;

    public VoiceReqRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.connInfo = RvConnectionInfo.readConnectionInfo(chain);
        ByteBlock data = this.getServiceData();
        this.version = data != null ? BinaryTools.getUInt(data, 0) : -1L;
    }

    public VoiceReqRvCmd(RvConnectionInfo connInfo) {
        this(1L, connInfo);
    }

    public VoiceReqRvCmd(long version, RvConnectionInfo connInfo) {
        super(CapabilityBlock.BLOCK_VOICE);
        DefensiveTools.checkRange(version, "version", -1L);
        this.connInfo = connInfo;
        this.version = version;
    }

    public final long getVersion() {
        return this.version;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    protected void writeRvTlvs(OutputStream out) throws IOException {
        if (this.connInfo != null) {
            this.connInfo.write(out);
        }
    }

    protected boolean hasServiceData() {
        return this.version != -1L;
    }

    protected void writeServiceData(OutputStream out) throws IOException {
        if (this.version != -1L) {
            BinaryTools.writeUInt(out, this.version);
        }
    }

    public String toString() {
        return "VoiceReqRvCmd: version=" + this.version + ", connInfo=" + this.connInfo;
    }
}

