/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class RvProxyInitRecvCmd
extends RvProxyCmd {
    private static final int TYPE_CAP = 1;
    private final String sn;
    private final long icbmMessageId;
    private final int port;
    private final CapabilityBlock capabilityBlock;

    protected RvProxyInitRecvCmd(RvProxyPacket header) {
        super(header);
        ByteBlock data = header.getCommandData();
        StringBlock snInfo = OscarTools.readScreenname(data);
        if (snInfo != null) {
            this.sn = snInfo.getString();
            ByteBlock rest = data.subBlock(snInfo.getTotalSize());
            this.port = BinaryTools.getUShort(rest, 0);
            this.icbmMessageId = BinaryTools.getLong(rest, 2);
            ByteBlock tlvBlock = rest.subBlock(10);
            ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
            Tlv cap = chain.getLastTlv(1);
            this.capabilityBlock = cap != null ? new CapabilityBlock(cap.getData()) : null;
        } else {
            this.sn = null;
            this.icbmMessageId = 0L;
            this.port = -1;
            this.capabilityBlock = null;
        }
    }

    public RvProxyInitRecvCmd(String sn, long icbmMessageId, int port) {
        this(sn, icbmMessageId, port, null);
    }

    public RvProxyInitRecvCmd(String sn, long icbmMessageId, int port, CapabilityBlock block) {
        super(4);
        DefensiveTools.checkNull(sn, "sn");
        DefensiveTools.checkRange(port, "port", -1);
        this.sn = sn;
        this.icbmMessageId = icbmMessageId;
        this.port = port;
        this.capabilityBlock = block;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public CapabilityBlock getCapabilityBlock() {
        return this.capabilityBlock;
    }

    public final int getPort() {
        return this.port;
    }

    public void writeCommandData(OutputStream out) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(out, this.sn);
            if (this.port != -1) {
                BinaryTools.writeUShort(out, this.port);
                BinaryTools.writeLong(out, this.icbmMessageId);
                if (this.capabilityBlock != null) {
                    new Tlv(1, this.capabilityBlock.getBlock()).write(out);
                }
            }
        }
    }

    public String toString() {
        return "RvProxyInitRecvCmd: sn=" + this.sn + ", icbmMessageId=" + this.icbmMessageId + ", port=" + this.port;
    }
}

