/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;

public abstract class RvCommand {
    public static final int RVSTATUS_REQUEST = 0;
    public static final int RVSTATUS_ACCEPT = 2;
    public static final int RVSTATUS_DENY = 1;
    private final int rvStatus;
    private final CapabilityBlock cap;

    protected RvCommand(RecvRvIcbm icbm) {
        DefensiveTools.checkNull(icbm, "icbm");
        this.rvStatus = icbm.getRvStatus();
        this.cap = icbm.getCapability();
    }

    protected RvCommand(int rvStatus, CapabilityBlock cap) {
        DefensiveTools.checkRange(rvStatus, "rvStatus", 0);
        DefensiveTools.checkNull(cap, "cap");
        this.rvStatus = rvStatus;
        this.cap = cap;
    }

    public final int getRvStatus() {
        return this.rvStatus;
    }

    public final CapabilityBlock getCapabilityBlock() {
        return this.cap;
    }

    public abstract void writeRvData(OutputStream var1) throws IOException;
}

