/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.service.gui.ConfigurationContainer;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.notification.NotificationHandler;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.PopupMessageNotificationHandler;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageEvent;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageListener;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;

public abstract class AbstractDeviceConfigurationListener
implements PropertyChangeListener,
SystrayPopupMessageListener {
    private final ConfigurationForm configurationForm;
    private boolean isRegisteredToPopupMessageListener = false;

    public AbstractDeviceConfigurationListener(ConfigurationForm configurationForm) {
        this.configurationForm = configurationForm;
    }

    private void addOrRemovePopupMessageListener(boolean add) {
        for (NotificationHandler notificationHandler : NeomediaActivator.getNotificationService().getActionHandlers("PopupMessageAction")) {
            if (!(notificationHandler instanceof PopupMessageNotificationHandler)) continue;
            PopupMessageNotificationHandler popupMessageNotificationHandler = (PopupMessageNotificationHandler)notificationHandler;
            if (add) {
                popupMessageNotificationHandler.addPopupMessageListener((SystrayPopupMessageListener)this);
                continue;
            }
            popupMessageNotificationHandler.removePopupMessageListener((SystrayPopupMessageListener)this);
        }
    }

    public void dispose() {
        this.addOrRemovePopupMessageListener(false);
    }

    public void popupMessageClicked(SystrayPopupMessageEvent ev) {
        UIService uiService;
        if (ev.getTag() == this && (uiService = (UIService)ServiceUtils.getService((BundleContext)NeomediaActivator.getBundleContext(), UIService.class)) != null) {
            ConfigurationContainer configurationContainer = uiService.getConfigurationContainer();
            configurationContainer.setSelected(this.configurationForm);
            configurationContainer.setVisible(true);
        }
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    public void showPopUpNotification(String title, String body, String popUpEvent) {
        NotificationService notificationService;
        if (title != null && body != null && popUpEvent != null && (notificationService = NeomediaActivator.getNotificationService()) != null) {
            if (!this.isRegisteredToPopupMessageListener) {
                this.isRegisteredToPopupMessageListener = true;
                this.addOrRemovePopupMessageListener(true);
            }
            HashMap<String, AbstractDeviceConfigurationListener> extras = new HashMap<String, AbstractDeviceConfigurationListener>();
            extras.put("PopupMessageNotificationHandler.tag", this);
            notificationService.fireNotification(popUpEvent, title, body + "\r\n\r\n" + NeomediaActivator.getResources().getI18NString("impl.media.configform.AUDIO_DEVICE_CONFIG_MANAGMENT_CLICK"), null, extras);
        }
    }
}

