/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia;

import gnu.java.zrtp.ZrtpConfigure;
import gnu.java.zrtp.ZrtpConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.impl.neomedia.ZrtpConfigureTableModel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTabbedPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class ZrtpConfigurePanel
extends TransparentPanel {
    private static final int MARGIN = 5;
    private static final String TRUSTED_PROP = "net.java.sip.communicator.gnu.java.zrtp.trustedmitm";
    private static final String SASSIGN_PROP = "net.java.sip.communicator.gnu.java.zrtp.sassignature";
    private ZrtpConfigure active = new ZrtpConfigure();
    private ZrtpConfigure inActive = new ZrtpConfigure();
    PublicKeyControls pkc = new PublicKeyControls();
    HashControls hc = new HashControls();
    CipherControls cc = new CipherControls();
    SasControls sc = new SasControls();
    LengthControls lc = new LengthControls();

    public ZrtpConfigurePanel() {
        super((LayoutManager)new BorderLayout());
        ResourceManagementService resources = NeomediaActivator.getResources();
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(0, 10));
        final JButton stdButton = new JButton(resources.getI18NString("impl.media.security.zrtp.STANDARD"));
        stdButton.setOpaque(false);
        final JButton mandButton = new JButton(resources.getI18NString("impl.media.security.zrtp.MANDATORY"));
        mandButton.setOpaque(false);
        final JButton saveButton = new JButton(resources.getI18NString("service.gui.SAVE"));
        saveButton.setOpaque(false);
        TransparentPanel buttonBar = new TransparentPanel((LayoutManager)new GridLayout(1, 7));
        buttonBar.add(stdButton);
        buttonBar.add(mandButton);
        buttonBar.add(Box.createHorizontalStrut(10));
        buttonBar.add(saveButton);
        ConfigurationService cfg = NeomediaActivator.getConfigurationService();
        boolean trusted = cfg.getBoolean(TRUSTED_PROP, false);
        boolean sasSign = cfg.getBoolean(SASSIGN_PROP, false);
        TransparentPanel checkBar = new TransparentPanel((LayoutManager)new GridLayout(1, 2));
        SIPCommCheckBox trustedMitM = new SIPCommCheckBox(resources.getI18NString("impl.media.security.zrtp.TRUSTED"), trusted);
        SIPCommCheckBox sasSignature = new SIPCommCheckBox(resources.getI18NString("impl.media.security.zrtp.SASSIGNATURE"), sasSign);
        checkBar.add((Component)trustedMitM);
        checkBar.add((Component)sasSignature);
        mainPanel.add((Component)checkBar, "North");
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == stdButton) {
                    ZrtpConfigurePanel.this.inActive.clear();
                    ZrtpConfigurePanel.this.active.setStandardConfig();
                    ZrtpConfigurePanel.this.pkc.setStandard();
                    ZrtpConfigurePanel.this.hc.setStandard();
                    ZrtpConfigurePanel.this.sc.setStandard();
                    ZrtpConfigurePanel.this.cc.setStandard();
                    ZrtpConfigurePanel.this.lc.setStandard();
                } else if (source == mandButton) {
                    ZrtpConfigurePanel.this.inActive.clear();
                    ZrtpConfigurePanel.this.active.setMandatoryOnly();
                    ZrtpConfigurePanel.this.pkc.setStandard();
                    ZrtpConfigurePanel.this.hc.setStandard();
                    ZrtpConfigurePanel.this.sc.setStandard();
                    ZrtpConfigurePanel.this.cc.setStandard();
                    ZrtpConfigurePanel.this.lc.setStandard();
                } else if (source == saveButton) {
                    ConfigurationService cfg = NeomediaActivator.getConfigurationService();
                    cfg.setProperty(ZrtpConfigurePanel.TRUSTED_PROP, (Object)String.valueOf(ZrtpConfigurePanel.this.active.isTrustedMitM()));
                    cfg.setProperty(ZrtpConfigurePanel.SASSIGN_PROP, (Object)String.valueOf(ZrtpConfigurePanel.this.active.isSasSignature()));
                    ZrtpConfigurePanel.this.pkc.saveConfig();
                    ZrtpConfigurePanel.this.hc.saveConfig();
                    ZrtpConfigurePanel.this.sc.saveConfig();
                    ZrtpConfigurePanel.this.cc.saveConfig();
                    ZrtpConfigurePanel.this.lc.saveConfig();
                } else {
                    return;
                }
            }
        };
        stdButton.addActionListener(buttonListener);
        mandButton.addActionListener(buttonListener);
        saveButton.addActionListener(buttonListener);
        ItemListener itemListener = new ItemListener((JCheckBox)trustedMitM, (JCheckBox)sasSignature){
            final /* synthetic */ JCheckBox val$trustedMitM;
            final /* synthetic */ JCheckBox val$sasSignature;
            {
                this.val$trustedMitM = jCheckBox;
                this.val$sasSignature = jCheckBox2;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                ItemSelectable source = e.getItemSelectable();
                if (source == this.val$trustedMitM) {
                    ZrtpConfigurePanel.this.active.setTrustedMitM(this.val$trustedMitM.isSelected());
                } else if (source == this.val$sasSignature) {
                    ZrtpConfigurePanel.this.active.setSasSignature(this.val$sasSignature.isSelected());
                }
            }
        };
        trustedMitM.addItemListener(itemListener);
        sasSignature.addItemListener(itemListener);
        SIPCommTabbedPane algorithmsPane = new SIPCommTabbedPane();
        algorithmsPane.addTab(resources.getI18NString("impl.media.security.zrtp.PUB_KEYS"), (Component)((Object)this.pkc));
        algorithmsPane.addTab(resources.getI18NString("impl.media.security.zrtp.HASHES"), (Component)((Object)this.hc));
        algorithmsPane.addTab(resources.getI18NString("impl.media.security.zrtp.SYM_CIPHERS"), (Component)((Object)this.cc));
        algorithmsPane.addTab(resources.getI18NString("impl.media.security.zrtp.SAS_TYPES"), (Component)((Object)this.sc));
        algorithmsPane.addTab(resources.getI18NString("impl.media.security.zrtp.SRTP_LENGTHS"), (Component)((Object)this.lc));
        algorithmsPane.setMinimumSize(new Dimension(400, 100));
        algorithmsPane.setPreferredSize(new Dimension(400, 200));
        mainPanel.add((Component)algorithmsPane, "Center");
        mainPanel.add((Component)buttonBar, "South");
        this.add((Component)mainPanel);
    }

    private <T extends Enum<T>> String getPropertyValue(T algo) {
        StringBuilder strb = new StringBuilder();
        for (Enum it : this.active.algos(algo)) {
            strb.append(it.name());
            strb.append(';');
        }
        return strb.toString();
    }

    private <T extends Enum<T>> void createControls(JPanel panel, ZrtpConfigureTableModel<T> model) {
        ResourceManagementService resources = NeomediaActivator.getResources();
        final JButton upButton = new JButton(resources.getI18NString("impl.media.configform.UP"));
        upButton.setOpaque(false);
        final JButton downButton = new JButton(resources.getI18NString("impl.media.configform.DOWN"));
        downButton.setOpaque(false);
        TransparentPanel buttonBar = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        buttonBar.add(upButton);
        buttonBar.add(downButton);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new GridBagLayout());
        final JTable table = new JTable(model.getRowCount(), 2);
        table.setShowGrid(false);
        table.setTableHeader(null);
        table.setModel(model);
        TableColumnModel tableColumnModel = table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth() + 5);
        table.doLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.fill = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)new JScrollPane(table), constraints);
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        panel.add((Component)buttonBar, constraints);
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int selectedRow;
                if (table.getSelectedRowCount() == 1 && (selectedRow = table.getSelectedRow()) > -1) {
                    ZrtpConfigureTableModel model = (ZrtpConfigureTableModel)table.getModel();
                    upButton.setEnabled(selectedRow > 0 && model.checkEnableUp(selectedRow));
                    downButton.setEnabled(selectedRow < table.getRowCount() - 1 && model.checkEnableDown(selectedRow));
                    return;
                }
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            }
        };
        table.getSelectionModel().addListSelectionListener(tableSelectionListener);
        TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int selectedRow;
                if (table.getSelectedRowCount() == 1 && (selectedRow = table.getSelectedRow()) > -1) {
                    ZrtpConfigureTableModel model = (ZrtpConfigureTableModel)table.getModel();
                    upButton.setEnabled(selectedRow > 0 && model.checkEnableUp(selectedRow));
                    downButton.setEnabled(selectedRow < table.getRowCount() - 1 && model.checkEnableDown(selectedRow));
                    return;
                }
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            }
        };
        table.getModel().addTableModelListener(tableListener);
        tableSelectionListener.valueChanged(null);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean up;
                Object source = event.getSource();
                if (source == upButton) {
                    up = true;
                } else if (source == downButton) {
                    up = false;
                } else {
                    return;
                }
                int index = ((ZrtpConfigureTableModel)table.getModel()).move(table.getSelectedRow(), up, up);
                table.getSelectionModel().setSelectionInterval(index, index);
            }
        };
        upButton.addActionListener(buttonListener);
        downButton.addActionListener(buttonListener);
    }

    public static <T extends Enum<T>> String getPropertyID(T algo) {
        Class<T> clazz = algo.getDeclaringClass();
        return "net.java.sip.communicator." + clazz.getName().replace('$', '_');
    }

    private class LengthControls
    extends TransparentPanel {
        private final ZrtpConfigureTableModel<ZrtpConstants.SupportedAuthLengths> dataModel;

        LengthControls() {
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedAuthLengths.HS32);
            String savedConf = NeomediaActivator.getConfigurationService().getString(id);
            if (savedConf == null) {
                savedConf = "HS32;HS80;";
            }
            this.dataModel = new ZrtpConfigureTableModel<ZrtpConstants.SupportedAuthLengths>(ZrtpConstants.SupportedAuthLengths.HS32, ZrtpConfigurePanel.this.active, ZrtpConfigurePanel.this.inActive, savedConf);
            ZrtpConfigurePanel.this.createControls((JPanel)((Object)this), this.dataModel);
        }

        void setStandard() {
            this.dataModel.setStandardConfig();
        }

        void saveConfig() {
            String value = ZrtpConfigurePanel.this.getPropertyValue((Enum)ZrtpConstants.SupportedAuthLengths.HS32);
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedAuthLengths.HS32);
            NeomediaActivator.getConfigurationService().setProperty(id, (Object)value);
        }
    }

    private class SasControls
    extends TransparentPanel {
        private final ZrtpConfigureTableModel<ZrtpConstants.SupportedSASTypes> dataModel;

        SasControls() {
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedSASTypes.B32);
            String savedConf = NeomediaActivator.getConfigurationService().getString(id);
            if (savedConf == null) {
                savedConf = "B32";
            }
            this.dataModel = new ZrtpConfigureTableModel<ZrtpConstants.SupportedSASTypes>(ZrtpConstants.SupportedSASTypes.B32, ZrtpConfigurePanel.this.active, ZrtpConfigurePanel.this.inActive, savedConf);
            ZrtpConfigurePanel.this.createControls((JPanel)((Object)this), this.dataModel);
        }

        void setStandard() {
            this.dataModel.setStandardConfig();
        }

        void saveConfig() {
            String value = ZrtpConfigurePanel.this.getPropertyValue((Enum)ZrtpConstants.SupportedSASTypes.B32);
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedSASTypes.B32);
            NeomediaActivator.getConfigurationService().setProperty(id, (Object)value);
        }
    }

    private class CipherControls
    extends TransparentPanel {
        private final ZrtpConfigureTableModel<ZrtpConstants.SupportedSymCiphers> dataModel;

        CipherControls() {
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedSymCiphers.AES1);
            String savedConf = NeomediaActivator.getConfigurationService().getString(id);
            if (savedConf == null) {
                savedConf = "AES1";
            }
            this.dataModel = new ZrtpConfigureTableModel<ZrtpConstants.SupportedSymCiphers>(ZrtpConstants.SupportedSymCiphers.AES1, ZrtpConfigurePanel.this.active, ZrtpConfigurePanel.this.inActive, savedConf);
            ZrtpConfigurePanel.this.createControls((JPanel)((Object)this), this.dataModel);
        }

        void setStandard() {
            this.dataModel.setStandardConfig();
        }

        void saveConfig() {
            String value = ZrtpConfigurePanel.this.getPropertyValue((Enum)ZrtpConstants.SupportedSymCiphers.AES1);
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedSymCiphers.AES1);
            NeomediaActivator.getConfigurationService().setProperty(id, (Object)value);
        }
    }

    private class HashControls
    extends TransparentPanel {
        private final ZrtpConfigureTableModel<ZrtpConstants.SupportedHashes> dataModel;

        HashControls() {
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedHashes.S256);
            String savedConf = NeomediaActivator.getConfigurationService().getString(id);
            if (savedConf == null) {
                savedConf = "S256";
            }
            this.dataModel = new ZrtpConfigureTableModel<ZrtpConstants.SupportedHashes>(ZrtpConstants.SupportedHashes.S256, ZrtpConfigurePanel.this.active, ZrtpConfigurePanel.this.inActive, savedConf);
            ZrtpConfigurePanel.this.createControls((JPanel)((Object)this), this.dataModel);
        }

        void setStandard() {
            this.dataModel.setStandardConfig();
        }

        void saveConfig() {
            String value = ZrtpConfigurePanel.this.getPropertyValue((Enum)ZrtpConstants.SupportedHashes.S256);
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedHashes.S256);
            NeomediaActivator.getConfigurationService().setProperty(id, (Object)value);
        }
    }

    private class PublicKeyControls
    extends TransparentPanel {
        private final ZrtpConfigureTableModel<ZrtpConstants.SupportedPubKeys> dataModel;

        PublicKeyControls() {
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedPubKeys.DH2K);
            String savedConf = NeomediaActivator.getConfigurationService().getString(id);
            if (savedConf == null) {
                savedConf = "DH3K;MULT;";
            }
            this.dataModel = new ZrtpConfigureTableModel<ZrtpConstants.SupportedPubKeys>(ZrtpConstants.SupportedPubKeys.DH2K, ZrtpConfigurePanel.this.active, ZrtpConfigurePanel.this.inActive, savedConf);
            ZrtpConfigurePanel.this.createControls((JPanel)((Object)this), this.dataModel);
        }

        void setStandard() {
            this.dataModel.setStandardConfig();
        }

        void saveConfig() {
            String value = ZrtpConfigurePanel.this.getPropertyValue((Enum)ZrtpConstants.SupportedPubKeys.DH2K);
            String id = ZrtpConfigurePanel.getPropertyID(ZrtpConstants.SupportedPubKeys.DH2K);
            NeomediaActivator.getConfigurationService().setProperty(id, (Object)value);
        }
    }
}

