/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.ChatState;
import org.xmlpull.v1.XmlPullParser;

public class ChatStateExtension
implements PacketExtension {
    private ChatState state;

    public ChatStateExtension(ChatState state) {
        this.state = state;
    }

    @Override
    public String getElementName() {
        return this.state.name();
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/chatstates";
    }

    @Override
    public String toXML() {
        return "<" + this.getElementName() + " xmlns=\"" + this.getNamespace() + "\" />";
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            ChatState state;
            try {
                state = ChatState.valueOf(parser.getName());
            }
            catch (Exception ex) {
                state = ChatState.active;
            }
            return new ChatStateExtension(state);
        }
    }
}

