/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.runner;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.ResultPrinter;
import net.java.sip.communicator.slick.runner.XMLConstants;
import org.jitsi.util.xml.DOMElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlFormatter
extends ResultPrinter
implements XMLConstants {
    private Document doc;
    private Element rootElement;
    private Hashtable<Test, Element> testElements = new Hashtable();
    private Hashtable<Test, Test> failedTests = new Hashtable();
    private Hashtable<Test, Long> testStarts = new Hashtable();
    private OutputStream out;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public XmlFormatter(PrintStream out) {
        super(out);
        this.setOutput(out);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    public void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    public void startTestSuite(Test suite, Properties props) {
        this.doc = XmlFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement("testsuite");
        this.rootElement.setAttribute("name", suite.toString());
        Element propsElement = this.doc.createElement("properties");
        this.rootElement.appendChild(propsElement);
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element propElement = this.doc.createElement("property");
                propElement.setAttribute("name", name);
                propElement.setAttribute("value", props.getProperty(name));
                propsElement.appendChild(propElement);
            }
        }
    }

    public void endTestSuite(Test suite, int err_count, int fail_count, long time) throws RuntimeException {
        this.rootElement.setAttribute("tests", "" + suite.countTestCases());
        this.rootElement.setAttribute("failures", "" + fail_count);
        this.rootElement.setAttribute("errors", "" + err_count);
        this.rootElement.setAttribute("time", "" + (double)time / 1000.0);
        this.rootElement.setAttribute("package", "SIP Communicator SLICK suites");
        if (this.out != null) {
            BufferedWriter wri = null;
            try {
                wri = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
                wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                new DOMElementWriter().write((Node)this.rootElement, (Writer)wri, 0, "  ");
                ((Writer)wri).flush();
            }
            catch (IOException exc) {
                throw new RuntimeException("Unable to write log file", exc);
            }
            finally {
                if (this.out != System.out && this.out != System.err && wri != null) {
                    try {
                        ((Writer)wri).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void startTest(Test test) {
        this.testStarts.put(test, new Long(System.currentTimeMillis()));
    }

    public void endTest(Test test) {
        if (!this.testStarts.containsKey(test)) {
            this.startTest(test);
        }
        Element currentTest = null;
        if (!this.failedTests.containsKey(test)) {
            currentTest = this.doc.createElement("testcase");
            if (test instanceof TestCase) {
                String className = test.getClass().getName();
                className = className.substring(className.lastIndexOf(".") + 1);
                currentTest.setAttribute("name", className + "." + ((TestCase)test).getName());
            } else {
                currentTest.setAttribute("name", test.getClass().getName());
            }
            currentTest.setAttribute("classname", test.getClass().getName());
            this.rootElement.appendChild(currentTest);
            this.testElements.put(test, currentTest);
        } else {
            currentTest = this.testElements.get(test);
        }
        Long l = this.testStarts.get(test);
        currentTest.setAttribute("time", "" + (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("failure", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("error", test, t);
    }

    private void formatError(String type, Test test, Throwable t) {
        if (test != null) {
            this.endTest(test);
            this.failedTests.put(test, test);
        }
        Element nested = this.doc.createElement(type);
        Element currentTest = null;
        currentTest = test != null ? this.testElements.get(test) : this.rootElement;
        currentTest.appendChild(nested);
        String message = t.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute("message", t.getMessage());
        }
        nested.setAttribute("type", t.getClass().getName());
        String strace = XmlFormatter.getStackTrace(t);
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    private void formatOutput(String type, String output) {
        Element nested = this.doc.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.doc.createCDATASection(output));
    }
}

