/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.ctcp;

import com.ircclouds.irc.api.ctcp.DCCSendCallback;
import com.ircclouds.irc.api.ctcp.DCCSendException;
import com.ircclouds.irc.api.ctcp.DCCSendProgressCallback;
import com.ircclouds.irc.api.ctcp.DCCSendResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCSender {
    private static final Logger LOG = LoggerFactory.getLogger(DCCSender.class);
    private static final int READ_BUFFER_SIZE = 1024;
    private Integer timeout;
    private Integer listeningPort;
    private Integer resumePos;
    private DCCSendCallback callback;
    private int totalBytesTransferred;
    private int totalAcksRead;
    private Exception readerExc;
    private Exception writerExc;

    public DCCSender(Integer aPort, Integer aTimeout, DCCSendCallback aCallback) {
        this(aTimeout, aPort, 0, aCallback);
    }

    public DCCSender(int aTimeout, Integer aPort, Integer aResumePosition, DCCSendCallback aCallback) {
        this.timeout = aTimeout;
        this.listeningPort = aPort;
        this.resumePos = aResumePosition;
        this.callback = aCallback;
    }

    public void setResumePosition(int aResumePosition) {
        this.resumePos = aResumePosition;
    }

    public void send(final File aFile) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSocketChannel _ssc = null;
                SocketChannel _sc = null;
                long _timeBefore = 0L;
                try {
                    _timeBefore = System.currentTimeMillis();
                    _ssc = ServerSocketChannel.open();
                    _ssc.configureBlocking(false);
                    _ssc.socket().bind(new InetSocketAddress(DCCSender.this.listeningPort));
                    Selector _selector = Selector.open();
                    _ssc.register(_selector, 16);
                    if (_selector.select(DCCSender.this.timeout.intValue()) > 0 && _selector.selectedKeys().iterator().next().isAcceptable()) {
                        _sc = _ssc.accept();
                        Thread _ar = DCCSender.this.getACKsReader(_sc);
                        _ar.start();
                        if (_sc != null) {
                            DCCSender.this.writeFileToChannel(aFile, _sc);
                        }
                        _ar.join();
                    }
                }
                catch (Exception aExc) {
                    LOG.error("Error Transmitting File", (Throwable)aExc);
                    DCCSender.this.writerExc = aExc;
                }
                finally {
                    if (_ssc != null) {
                        DCCSender.this.close(_ssc);
                    }
                    if (_sc != null) {
                        DCCSender.this.close(_sc);
                    }
                    DCCSender.this.callBack(aFile, System.currentTimeMillis() - _timeBefore);
                }
            }
        }, "DCCSender").start();
    }

    private void callBack(File aFile, final long aTotalTime) {
        DCCSendResult _dccSendRes = new DCCSendResult(){

            @Override
            public int totalBytesSent() {
                return DCCSender.this.totalBytesTransferred;
            }

            @Override
            public int getNumberOfAcksReceived() {
                return DCCSender.this.totalAcksRead;
            }

            @Override
            public long totalTime() {
                return aTotalTime;
            }

            public String toString() {
                return "Total bytes sent: " + DCCSender.this.totalBytesTransferred + " - Number of acks received: " + DCCSender.this.totalAcksRead + " - Total time: " + aTotalTime;
            }
        };
        if ((long)this.totalBytesTransferred == aFile.length()) {
            LOG.debug(_dccSendRes.toString());
            this.callback.onSuccess(_dccSendRes);
        } else {
            DCCSendException _dccSendExc = new DCCSendException(_dccSendRes, this.readerExc, this.writerExc);
            LOG.debug("", (Throwable)_dccSendExc);
            this.callback.onFailure(_dccSendExc);
        }
    }

    private void writeFileToChannel(File aFile, SocketChannel aSocketChannel) throws IOException {
        FileInputStream _fis = new FileInputStream(aFile);
        FileChannel _fc = _fis.getChannel();
        long _size = aFile.length();
        for (long _position = (long)this.resumePos.intValue(); _position < _size; _position += _fc.transferTo(_position, _size - _position, aSocketChannel)) {
        }
        if (_fis != null) {
            this.close(_fis);
        }
        if (_fc != null) {
            this.close(_fc);
        }
    }

    private Thread getACKsReader(final SocketChannel aSocketChannel) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                ByteBuffer _bb = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
                boolean _hasReadData = false;
                boolean _cleared = false;
                try {
                    ProgressReader _pr = DCCSender.this.getProgressReader();
                    int _readCount = 0;
                    DCCSender.this.totalAcksRead = 0;
                    while ((_readCount = aSocketChannel.read(_bb)) > 0) {
                        DCCSender.this.totalAcksRead += _readCount / 4;
                        _pr.read(_bb, _readCount);
                        _hasReadData = true;
                        _cleared = false;
                        if (_bb.hasRemaining()) continue;
                        _bb.clear();
                        _cleared = true;
                    }
                    if (_hasReadData) {
                        if (!_cleared) {
                            _bb.flip();
                            if (_bb.limit() >= 4) {
                                _bb.position(_bb.limit() - 4);
                            }
                        } else {
                            _bb.position(1020);
                        }
                        DCCSender.this.totalBytesTransferred = _bb.getInt();
                    }
                }
                catch (IOException aExc) {
                    LOG.error("Error Reading Acks", (Throwable)aExc);
                    DCCSender.this.readerExc = aExc;
                }
            }
        }, "DCCACKsReader");
    }

    private ProgressReader getProgressReader() {
        ProgressReader _pr = null;
        _pr = this.callback instanceof DCCSendProgressCallback ? new ProgressReaderImpl((DCCSendProgressCallback)this.callback) : new NullProgressReader();
        return _pr;
    }

    private void close(Closeable aCloseable) {
        try {
            aCloseable.close();
        }
        catch (IOException aExc) {
            LOG.error("", (Throwable)aExc);
        }
    }

    class ProgressReaderImpl
    implements ProgressReader {
        DCCSendProgressCallback callback;

        ProgressReaderImpl(DCCSendProgressCallback aCallback) {
            this.callback = aCallback;
        }

        @Override
        public void read(ByteBuffer aByteBuffer, int aReadCount) {
            aByteBuffer.position(aByteBuffer.position() - aReadCount);
            for (int _i = 0; _i < aReadCount / 4; ++_i) {
                this.callback.onProgress(aByteBuffer.getInt());
            }
        }
    }

    class NullProgressReader
    implements ProgressReader {
        NullProgressReader() {
        }

        @Override
        public void read(ByteBuffer aBuffer, int aReadCount) {
        }
    }

    static interface ProgressReader {
        public void read(ByteBuffer var1, int var2);
    }
}

