/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.http;

import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.common.base.CharEscapers;
import com.google.gdata.util.common.base.Charsets;
import com.google.gdata.util.common.base.StringUtil;
import com.google.gdata.util.common.io.CharStreams;
import com.google.gdata.util.common.util.Base64;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Map;

public class AuthSubUtil {
    private static final String DEFAULT_PROTOCOL = "https";
    private static final String DEFAULT_DOMAIN = "www.google.com";
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String getRequestUrl(String nextUrl, String scope, boolean secure, boolean session) {
        return AuthSubUtil.getRequestUrl(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, nextUrl, scope, secure, session);
    }

    public static String getRequestUrl(String protocol, String domain, String nextUrl, String scope, boolean secure, boolean session) {
        StringBuffer url = new StringBuffer(protocol).append("://");
        url.append(domain).append("/accounts/AuthSubRequest");
        AuthSubUtil.addParameter(url, "next", nextUrl);
        AuthSubUtil.addParameter(url, "scope", scope);
        AuthSubUtil.addParameter(url, "secure", secure ? "1" : "0");
        AuthSubUtil.addParameter(url, "session", session ? "1" : "0");
        return url.toString();
    }

    public static String getRequestUrl(String hostedDomain, String nextUrl, String scope, boolean secure, boolean session) {
        return AuthSubUtil.getRequestUrl(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, hostedDomain, nextUrl, scope, secure, session);
    }

    public static String getRequestUrl(String protocol, String domain, String hostedDomain, String nextUrl, String scope, boolean secure, boolean session) {
        StringBuffer url = new StringBuffer(AuthSubUtil.getRequestUrl(protocol, domain, nextUrl, scope, secure, session));
        AuthSubUtil.addParameter(url, "hd", hostedDomain);
        return url.toString();
    }

    public static String getTokenFromReply(URL url) {
        return AuthSubUtil.getTokenFromReply(url.getQuery());
    }

    public static String getTokenFromReply(String queryString) {
        Map<String, String> params = StringUtil.string2Map(queryString, "&", "=", true);
        params = StringUtil.lowercaseKeys(params);
        String encoded = params.get("token");
        try {
            return encoded == null ? null : URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKeyFromKeystore(String keystore, String keystorePass, String keyAlias, String keyPass) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream keyStream = null;){
            keyStream = new FileInputStream(keystore);
            keyStore.load(keyStream, keystorePass.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPass.toCharArray());
            return privateKey;
        }
    }

    public static String exchangeForSessionToken(String onetimeUseToken, PrivateKey key) throws IOException, GeneralSecurityException, AuthenticationException {
        return AuthSubUtil.exchangeForSessionToken(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, onetimeUseToken, key);
    }

    public static String exchangeForSessionToken(String protocol, String domain, String onetimeUseToken, PrivateKey key) throws IOException, GeneralSecurityException, AuthenticationException {
        String sessionUrl = AuthSubUtil.getSessionTokenUrl(protocol, domain);
        URL url = new URL(sessionUrl);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        String header = AuthSubUtil.formAuthorizationHeader(onetimeUseToken, key, url, "GET");
        httpConn.setRequestProperty("Authorization", header);
        if (httpConn.getResponseCode() != 200) {
            throw new AuthenticationException(httpConn.getResponseCode() + ": " + httpConn.getResponseMessage());
        }
        String body = CharStreams.toString(new InputStreamReader(httpConn.getInputStream(), Charsets.ISO_8859_1));
        Map<String, String> parsedTokens = StringUtil.string2Map(body, "\n", "=", true);
        parsedTokens = StringUtil.lowercaseKeys(parsedTokens);
        return parsedTokens.get("token");
    }

    public static Map<String, String> getTokenInfo(String token, PrivateKey key) throws IOException, GeneralSecurityException, AuthenticationException {
        return AuthSubUtil.getTokenInfo(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, token, key);
    }

    public static Map<String, String> getTokenInfo(String protocol, String domain, String token, PrivateKey key) throws IOException, GeneralSecurityException, AuthenticationException {
        String tokenInfoUrl = AuthSubUtil.getTokenInfoUrl(protocol, domain);
        URL url = new URL(tokenInfoUrl);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        String header = AuthSubUtil.formAuthorizationHeader(token, key, url, "GET");
        httpConn.setRequestProperty("Authorization", header);
        if (httpConn.getResponseCode() != 200) {
            throw new AuthenticationException(httpConn.getResponseCode() + ": " + httpConn.getResponseMessage());
        }
        String body = CharStreams.toString(new InputStreamReader(httpConn.getInputStream(), Charsets.ISO_8859_1));
        return StringUtil.string2Map(body.trim(), "\n", "=", true);
    }

    public static void revokeToken(String token, PrivateKey key) throws IOException, GeneralSecurityException, AuthenticationException {
        AuthSubUtil.revokeToken(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, token, key);
    }

    public static void revokeToken(String protocol, String domain, String token, PrivateKey key) throws IOException, GeneralSecurityException, AuthenticationException {
        String revokeUrl = AuthSubUtil.getRevokeTokenUrl(protocol, domain);
        URL url = new URL(revokeUrl);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        String header = AuthSubUtil.formAuthorizationHeader(token, key, url, "GET");
        httpConn.setRequestProperty("Authorization", header);
        if (httpConn.getResponseCode() != 200) {
            throw new AuthenticationException(httpConn.getResponseCode() + ": " + httpConn.getResponseMessage());
        }
    }

    public static String formAuthorizationHeader(String token, PrivateKey key, URL requestUrl, String requestMethod) throws GeneralSecurityException {
        if (key == null) {
            return String.format("AuthSub token=\"%s\"", token);
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = RANDOM.nextLong();
        String dataToSign = String.format("%s %s %d %s", requestMethod, requestUrl.toExternalForm(), timestamp, AuthSubUtil.unsignedLongToString(nonce));
        SignatureAlgorithm sigAlg = AuthSubUtil.getSigAlg(key);
        byte[] signature = AuthSubUtil.sign(key, dataToSign, sigAlg);
        String encodedSignature = Base64.encode(signature);
        return String.format("AuthSub token=\"%s\" data=\"%s\" sig=\"%s\" sigalg=\"%s\"", token, dataToSign, encodedSignature, sigAlg.getAuthSubName());
    }

    private static void addParameter(StringBuffer url, String name, String value) {
        name = CharEscapers.uriEscaper().escape(name);
        value = CharEscapers.uriEscaper().escape(value);
        if (url.indexOf("?") == -1) {
            url.append('?');
        } else {
            switch (url.charAt(url.length() - 1)) {
                case '&': 
                case '?': {
                    break;
                }
                default: {
                    url.append('&');
                }
            }
        }
        url.append(name).append('=').append(value);
    }

    private static byte[] sign(PrivateKey key, String data, SignatureAlgorithm algorithm) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(algorithm.getJCAName());
        signature.initSign(key);
        signature.update(data.getBytes());
        return signature.sign();
    }

    private static SignatureAlgorithm getSigAlg(PrivateKey key) {
        String algorithm = key.getAlgorithm();
        if ("dsa".equalsIgnoreCase(algorithm)) {
            return SignatureAlgorithm.DSA_SHA1;
        }
        if ("rsa".equalsIgnoreCase(algorithm)) {
            return SignatureAlgorithm.RSA_SHA1;
        }
        throw new IllegalArgumentException("Unknown algorithm in private key.");
    }

    private static String getSessionTokenUrl(String protocol, String domain) {
        return protocol + "://" + domain + "/accounts/AuthSubSessionToken";
    }

    private static String getRevokeTokenUrl(String protocol, String domain) {
        return protocol + "://" + domain + "/accounts/AuthSubRevokeToken";
    }

    private static String getTokenInfoUrl(String protocol, String domain) {
        return protocol + "://" + domain + "/accounts/AuthSubTokenInfo";
    }

    private static String unsignedLongToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        int max_dig = 20;
        char[] cbuf = new char[max_dig];
        int radix = 10;
        int dst = max_dig;
        long top = value >>> 32;
        long bot = value & 0xFFFFFFFFL;
        bot += top % (long)radix << 32;
        top /= (long)radix;
        while (bot > 0L || top > 0L) {
            cbuf[--dst] = Character.forDigit((int)(bot % (long)radix), radix);
            bot = bot / (long)radix + (top % (long)radix << 32);
            top /= (long)radix;
        }
        return new String(cbuf, dst, max_dig - dst);
    }

    private static enum SignatureAlgorithm {
        DSA_SHA1("dsa-sha1", "SHA1withDSA"),
        RSA_SHA1("rsa-sha1", "SHA1withRSA");

        private final String authSubName;
        private final String jcaName;

        private SignatureAlgorithm(String authSubName, String jcaName) {
            this.authSubName = authSubName;
            this.jcaName = jcaName;
        }

        public String toString() {
            return this.jcaName;
        }

        public String getAuthSubName() {
            return this.authSubName;
        }

        public String getJCAName() {
            return this.jcaName;
        }
    }
}

