/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="extendedProperty")
public class ExtendedProperty
extends ExtensionPoint {
    static final String EXTENDED_PROPERTY = "extendedProperty";
    protected String name;
    protected String val;
    protected String realm;

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getValue() {
        return this.val;
    }

    public void setValue(String v) {
        this.val = v;
    }

    public boolean hasValue() {
        return this.val != null;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String r) {
        this.realm = r;
    }

    public boolean hasRealm() {
        return this.realm != null;
    }

    public String toString() {
        return "<" + this.name + "=" + (this.hasValue() ? this.val : "") + "|" + (this.hasRealm() ? this.realm : "") + ">";
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(ExtendedProperty.class);
        desc.setNamespace(Namespaces.gNs);
        desc.setLocalName(EXTENDED_PROPERTY);
        desc.setRepeatable(true);
        return desc;
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.name != null) {
            attrs.add(new XmlWriter.Attribute("name", this.name));
        }
        if (this.val != null) {
            attrs.add(new XmlWriter.Attribute("value", this.val));
        }
        if (this.realm != null) {
            attrs.add(new XmlWriter.Attribute("realm", this.realm));
        }
        this.generateStartElement(w, Namespaces.gNs, EXTENDED_PROPERTY, attrs, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, EXTENDED_PROPERTY);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    @Override
    protected void initializeArbitraryXml(ExtensionProfile profile, Class<? extends ExtensionPoint> extPoint, XmlParser.ElementHandler handler) {
        handler.initializeXmlBlob(this.xmlBlob, true, false);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(extProfile, ExtendedProperty.class);
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) {
            if (namespace.equals("")) {
                if (localName.equals("name")) {
                    ExtendedProperty.this.name = value;
                } else if (localName.equals("value")) {
                    ExtendedProperty.this.val = value;
                } else if (localName.equals("realm")) {
                    ExtendedProperty.this.realm = value;
                }
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            if (ExtendedProperty.this.name == null) {
                throw new ParseException(CoreErrorDomain.ERR.nameRequired);
            }
            XmlBlob xmlBlob = ExtendedProperty.this.getXmlBlob();
            if (ExtendedProperty.this.val != null && xmlBlob.getBlob() != null) {
                throw new ParseException(CoreErrorDomain.ERR.valueXmlMutuallyExclusive);
            }
            if (ExtendedProperty.this.val == null && xmlBlob.getBlob() == null) {
                throw new ParseException(CoreErrorDomain.ERR.valueOrXmlRequired);
            }
        }
    }

    public static final class Realm {
        public static final String SHARED = "http://schemas.google.com/g/2005#shared";
    }
}

