/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.msoutlook.calendar;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import net.java.sip.communicator.plugin.addrbook.msoutlook.calendar.CalendarItemTimerTask;
import net.java.sip.communicator.service.calendar.CalendarService;

public class RecurringPattern {
    private short recurFrequency;
    private PatternType patternType;
    private short calendarType;
    private int firstDateTime;
    private int period;
    private int slidingFlag;
    private int patternSpecific1;
    private int patternSpecific2;
    private int endType;
    private int occurenceCount;
    private int firstDow;
    private int deletedInstanceCount;
    private int modifiedInstanceCount;
    private int startDate;
    private int endDate;
    private List<Date> deletedInstances = new ArrayList<Date>();
    private int[] modifiedInstances;
    private List<ExceptionInfo> exceptionInfo;
    private CalendarItemTimerTask sourceTask;
    private List<Integer> allowedDaysOfWeek = new LinkedList<Integer>();
    private ByteBuffer dataBuffer;
    public static int[] weekOfDayMask = new int[]{1, 2, 4, 8, 16, 32, 64};

    public RecurringPattern(byte[] data, CalendarItemTimerTask sourceTask) throws IndexOutOfBoundsException {
        int i;
        this.sourceTask = sourceTask;
        this.dataBuffer = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int offset = 4;
        this.recurFrequency = this.dataBuffer.getShort(offset);
        this.patternType = PatternType.getFromShort(this.dataBuffer.getShort(offset += 2));
        this.calendarType = this.dataBuffer.getShort(offset += 2);
        this.firstDateTime = this.dataBuffer.getInt(offset += 2);
        this.period = this.dataBuffer.getInt(offset += 4);
        this.slidingFlag = this.dataBuffer.getInt(offset += 4);
        offset += 4;
        switch (this.patternType) {
            case Week: 
            case Month: 
            case MonthEnd: 
            case HjMonth: 
            case HjMonthEnd: {
                int day;
                this.patternSpecific1 = this.dataBuffer.getInt(offset);
                this.patternSpecific2 = 0;
                offset += 4;
                if (this.patternType != PatternType.Week) break;
                for (day = this.firstDow; day < this.firstDow + 7; ++day) {
                    if ((this.patternSpecific1 & weekOfDayMask[day % 7]) == 0) continue;
                    this.allowedDaysOfWeek.add(day % 7 + 1);
                }
                break;
            }
            case MonthNth: 
            case HjMonthNth: {
                int day;
                this.patternSpecific1 = this.dataBuffer.getInt(offset);
                this.patternSpecific2 = this.dataBuffer.getInt(offset + 4);
                if (this.patternSpecific1 == 127 && this.patternSpecific2 != 5) {
                    this.patternType = PatternType.Month;
                }
                for (day = 0; day < 7; ++day) {
                    if ((this.patternSpecific1 & weekOfDayMask[day]) == 0) continue;
                    this.allowedDaysOfWeek.add(day + 1);
                }
                offset += 8;
                break;
            }
        }
        this.endType = this.dataBuffer.getInt(offset);
        this.occurenceCount = this.dataBuffer.getInt(offset += 4);
        this.firstDow = this.dataBuffer.getInt(offset += 4);
        this.deletedInstanceCount = this.dataBuffer.getInt(offset += 4);
        offset += 4;
        for (i = 0; i < this.deletedInstanceCount; ++i) {
            this.deletedInstances.add(RecurringPattern.windowsTimeToDateObject(this.dataBuffer.getInt(offset)));
            offset += 4;
        }
        this.modifiedInstanceCount = this.dataBuffer.getInt(offset);
        offset += 4;
        this.modifiedInstances = new int[this.modifiedInstanceCount];
        for (i = 0; i < this.modifiedInstanceCount; ++i) {
            this.modifiedInstances[i] = this.dataBuffer.getInt(offset);
            offset += 4;
        }
        this.startDate = this.dataBuffer.getInt(offset);
        this.endDate = this.dataBuffer.getInt(offset += 4);
        offset += 4;
        int exceptionCount = this.dataBuffer.getShort(offset += 16);
        offset += 2;
        this.exceptionInfo = new ArrayList<ExceptionInfo>(exceptionCount);
        for (int i2 = 0; i2 < exceptionCount; ++i2) {
            ExceptionInfo tmpExceptionInfo = new ExceptionInfo(offset);
            this.exceptionInfo.add(tmpExceptionInfo);
            offset += tmpExceptionInfo.sizeInBytes();
            CalendarService.BusyStatusEnum status = tmpExceptionInfo.getBusyStatus();
            Date startTime = tmpExceptionInfo.getStartDate();
            Date endTime = tmpExceptionInfo.getEndDate();
            if (status == CalendarService.BusyStatusEnum.FREE || startTime == null || endTime == null) continue;
            Date currentTime = new Date();
            if (endTime.before(currentTime) || endTime.equals(currentTime)) {
                return;
            }
            boolean executeNow = false;
            if (startTime.before(currentTime) || startTime.equals(currentTime)) {
                executeNow = true;
            }
            CalendarItemTimerTask task = new CalendarItemTimerTask(status, startTime, endTime, sourceTask.getId(), executeNow, this);
            task.scheduleTasks();
        }
    }

    public static Date windowsTimeToDateObject(long time) {
        long date = time * 60000L - 11644473600000L;
        date -= (long)TimeZone.getDefault().getOffset(date);
        return new Date(date);
    }

    public String toString() {
        int i;
        String result = "";
        result = result + "recurFrequency: " + String.format("%#02x", this.recurFrequency) + "\n";
        result = result + "patternType: " + String.format("%#02x", this.patternType.getValue()) + "\n";
        result = result + "calendarType: " + String.format("%#02x", this.calendarType) + "\n";
        result = result + "endType: " + String.format("%#04x", this.endType) + "\n";
        result = result + "period: " + this.period + "\n";
        result = result + "occurenceCount: " + String.format("%#04x", this.occurenceCount) + "\n";
        result = result + "patternSpecific1: " + String.format("%#04x", this.patternSpecific1) + "\n";
        result = result + "patternSpecific2: " + String.format("%#04x", this.patternSpecific2) + "\n";
        result = result + "startDate hex: " + String.format("%#04x", this.startDate) + "\n";
        result = result + "endDate hex: " + String.format("%#04x", this.endDate) + "\n";
        result = result + "startDate: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(RecurringPattern.windowsTimeToDateObject(this.startDate)) + "\n";
        result = result + "endDate: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(RecurringPattern.windowsTimeToDateObject(this.endDate)) + "\n";
        for (i = 0; i < this.modifiedInstanceCount; ++i) {
            result = result + "modified Instance date hex: " + String.format("%#04x", this.modifiedInstances[i]) + "\n";
            result = result + "modified Instance date: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(RecurringPattern.windowsTimeToDateObject(this.modifiedInstances[i])) + "\n";
        }
        for (i = 0; i < this.deletedInstanceCount; ++i) {
            result = result + "deleted Instance date: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(this.deletedInstances.get(i)) + "\n";
        }
        result = result + "patternSpecific2: " + String.format("%#04x", this.patternSpecific2) + "\n";
        result = result + "\n\n =====================Exeptions====================\n\n";
        for (ExceptionInfo info : this.exceptionInfo) {
            result = result + info.toString() + "\n\n";
        }
        return result;
    }

    private boolean dateOutOfRange(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return this.endType != 8227 && this.endType != -1 && cal.getTime().after(RecurringPattern.windowsTimeToDateObject(this.endDate));
    }

    public CalendarItemTimerTask next(Date previousStartDate, Date previousEndDate) {
        if (this.dateOutOfRange(new Date())) {
            return null;
        }
        Date startDate = previousStartDate;
        Date endDate = null;
        boolean executeNow = false;
        long duration = this.sourceTask.getEndDate().getTime() - this.sourceTask.getStartDate().getTime();
        switch (this.patternType) {
            case Day: {
                startDate = new Date(startDate.getTime() + (long)(this.period * 60000));
                endDate = new Date(previousEndDate.getTime() + (long)(this.period * 60000));
                Date currentDate = new Date();
                if (endDate.before(currentDate)) {
                    long offset = currentDate.getTime() - endDate.getTime();
                    offset -= offset % (long)(this.period * 60000);
                    if (endDate.getTime() + offset < currentDate.getTime()) {
                        offset += (long)(this.period * 60000);
                    }
                    startDate = new Date(startDate.getTime() + offset);
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(startDate);
                Calendar cal2 = (Calendar)cal.clone();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                while (this.deletedInstances.contains(cal.getTime())) {
                    cal.add(12, this.period);
                    cal2.add(12, this.period);
                }
                if (this.dateOutOfRange(cal.getTime())) {
                    return null;
                }
                startDate = cal2.getTime();
                endDate = new Date(startDate.getTime() + duration);
                if (startDate.before(currentDate)) {
                    executeNow = true;
                }
                return new CalendarItemTimerTask(this.sourceTask.getStatus(), startDate, endDate, this.sourceTask.getId(), executeNow, this);
            }
            case Week: {
                Calendar cal = Calendar.getInstance();
                cal.setFirstDayOfWeek(this.firstDow + 1);
                cal.setTime(startDate);
                int dayOfWeek = cal.get(7);
                int index = this.allowedDaysOfWeek.indexOf(dayOfWeek);
                if (++index < this.allowedDaysOfWeek.size()) {
                    cal.set(7, this.allowedDaysOfWeek.get(index));
                    startDate = cal.getTime();
                    endDate = new Date(startDate.getTime() + duration);
                } else {
                    cal.set(7, this.allowedDaysOfWeek.get(0));
                    cal.add(3, this.period);
                    startDate = cal.getTime();
                    endDate = new Date(startDate.getTime() + duration);
                }
                Date currentDate = new Date();
                if (endDate.before(currentDate)) {
                    cal.set(7, this.allowedDaysOfWeek.get(0));
                    endDate = new Date(cal.getTimeInMillis() + duration);
                    long offset = currentDate.getTime() - endDate.getTime();
                    offset -= offset % (long)(this.period * 604800000);
                    if (endDate.getTime() + offset < currentDate.getTime()) {
                        cal.add(3, (int)(offset / (long)(this.period * 604800000)));
                        int i = 1;
                        while (cal.getTimeInMillis() + duration < currentDate.getTime()) {
                            if (i == this.allowedDaysOfWeek.size()) {
                                cal.add(3, this.period);
                                i = 0;
                            }
                            cal.set(7, this.allowedDaysOfWeek.get(i));
                            ++i;
                        }
                        startDate = cal.getTime();
                    } else {
                        startDate = new Date(cal.getTimeInMillis() + offset);
                    }
                }
                cal.setTime(startDate);
                Calendar cal2 = (Calendar)cal.clone();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                dayOfWeek = cal.get(7);
                index = this.allowedDaysOfWeek.indexOf(dayOfWeek) + 1;
                while (this.deletedInstances.contains(cal.getTime())) {
                    if (index >= this.allowedDaysOfWeek.size()) {
                        index = 0;
                        cal.add(3, this.period);
                        cal2.add(3, this.period);
                    }
                    cal.set(7, this.allowedDaysOfWeek.get(index));
                    cal2.set(7, this.allowedDaysOfWeek.get(index));
                    ++index;
                }
                startDate = cal2.getTime();
                endDate = new Date(startDate.getTime() + duration);
                if (this.dateOutOfRange(endDate)) {
                    return null;
                }
                if (startDate.before(currentDate)) {
                    executeNow = true;
                }
                return new CalendarItemTimerTask(this.sourceTask.getStatus(), startDate, endDate, this.sourceTask.getId(), executeNow, this);
            }
            case Month: 
            case MonthEnd: 
            case HjMonth: 
            case HjMonthEnd: {
                return this.nextMonth(startDate, endDate, false);
            }
            case MonthNth: 
            case HjMonthNth: {
                if (this.patternSpecific1 == 127 && this.patternSpecific2 == 5) {
                    return this.nextMonth(startDate, endDate, true);
                }
                return this.nextMonthN(startDate, endDate);
            }
        }
        return null;
    }

    private Calendar incrementMonths(Calendar cal, boolean lastDay, int period) {
        int dayOfMonth = this.patternSpecific1;
        cal.set(5, 1);
        cal.add(2, period);
        if (lastDay || cal.getActualMaximum(5) < dayOfMonth) {
            dayOfMonth = cal.getActualMaximum(5);
        }
        cal.set(5, dayOfMonth);
        return cal;
    }

    public CalendarItemTimerTask nextMonth(Date startDate, Date endDate, boolean lastDay) {
        Calendar cal2;
        long duration = this.sourceTask.getEndDate().getTime() - this.sourceTask.getStartDate().getTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal = this.incrementMonths(cal, lastDay, this.period);
        Date currentDate = new Date();
        if (cal.getTimeInMillis() + duration < currentDate.getTime()) {
            int months;
            cal2 = Calendar.getInstance();
            cal2.setTime(currentDate);
            int years = cal2.get(1) - cal.get(1);
            int monthsToAdd = months = years * 12 + (cal2.get(2) - cal.get(2));
            cal = this.incrementMonths(cal, lastDay, monthsToAdd -= months % this.period);
            if (cal.getTimeInMillis() + duration < currentDate.getTime()) {
                cal = this.incrementMonths(cal, lastDay, this.period);
            }
        }
        cal2 = (Calendar)cal.clone();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        while (this.deletedInstances.contains(cal.getTime())) {
            cal = this.incrementMonths(cal, lastDay, this.period);
            cal2 = this.incrementMonths(cal2, lastDay, this.period);
        }
        startDate = cal2.getTime();
        endDate = new Date(startDate.getTime() + duration);
        if (this.dateOutOfRange(endDate)) {
            return null;
        }
        boolean executeNow = startDate.before(currentDate);
        return new CalendarItemTimerTask(this.sourceTask.getStatus(), startDate, endDate, this.sourceTask.getId(), executeNow, this);
    }

    private Date getMonthNStartDate(Date startDate, int dayOfWeekInMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (dayOfWeekInMonth == -1) {
            Date result = null;
            cal.set(8, dayOfWeekInMonth);
            for (int day : this.allowedDaysOfWeek) {
                cal.set(7, day);
                if (result != null && !result.before(cal.getTime())) continue;
                result = cal.getTime();
            }
            return result;
        }
        while (dayOfWeekInMonth > 0) {
            int dayOfWeek = cal.get(7);
            if (this.allowedDaysOfWeek.contains(dayOfWeek)) {
                --dayOfWeekInMonth;
            }
            if (dayOfWeekInMonth <= 0) continue;
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    public CalendarItemTimerTask nextMonthN(Date startDate, Date endDate) {
        Calendar cal2;
        int dayOfWeekInMonth = this.patternSpecific2 == 5 ? -1 : this.patternSpecific2;
        long duration = this.sourceTask.getEndDate().getTime() - this.sourceTask.getStartDate().getTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(5, 1);
        cal.add(2, this.period);
        cal.setTime(this.getMonthNStartDate(cal.getTime(), dayOfWeekInMonth));
        Date currentDate = new Date();
        if (cal.getTimeInMillis() + duration < currentDate.getTime()) {
            int months;
            cal2 = Calendar.getInstance();
            cal2.setTime(currentDate);
            int years = cal2.get(1) - cal.get(1);
            int monthsToAdd = months = years * 12 + (cal2.get(2) - cal.get(2));
            cal.set(5, 1);
            cal.add(2, monthsToAdd -= months % this.period);
            cal.setTime(this.getMonthNStartDate(cal.getTime(), dayOfWeekInMonth));
            if (cal.getTimeInMillis() + duration < currentDate.getTime()) {
                cal.set(5, 1);
                cal.add(2, monthsToAdd);
                cal.setTime(this.getMonthNStartDate(cal.getTime(), dayOfWeekInMonth));
            }
        }
        cal2 = (Calendar)cal.clone();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        while (this.deletedInstances.contains(cal.getTime())) {
            cal.set(5, 1);
            cal.add(2, this.period);
            startDate = null;
            for (int dayOfWeek : this.allowedDaysOfWeek) {
                cal.set(7, dayOfWeek);
                cal.set(8, dayOfWeekInMonth);
                if (!(cal.after(startDate) && dayOfWeekInMonth == -1 || cal.before(startDate) && dayOfWeekInMonth != -1) && startDate != null) continue;
                startDate = cal.getTime();
                cal2.set(1, cal.get(1));
                cal2.set(2, cal.get(2));
                cal2.set(5, cal.get(5));
            }
        }
        startDate = cal2.getTime();
        endDate = new Date(startDate.getTime() + duration);
        if (this.dateOutOfRange(endDate)) {
            return null;
        }
        boolean executeNow = false;
        if (startDate.before(currentDate)) {
            executeNow = true;
        }
        return new CalendarItemTimerTask(this.sourceTask.getStatus(), startDate, endDate, this.sourceTask.getId(), executeNow, this);
    }

    public class ExceptionInfo {
        private final Date startDate;
        private final Date endDate;
        private final Date originalStartDate;
        private final short overrideFlags;
        private CalendarService.BusyStatusEnum busyStatus;
        private int size = 22;

        public ExceptionInfo(int offset) {
            int[] fieldMasks;
            this.startDate = RecurringPattern.windowsTimeToDateObject(RecurringPattern.this.dataBuffer.getInt(offset));
            this.endDate = RecurringPattern.windowsTimeToDateObject(RecurringPattern.this.dataBuffer.getInt(offset += 4));
            this.originalStartDate = RecurringPattern.windowsTimeToDateObject(RecurringPattern.this.dataBuffer.getInt(offset += 4));
            this.overrideFlags = RecurringPattern.this.dataBuffer.getShort(offset += 4);
            offset += 2;
            for (int mask : fieldMasks = new int[]{1, 2, 4, 8, 16, 32, 64, 128}) {
                if (mask == 32) {
                    if ((this.overrideFlags & mask) != 0) {
                        this.busyStatus = CalendarService.BusyStatusEnum.getFromLong(Long.valueOf(RecurringPattern.this.dataBuffer.getInt(offset)));
                    }
                    if (this.busyStatus == null) {
                        this.busyStatus = RecurringPattern.this.sourceTask.getStatus();
                    }
                }
                if ((this.overrideFlags & mask) == 0) continue;
                if (mask == 16 || mask == 1) {
                    short size = RecurringPattern.this.dataBuffer.getShort(offset + 2);
                    offset += size;
                    size = (short)(size + size);
                }
                offset += 4;
                this.size += 4;
            }
            short reservedBlockSize = RecurringPattern.this.dataBuffer.getShort(offset += 4);
            this.size += reservedBlockSize;
        }

        public int sizeInBytes() {
            return this.size;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public CalendarService.BusyStatusEnum getBusyStatus() {
            return this.busyStatus;
        }

        public String toString() {
            String result = "";
            result = result + "startDate: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(this.startDate) + "\n";
            result = result + "endDate: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(this.endDate) + "\n";
            result = result + "originalStartDate: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(this.originalStartDate) + "\n";
            return result;
        }
    }

    public static enum PatternType {
        Day(0),
        Week(1),
        Month(2),
        MonthNth(3),
        MonthEnd(4),
        HjMonth(10),
        HjMonthNth(11),
        HjMonthEnd(12);

        private final short value;

        private PatternType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static PatternType getFromShort(short value) {
            for (PatternType type : PatternType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return null;
        }
    }
}

