/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.sip.communicator.plugin.pluginmanager.Resources;

public class TitlePanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    public static final Color BORDER_COLOR = new Color(Resources.getColor("service.gui.BORDER_COLOR"));
    private static final int GRADIENT_SIZE = 10;
    private static final Color GRADIENT_DARK_COLOR = new Color(Resources.getColor("service.gui.GRADIENT_DARK_COLOR"));
    private static final Color GRADIENT_LIGHT_COLOR = new Color(Resources.getColor("service.gui.GRADIENT_LIGHT_COLOR"));
    private JLabel titleLabel = new JLabel();

    public TitlePanel() {
        super(new FlowLayout(1));
        this.setPreferredSize(new Dimension(0, 30));
        this.titleLabel.setFont(this.getFont().deriveFont(1, 14.0f));
    }

    public TitlePanel(String title) {
        super(new FlowLayout(1));
        this.titleLabel.setFont(this.getFont().deriveFont(1, 14.0f));
        this.titleLabel.setText(title);
        this.add(this.titleLabel);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint p = new GradientPaint(this.getWidth() / 2, 0.0f, GRADIENT_DARK_COLOR, this.getWidth() / 2, 10.0f, GRADIENT_LIGHT_COLOR);
        GradientPaint p1 = new GradientPaint(this.getWidth() / 2, this.getHeight() - 10, GRADIENT_LIGHT_COLOR, this.getWidth() / 2, this.getHeight(), GRADIENT_DARK_COLOR);
        g2.setPaint(p);
        g2.fillRect(0, 0, this.getWidth(), 10);
        g2.setColor(GRADIENT_LIGHT_COLOR);
        g2.fillRect(0, 10, this.getWidth(), this.getHeight() - 10);
        g2.setPaint(p1);
        g2.fillRect(0, this.getHeight() - 10 - 1, this.getWidth(), this.getHeight() - 1);
        g2.setColor(BORDER_COLOR);
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
    }

    public void setTitleText(String title) {
        this.titleLabel.setText(title);
        this.add(this.titleLabel);
    }
}

