/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommButtonUI
extends MetalButtonUI
implements Skinnable {
    private static BufferedImage buttonBG = ImageLoader.getImage(ImageLoader.BUTTON);
    private static BufferedImage buttonRolloverBG = ImageLoader.getImage(ImageLoader.BUTTON_ROLLOVER);
    private boolean bufferIsRollover = false;
    private BufferedImage paintBuffer = null;
    private Component bufferedComponent = null;

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.setFocusPainted(true);
        b.setRolloverEnabled(true);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorderPainted(true);
        b.setFocusPainted(false);
        b.setOpaque(true);
        b.setRolloverEnabled(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (this.paintBuffer == null || c != this.bufferedComponent || this.bufferIsRollover != model.isRollover()) {
            BufferedImage rightImg;
            BufferedImage middleImg;
            BufferedImage leftImg;
            this.paintBuffer = ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage(c.getWidth(), c.getHeight(), 3);
            this.bufferedComponent = c;
            this.bufferIsRollover = model.isRollover();
            int indentWidth = 10;
            if (this.bufferIsRollover) {
                int imgWidth = buttonRolloverBG.getWidth();
                int imgHeight = buttonRolloverBG.getHeight();
                leftImg = buttonRolloverBG.getSubimage(0, 0, indentWidth, imgHeight);
                middleImg = buttonRolloverBG.getSubimage(indentWidth, 0, imgWidth - 2 * indentWidth, imgHeight);
                rightImg = buttonRolloverBG.getSubimage(imgWidth - indentWidth, 0, indentWidth, imgHeight);
            } else {
                int imgWidth = buttonBG.getWidth();
                int imgHeight = buttonBG.getHeight();
                leftImg = buttonBG.getSubimage(0, 0, 10, imgHeight);
                middleImg = buttonBG.getSubimage(10, 0, imgWidth - 20, imgHeight);
                rightImg = buttonBG.getSubimage(imgWidth - 10, 0, 10, imgHeight);
            }
            Graphics2D g2 = this.paintBuffer.createGraphics();
            AntialiasingManager.activateAntialiasing((Graphics)g2);
            g2.drawImage(leftImg, 0, 0, indentWidth, c.getHeight(), null);
            g2.drawImage(middleImg, indentWidth, 0, c.getWidth() - 2 * indentWidth, c.getHeight(), null);
            g2.drawImage(rightImg, c.getWidth() - indentWidth, 0, indentWidth, c.getHeight(), null);
        }
        AntialiasingManager.activateAntialiasing((Graphics)g);
        g.drawImage(this.paintBuffer, 0, 0, c.getWidth(), c.getHeight(), 0, 0, c.getWidth(), c.getHeight(), null);
        super.paint(g, c);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Graphics2D g2 = (Graphics2D)g;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g2.setStroke(new BasicStroke(0.5f, 1, 1, 10.0f, new float[]{1.0f, 1.0f}, 2.0f));
        g2.setColor(Color.GRAY);
        g2.drawRoundRect(focusRect.x - 3, focusRect.y - 3, focusRect.width + 4, focusRect.height + 4, 5, 5);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            g.fillRoundRect(0, 0, size.width, size.height, 5, 5);
        }
    }

    public void loadSkin() {
        buttonBG = ImageLoader.getImage(ImageLoader.BUTTON);
        buttonRolloverBG = ImageLoader.getImage(ImageLoader.BUTTON_ROLLOVER);
        this.paintBuffer = null;
    }
}

