/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListUtils;
import net.java.sip.communicator.impl.gui.main.contactlist.addgroup.CreateGroupDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListAdapter;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactlist.event.ProtoContactEvent;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.gui.WindowID;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.StringUtils;

public class AddContactDialog
extends SIPCommDialog
implements ExportedWindow,
ActionListener,
WindowFocusListener,
Skinnable {
    private JLabel accountLabel;
    private JComboBox accountCombo;
    private JLabel groupLabel;
    private JComboBox groupCombo;
    private JLabel contactAddressLabel;
    private JLabel displayNameLabel;
    private JTextField contactAddressField;
    private JTextField displayNameField;
    private JButton addButton;
    private JButton cancelButton;
    private MetaContact metaContact;
    private boolean initialized = false;
    private JLabel imageLabel;

    public AddContactDialog(Frame parentWindow) {
        super(parentWindow);
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT"));
    }

    public AddContactDialog(Frame parentWindow, MetaContact metaContact) {
        this(parentWindow);
        this.metaContact = metaContact;
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_TO") + " " + metaContact.getDisplayName());
    }

    public void setSelectedAccount(ProtocolProviderService protocolProvider) {
        if (!this.initialized) {
            this.init();
        }
        this.accountCombo.setSelectedItem(protocolProvider);
    }

    public void setSelectedGroup(MetaContactGroup group) {
        if (!this.initialized) {
            this.init();
        }
        this.groupCombo.setSelectedItem(group);
    }

    public void setContactAddress(String contactAddress) {
        if (!this.initialized) {
            this.init();
        }
        this.contactAddressField.setText(contactAddress);
    }

    public void setDisplayName(String displayName) {
        if (!this.initialized) {
            this.init();
        }
        this.displayNameField.setText(displayName);
    }

    private void addPrompt(JTextField field, String text) {
        final JLabel prompt = new JLabel(text);
        Color fg = field.getForeground();
        Color color = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 128);
        prompt.setFont(field.getFont());
        prompt.setForeground(color);
        prompt.setBorder(new EmptyBorder(field.getInsets()));
        prompt.setHorizontalAlignment(10);
        final Document doc = field.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                prompt.setVisible(doc.getLength() == 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                prompt.setVisible(doc.getLength() == 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        field.setLayout(new BorderLayout());
        field.add(prompt);
    }

    private void init() {
        String displayNameInfo = GuiActivator.getResources().getI18NString("service.gui.DISPLAY_NAME_INFO");
        String contactInfo = GuiActivator.getResources().getI18NString("service.gui.CONTACT_NAME_INFO");
        String accountInfo = GuiActivator.getResources().getI18NString("service.gui.SELECT_ACCOUNT_INFO");
        String groupInfo = GuiActivator.getResources().getI18NString("service.gui.SELECT_GROUP_INFO");
        this.accountLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_ACCOUNT") + ": ");
        this.accountLabel.setToolTipText(accountInfo);
        this.accountCombo = new JComboBox();
        this.accountCombo.setToolTipText(accountInfo);
        this.contactAddressLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.CONTACT_NAME") + ": ");
        this.contactAddressLabel.setToolTipText(contactInfo);
        this.displayNameLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.DISPLAY_NAME") + ": ");
        this.displayNameLabel.setToolTipText(displayNameInfo);
        this.contactAddressField = new JTextField();
        this.contactAddressField.setToolTipText(contactInfo);
        this.addPrompt(this.contactAddressField, GuiActivator.getResources().getI18NString("service.gui.CONTACT_NAME_PROMPT"));
        this.displayNameField = new JTextField();
        this.displayNameField.setToolTipText(displayNameInfo);
        this.addPrompt(this.displayNameField, GuiActivator.getResources().getI18NString("service.gui.DISPLAY_NAME_PROMPT"));
        this.groupLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_GROUP") + ": ");
        this.groupLabel.setToolTipText(groupInfo);
        this.addButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.ADD"));
        this.cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
        this.imageLabel = new JLabel();
        this.groupCombo = AddContactDialog.createGroupCombo((Dialog)((Object)this));
        this.groupCombo.setToolTipText(groupInfo);
        if (this.metaContact != null) {
            this.groupCombo.setEnabled(false);
            this.groupCombo.setSelectedItem(this.metaContact.getParentMetaContactGroup());
        }
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        TransparentPanel fieldsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 5, 5));
        this.initAccountCombo();
        this.accountCombo.setRenderer(new AccountComboRenderer());
        if (this.accountCombo.getItemCount() > 2 || this.accountCombo.getItemCount() == 2 && !ConfigurationUtils.isHideAccountSelectionWhenPossibleEnabled()) {
            labelsPanel.add((Component)this.accountLabel);
            fieldsPanel.add((Component)this.accountCombo);
        }
        labelsPanel.add((Component)this.contactAddressLabel);
        fieldsPanel.add((Component)this.contactAddressField);
        labelsPanel.add((Component)this.displayNameLabel);
        fieldsPanel.add((Component)this.displayNameField);
        labelsPanel.add((Component)this.groupLabel);
        fieldsPanel.add((Component)this.groupCombo);
        this.contactAddressField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddContactDialog.this.updateAddButtonState(false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddContactDialog.this.updateAddButtonState(false);
            }
        });
        TransparentPanel dataPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        dataPanel.add((Component)labelsPanel, (Object)"West");
        dataPanel.add((Component)fieldsPanel);
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(20, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        mainPanel.add((Component)this.imageLabel, (Object)"West");
        mainPanel.add((Component)dataPanel, (Object)"Center");
        mainPanel.add((Component)this.createButtonsPanel(), (Object)"South");
        this.getContentPane().add((Component)mainPanel, "Center");
        if (ConfigurationUtils.isHideAccountSelectionWhenPossibleEnabled()) {
            this.setPreferredSize(new Dimension(450, 205));
        } else {
            this.setPreferredSize(new Dimension(450, 250));
        }
        this.setResizable(false);
        this.addWindowFocusListener(this);
        this.loadSkin();
        this.initialized = true;
    }

    private Container createButtonsPanel() {
        TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        this.getRootPane().setDefaultButton(this.addButton);
        this.addButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ADD"));
        this.cancelButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.addButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        buttonsPanel.add((Component)this.addButton);
        buttonsPanel.add((Component)this.cancelButton);
        this.addButton.setEnabled(false);
        return buttonsPanel;
    }

    private void initAccountCombo() {
        Iterator providers = AccountUtils.getRegisteredProviders().iterator();
        this.accountCombo.addItem(GuiActivator.getResources().getI18NString("service.gui.SELECT_ACCOUNT"));
        this.accountCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AddContactDialog.this.updateAddButtonState(true);
            }
        });
        while (providers.hasNext()) {
            OperationSetPersistentPresencePermissions opSetPermissions;
            OperationSet opSet;
            ProtocolProviderService provider = (ProtocolProviderService)providers.next();
            if (provider.getAccountID().isHidden() || (opSet = provider.getOperationSet(OperationSetPresence.class)) == null || (opSetPermissions = (OperationSetPersistentPresencePermissions)provider.getOperationSet(OperationSetPersistentPresencePermissions.class)) != null && opSetPermissions.isReadOnly()) continue;
            this.accountCombo.addItem(provider);
            if (!provider.getAccountID().isPreferredProvider()) continue;
            this.accountCombo.setSelectedItem(provider);
        }
        if (this.accountCombo.getItemCount() == 2) {
            this.accountCombo.setSelectedIndex(1);
        }
    }

    public static JComboBox createGroupCombo(final Dialog parentDialog) {
        final JComboBox<Object> groupCombo = new JComboBox<Object>();
        groupCombo.setRenderer(new GroupComboRenderer());
        AddContactDialog.updateGroupItems(groupCombo, null);
        final String newGroupString = GuiActivator.getResources().getI18NString("service.gui.CREATE_GROUP");
        groupCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (groupCombo.getSelectedItem() != null && groupCombo.getSelectedItem().equals(newGroupString)) {
                    CreateGroupDialog dialog = new CreateGroupDialog(parentDialog, false);
                    dialog.setModal(true);
                    dialog.setVisible(true);
                    MetaContactGroup newGroup = dialog.getNewMetaGroup();
                    if (newGroup != null) {
                        groupCombo.insertItemAt(newGroup, groupCombo.getItemCount() - 2);
                        groupCombo.setSelectedItem(newGroup);
                    } else {
                        groupCombo.setSelectedIndex(0);
                    }
                }
            }
        });
        return groupCombo;
    }

    private static void updateGroupItems(JComboBox groupCombo, ProtocolProviderService provider) {
        OperationSetPersistentPresencePermissions opsetPermissions = null;
        boolean isRootReadOnly = false;
        Object selectedItem = groupCombo.getSelectedItem();
        if (provider != null) {
            groupCombo.removeAllItems();
            opsetPermissions = (OperationSetPersistentPresencePermissions)provider.getOperationSet(OperationSetPersistentPresencePermissions.class);
            OperationSetPersistentPresence opsetPresence = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
            if (opsetPermissions != null && opsetPresence != null) {
                isRootReadOnly = opsetPermissions.isReadOnly(opsetPresence.getServerStoredContactListRoot());
            }
        }
        if (!isRootReadOnly) {
            groupCombo.addItem(GuiActivator.getContactListService().getRoot());
        }
        Iterator groupList = GuiActivator.getContactListService().getRoot().getSubgroups();
        while (groupList.hasNext()) {
            MetaContactGroup group = (MetaContactGroup)groupList.next();
            if (!group.isPersistent()) continue;
            if (provider != null && opsetPermissions != null) {
                Iterator protoGroupsIter = group.getContactGroupsForProvider(provider);
                boolean foundWritableGroup = false;
                while (protoGroupsIter.hasNext()) {
                    ContactGroup gr = (ContactGroup)protoGroupsIter.next();
                    if (opsetPermissions.isReadOnly(gr)) continue;
                    foundWritableGroup = true;
                    break;
                }
                if (!foundWritableGroup) continue;
            }
            groupCombo.addItem(group);
        }
        String newGroupString = GuiActivator.getResources().getI18NString("service.gui.CREATE_GROUP");
        if (!ConfigurationUtils.isCreateGroupDisabled() && !isRootReadOnly) {
            groupCombo.addItem(newGroupString);
        }
        if (selectedItem != null) {
            groupCombo.setSelectedItem(selectedItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        if (button.equals(this.addButton)) {
            final ProtocolProviderService protocolProvider = (ProtocolProviderService)this.accountCombo.getSelectedItem();
            final String contactAddress = this.contactAddressField.getText().trim();
            String displayName = this.displayNameField.getText();
            ArrayList validationResult = new ArrayList(2);
            if (!protocolProvider.validateContactAddress(contactAddress, validationResult)) {
                new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_ERROR_TITLE"), (String)validationResult.get(0), 1).showDialog();
                if (validationResult.size() >= 2) {
                    this.contactAddressField.setText((String)validationResult.get(1));
                    if (StringUtils.isNullOrEmpty((String)displayName, (boolean)true)) {
                        this.displayNameField.setText(contactAddress);
                    }
                }
                return;
            }
            if (!protocolProvider.isRegistered()) {
                new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_ERROR_TITLE"), GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_NOT_CONNECTED"), 1).showDialog();
                return;
            }
            if (displayName != null && displayName.length() > 0) {
                this.addRenameListener(protocolProvider, this.metaContact, contactAddress, displayName);
            }
            if (this.metaContact != null) {
                new Thread(){

                    @Override
                    public void run() {
                        GuiActivator.getContactListService().addNewContactToMetaContact(protocolProvider, AddContactDialog.this.metaContact, contactAddress);
                    }
                }.start();
            } else {
                ContactListUtils.addContact(protocolProvider, (MetaContactGroup)this.groupCombo.getSelectedItem(), contactAddress);
            }
        }
        this.dispose();
    }

    public void dispose() {
        super.dispose();
        this.getContentPane().removeAll();
        this.accountLabel = null;
        this.accountCombo = null;
        this.groupLabel = null;
        this.contactAddressLabel = null;
        this.displayNameLabel = null;
        this.contactAddressField = null;
        this.displayNameField = null;
        this.addButton = null;
        this.cancelButton = null;
        this.imageLabel = null;
        this.groupCombo = null;
        this.initialized = false;
    }

    public void setVisible(boolean isVisible) {
        if (!this.initialized) {
            this.init();
        }
        super.setVisible(isVisible);
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        if (!this.initialized) {
            this.init();
        }
        this.contactAddressField.requestFocus();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    public void bringToFront() {
        this.toFront();
    }

    public WindowID getIdentifier() {
        return ExportedWindow.ADD_CONTACT_WINDOW;
    }

    public Object getSource() {
        return this;
    }

    public void maximize() {
    }

    public void minimize() {
    }

    public void setParams(Object[] windowParams) {
    }

    private void updateAddButtonState(boolean updateGroups) {
        String contactAddress = this.contactAddressField.getText();
        Object selectedItem = this.accountCombo.getSelectedItem();
        if (selectedItem instanceof ProtocolProviderService && contactAddress != null && contactAddress.length() > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        if (updateGroups && selectedItem instanceof ProtocolProviderService) {
            AddContactDialog.updateGroupItems(this.groupCombo, (ProtocolProviderService)this.accountCombo.getSelectedItem());
        }
    }

    public void loadSkin() {
        if (this.initialized) {
            this.imageLabel.setIcon(GuiActivator.getResources().getImage("service.gui.icons.ADD_CONTACT_DIALOG_ICON"));
            this.imageLabel.setVerticalAlignment(1);
        }
    }

    private void addRenameListener(final ProtocolProviderService protocolProvider, final MetaContact metaContact, final String contactAddress, final String displayName) {
        GuiActivator.getContactListService().addMetaContactListListener((MetaContactListListener)new MetaContactListAdapter(){

            public void metaContactAdded(MetaContactEvent evt) {
                if (evt.getSourceMetaContact().getContact(contactAddress, protocolProvider) != null) {
                    AddContactDialog.this.renameContact(evt.getSourceMetaContact(), displayName);
                }
            }

            public void protoContactAdded(ProtoContactEvent evt) {
                if (metaContact != null && evt.getNewParent().equals(metaContact)) {
                    AddContactDialog.this.renameContact(metaContact, displayName);
                }
            }
        });
    }

    private void renameContact(final MetaContact metaContact, final String displayName) {
        new Thread(){

            @Override
            public void run() {
                GuiActivator.getContactListService().renameMetaContact(metaContact, displayName);
            }
        }.start();
    }

    private static class GroupComboRenderer
    extends DefaultListCellRenderer {
        private GroupComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 5, 0, 0)));
                this.setText((String)value);
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
                MetaContactGroup group = (MetaContactGroup)value;
                if (group == null || group.equals(GuiActivator.getContactListService().getRoot())) {
                    this.setText(GuiActivator.getResources().getI18NString("service.gui.SELECT_NO_GROUP"));
                } else {
                    this.setText(group.getGroupName());
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class AccountComboRenderer
    extends DefaultListCellRenderer {
        private AccountComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ProtocolProviderService provider;
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            if (value instanceof String) {
                this.setIcon(null);
                this.setText((String)value);
            } else if (value instanceof ProtocolProviderService && (provider = (ProtocolProviderService)value) != null) {
                Image protocolImg = ImageUtils.getBytesInImage((byte[])provider.getProtocolIcon().getIcon("IconSize16x16"));
                if (protocolImg != null) {
                    this.setIcon(ImageLoader.getIndexedProtocolIcon(protocolImg, provider));
                }
                this.setText(provider.getAccountID().getDisplayName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

