/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.FilterQuery;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.gui.event.MetaContactQuery;
import net.java.sip.communicator.service.gui.event.MetaContactQueryListener;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;

public class PresenceFilter
implements ContactListFilter {
    private static final Logger logger = Logger.getLogger(PresenceFilter.class);
    private boolean isShowOffline = ConfigurationUtils.isShowOffline();
    private static final int INITIAL_CONTACT_COUNT = 30;

    public void applyFilter(FilterQuery filterQuery) {
        MetaContactQuery query = new MetaContactQuery();
        filterQuery.addContactQuery((Object)query);
        TreeContactList contactList = GuiActivator.getContactList();
        List<UIContactSource> uiContactSourceCollection = contactList.getContactSources(3);
        Iterator filterSources = uiContactSourceCollection.iterator();
        int maxIndex = 0;
        while (filterSources.hasNext()) {
            UIContactSource filterSource = (UIContactSource)filterSources.next();
            int currIx = filterSource.getContactSourceService().getIndex();
            if (maxIndex >= currIx) continue;
            maxIndex = currIx;
        }
        contactList.getMetaContactListSource().setIndex(maxIndex + 1);
        for (UIContactSource filterSource : uiContactSourceCollection) {
            filterSource.setContactSourceIndex(filterSource.getContactSourceService().getIndex());
            ContactSourceService sourceService = filterSource.getContactSourceService();
            ContactQuery contactQuery = sourceService.createContactQuery(null);
            if (contactQuery == null) continue;
            filterQuery.addContactQuery((Object)contactQuery);
            contactQuery.addContactQueryListener((ContactQueryListener)contactList);
            contactQuery.start();
        }
        filterQuery.close();
        query.addContactQueryListener((MetaContactQueryListener)GuiActivator.getContactList());
        int resultCount = 0;
        this.addMatching(GuiActivator.getContactListService().getRoot(), query, resultCount);
        query.fireQueryEvent(query.isCanceled() ? 1 : 0);
    }

    public boolean isMatching(UIContact uiContact) {
        Object descriptor = uiContact.getDescriptor();
        if (descriptor instanceof MetaContact) {
            return this.isMatching((MetaContact)descriptor);
        }
        if (descriptor instanceof SourceContact) {
            return this.isMatching((SourceContact)descriptor);
        }
        return false;
    }

    public boolean isMatching(UIGroup uiGroup) {
        Object descriptor = uiGroup.getDescriptor();
        if (descriptor instanceof MetaContactGroup) {
            return this.isMatching((MetaContactGroup)descriptor);
        }
        return false;
    }

    public void setShowOffline(boolean isShowOffline) {
        this.isShowOffline = isShowOffline;
        ConfigurationUtils.setShowOffline((boolean)isShowOffline);
    }

    public boolean isShowOffline() {
        return this.isShowOffline;
    }

    public boolean isMatching(MetaContact metaContact) {
        return this.isShowOffline || this.isContactOnline(metaContact);
    }

    public boolean isMatching(SourceContact contact) {
        return this.isShowOffline || contact.getPresenceStatus().isOnline() || contact.getContactSource().getType() == 3;
    }

    private boolean isMatching(MetaContactGroup metaGroup) {
        return this.isShowOffline || metaGroup.countOnlineChildContacts() > 0 || MetaContactListSource.isNewGroup(metaGroup);
    }

    private boolean isContactOnline(MetaContact contact) {
        Contact defaultContact = contact.getDefaultContact();
        if (defaultContact == null) {
            return false;
        }
        return defaultContact.getPresenceStatus().getStatus() >= 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMatching(MetaContactGroup metaGroup, MetaContactQuery query, int resultCount) {
        MetaContactGroup metaContactGroup;
        Iterator childContacts = metaGroup.getChildContacts();
        while (childContacts.hasNext() && !query.isCanceled()) {
            MetaContact metaContact = (MetaContact)childContacts.next();
            if (!this.isMatching(metaContact)) continue;
            if (++resultCount <= 30) {
                UIContactImpl newUIContact;
                UIGroupImpl uiGroup = null;
                if (!MetaContactListSource.isRootGroup(metaGroup)) {
                    MetaContactGroup metaContactGroup2 = metaGroup;
                    synchronized (metaContactGroup2) {
                        uiGroup = MetaContactListSource.getUIGroup(metaGroup);
                        if (uiGroup == null) {
                            uiGroup = MetaContactListSource.createUIGroup(metaGroup);
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Presence filter contact added: " + metaContact.getDisplayName()));
                }
                metaContactGroup = metaContact;
                synchronized (metaContactGroup) {
                    newUIContact = MetaContactListSource.getUIContact(metaContact);
                    if (newUIContact == null) {
                        newUIContact = MetaContactListSource.createUIContact(metaContact);
                    }
                }
                GuiActivator.getContactList().addContact(newUIContact, uiGroup, true, true);
                query.setInitialResultCount(resultCount);
                continue;
            }
            query.fireQueryEvent(metaContact);
        }
        if (query.isCanceled()) {
            return;
        }
        Iterator subgroups = metaGroup.getSubgroups();
        while (subgroups.hasNext() && !query.isCanceled()) {
            UIGroupImpl uiGroup;
            MetaContactGroup subgroup = (MetaContactGroup)subgroups.next();
            if (!this.isMatching(subgroup)) continue;
            metaContactGroup = subgroup;
            synchronized (metaContactGroup) {
                uiGroup = MetaContactListSource.getUIGroup(subgroup);
                if (uiGroup == null) {
                    uiGroup = MetaContactListSource.createUIGroup(subgroup);
                }
            }
            GuiActivator.getContactList().addGroup(uiGroup, true);
            this.addMatching(subgroup, query, resultCount);
        }
    }
}

