/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.util.Iterator;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;
import net.java.sip.communicator.util.ConfigurationUtils;

public class MetaUIGroup
extends UIGroupImpl {
    private final MetaContactGroup metaGroup;
    private GroupNode groupNode;

    public MetaUIGroup(MetaContactGroup metaGroup) {
        this.metaGroup = metaGroup;
    }

    public Object getDescriptor() {
        return this.metaGroup;
    }

    public int getSourceIndex() {
        MetaContactGroup parentGroup = this.metaGroup.getParentMetaContactGroup();
        return GuiActivator.getContactList().getMetaContactListSource().getIndex() * MAX_GROUPS + (parentGroup == null ? 0 : parentGroup.indexOf(this.metaGroup) + 1) * MAX_CONTACTS;
    }

    public UIGroup getParentGroup() {
        MetaContactGroup parentGroup = this.metaGroup.getParentMetaContactGroup();
        if (parentGroup != null && !parentGroup.equals(GuiActivator.getContactListService().getRoot())) {
            return new MetaUIGroup(parentGroup);
        }
        return null;
    }

    public boolean isGroupCollapsed() {
        return ConfigurationUtils.isContactListGroupCollapsed((String)this.metaGroup.getMetaUID());
    }

    public String getDisplayName() {
        return this.metaGroup.getGroupName();
    }

    public int countChildContacts() {
        return this.metaGroup.countChildContacts();
    }

    public int countOnlineChildContacts() {
        return this.metaGroup.countOnlineChildContacts();
    }

    public String getId() {
        return this.metaGroup.getMetaUID();
    }

    @Override
    public GroupNode getGroupNode() {
        return this.groupNode;
    }

    @Override
    public void setGroupNode(GroupNode groupNode) {
        this.groupNode = groupNode;
        if (groupNode == null) {
            MetaContactListSource.removeUIGroup(this.metaGroup);
        }
    }

    public JPopupMenu getRightButtonMenu() {
        boolean hasReadonlyGroup = false;
        Iterator groupsIterator = this.metaGroup.getContactGroups();
        while (groupsIterator.hasNext()) {
            ContactGroup group = (ContactGroup)groupsIterator.next();
            OperationSetPersistentPresencePermissions opsetPermissions = (OperationSetPersistentPresencePermissions)group.getProtocolProvider().getOperationSet(OperationSetPersistentPresencePermissions.class);
            if (opsetPermissions == null || !opsetPermissions.isReadOnly(group)) continue;
            hasReadonlyGroup = true;
            break;
        }
        if (hasReadonlyGroup) {
            return null;
        }
        return new GroupRightButtonMenu(GuiActivator.getUIService().getMainFrame(), this.metaGroup);
    }
}

