/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.globalchooser;

import java.awt.AWTKeyStroke;
import java.awt.event.KeyEvent;
import java.util.List;

public class GlobalShortcutEntry {
    private static final AWTKeyStroke DISABLED = null;
    private String action = null;
    private AWTKeyStroke shortcut = null;
    private AWTKeyStroke shortcut2 = null;
    private boolean editableShortcut1 = false;
    private boolean editableShortcut2 = false;

    public GlobalShortcutEntry(String action, List<AWTKeyStroke> shortcuts) {
        this.setAction(action);
        this.setShortcuts(shortcuts);
    }

    public AWTKeyStroke getShortcut() {
        return this.shortcut;
    }

    public AWTKeyStroke getShortcut2() {
        return this.shortcut2;
    }

    public static String getShortcutText(AWTKeyStroke shortcut) {
        if (shortcut == DISABLED) {
            return "Disabled";
        }
        StringBuffer buffer = new StringBuffer();
        if (shortcut.getKeyEventType() == 400) {
            buffer.append(shortcut.getKeyChar());
        } else {
            boolean altMask;
            int keycode = shortcut.getKeyCode();
            int modifiers = shortcut.getModifiers();
            if (modifiers == 16367) {
                return "Special";
            }
            boolean shiftMask = (modifiers & 1) != 0;
            boolean ctrlMask = (modifiers & 2) != 0;
            boolean metaMask = (modifiers & 4) != 0;
            boolean bl = altMask = (modifiers & 8) != 0;
            if (shiftMask && keycode != 16) {
                buffer.append("Shift + ");
            }
            if (ctrlMask && keycode != 17) {
                buffer.append("Ctrl + ");
            }
            if (metaMask && keycode != 157) {
                buffer.append("Meta + ");
            }
            if (altMask && keycode != 18) {
                buffer.append("Alt + ");
            }
            buffer.append(KeyEvent.getKeyText(keycode));
        }
        return buffer.toString();
    }

    public void setShortcuts(List<AWTKeyStroke> shortcuts) {
        if (shortcuts.size() > 0) {
            this.shortcut = shortcuts.get(0);
        }
        if (shortcuts.size() > 1) {
            this.shortcut2 = shortcuts.get(1);
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isDisabled() {
        return this.shortcut == DISABLED && this.shortcut2 == DISABLED;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GlobalBindingEntry (");
        if (this.isDisabled()) {
            builder.append("Disabled");
        } else {
            builder.append(this.getShortcut());
        }
        builder.append(" \u2192 ");
        builder.append(this.getAction());
        builder.append(")");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GlobalShortcutEntry)) {
            return false;
        }
        GlobalShortcutEntry entry = (GlobalShortcutEntry)obj;
        boolean equals = true;
        String action = this.getAction();
        equals = action == null ? (equals &= entry.getAction() == null) : (equals &= action.equals(entry.getAction()));
        AWTKeyStroke shortcut = this.getShortcut();
        equals = shortcut == null ? (equals &= entry.getShortcut() == null) : (equals &= shortcut.equals(entry.getShortcut()));
        shortcut = this.getShortcut2();
        equals = shortcut == null ? (equals &= entry.getShortcut() == null) : (equals &= shortcut.equals(entry.getShortcut2()));
        return equals;
    }

    public void setEditShortcut1(boolean value) {
        this.editableShortcut1 = value;
    }

    public void setEditShortcut2(boolean value) {
        this.editableShortcut2 = value;
    }

    public boolean getEditShortcut1() {
        return this.editableShortcut1;
    }

    public boolean getEditShortcut2() {
        return this.editableShortcut2;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hash = 37 * hash + (this.getShortcut() == null ? 0 : this.getShortcut().hashCode());
        return hash;
    }
}

