/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RetransmissionRequester;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;
import org.jitsi.util.RTPUtils;

public class RetransmissionRequesterImpl
extends SinglePacketTransformerAdapter
implements TransformEngine,
RetransmissionRequester {
    private static final int MAX_MISSING = 100;
    private static final int MAX_REQUESTS = 10;
    private static final int RE_REQUEST_AFTER = 150;
    private static final Logger logger = Logger.getLogger(RetransmissionRequesterImpl.class);
    private final Map<Long, Requester> requesters = new HashMap<Long, Requester>();
    private boolean enabled = true;
    private final Thread thread;
    private boolean closed = false;
    private final MediaStream stream;
    private long senderSsrc = -1L;

    public RetransmissionRequesterImpl(MediaStream stream) {
        super(RTPPacketPredicate.INSTANCE);
        this.stream = stream;
        this.thread = new Thread(){

            @Override
            public void run() {
                RetransmissionRequesterImpl.this.runInRequesterThread();
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName(RetransmissionRequesterImpl.class.getName());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if (this.enabled && !this.closed) {
            int seq;
            Long ssrc;
            MediaFormat format = this.stream.getFormat(pkt.getPayloadType());
            if (format == null) {
                ssrc = null;
                seq = -1;
                logger.warn("format_not_found,stream_hash=" + this.stream.hashCode());
            } else if ("rtx".equalsIgnoreCase(format.getEncoding())) {
                MediaStreamTrackReceiver receiver = this.stream.getMediaStreamTrackReceiver();
                RTPEncodingDesc encoding = receiver.findRTPEncodingDesc(pkt);
                if (encoding != null) {
                    ssrc = encoding.getPrimarySSRC();
                    seq = pkt.getOriginalSequenceNumber();
                } else {
                    ssrc = null;
                    seq = -1;
                    logger.warn("encoding_not_found,stream_hash=" + this.stream.hashCode());
                }
            } else {
                ssrc = pkt.getSSRCAsLong();
                seq = pkt.getSequenceNumber();
            }
            if (ssrc != null) {
                Requester requester;
                Map<Long, Requester> map = this.requesters;
                synchronized (map) {
                    requester = this.requesters.get(ssrc);
                    if (requester == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Creating new Requester for SSRC " + ssrc);
                        }
                        requester = new Requester(ssrc);
                        this.requesters.put(ssrc, requester);
                    }
                }
                requester.received(seq);
            }
        }
        return pkt;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void enable(boolean enable) {
        this.enabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInRequesterThread() {
        if (Thread.currentThread() != this.thread) {
            return;
        }
        HashMap<Long, Set> packetsToRequest = new HashMap<Long, Set>();
        while (!this.closed) {
            Iterator iterator = this.thread;
            synchronized (iterator) {
                long nextRequestAt = -1L;
                Map<Long, Requester> map = this.requesters;
                synchronized (map) {
                    for (Requester requester : this.requesters.values()) {
                        if (requester.nextRequestAt == -1L || nextRequestAt != -1L && nextRequestAt <= requester.nextRequestAt) continue;
                        nextRequestAt = requester.nextRequestAt;
                    }
                }
                long now = System.currentTimeMillis();
                if (nextRequestAt == -1L || nextRequestAt - now > 0L) {
                    try {
                        if (nextRequestAt == -1L) {
                            this.thread.wait(1000L);
                            continue;
                        }
                        this.thread.wait(nextRequestAt - now);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            if (!this.enabled || this.senderSsrc == -1L) continue;
            iterator = this.requesters;
            synchronized (iterator) {
                for (Map.Entry<Long, Requester> entry : this.requesters.entrySet()) {
                    Requester requester = entry.getValue();
                    Set missingPackets = requester.getMissing();
                    if (missingPackets == null || missingPackets.isEmpty()) continue;
                    packetsToRequest.put(requester.ssrc, missingPackets);
                }
            }
            for (Map.Entry entry : packetsToRequest.entrySet()) {
                RawPacket pkt;
                long sourceSsrc = (Long)entry.getKey();
                NACKPacket nack = new NACKPacket(this.senderSsrc, sourceSsrc, (Collection)entry.getValue());
                try {
                    pkt = nack.toRawPacket();
                }
                catch (IOException ioe) {
                    pkt = null;
                    logger.warn("Failed to create a NACK packet: " + ioe);
                }
                if (pkt == null) continue;
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Sending a NACK: " + (Object)((Object)nack));
                    }
                    this.stream.injectPacket(pkt, false, null);
                }
                catch (TransmissionFailedException e) {
                    logger.warn("Failed to inject packet in MediaStream: " + e);
                }
            }
            packetsToRequest.clear();
        }
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public void setSenderSsrc(long ssrc) {
        this.senderSsrc = ssrc;
    }

    private static class Request {
        final int seq;
        long firstRequestSentAt = -1L;
        int timesRequested = 0;

        Request(int seq) {
            this.seq = seq;
        }
    }

    private class Requester {
        private final long ssrc;
        private int lastReceivedSeq = -1;
        private long nextRequestAt = -1L;
        private final Map<Integer, Request> requests = new HashMap<Integer, Request>();

        private Requester(long ssrc) {
            this.ssrc = ssrc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void received(int seq) {
            if (this.lastReceivedSeq == -1) {
                this.lastReceivedSeq = seq;
                return;
            }
            int diff = RTPUtils.sequenceNumberDiff(seq, this.lastReceivedSeq);
            if (diff <= 0) {
                long rtt;
                Request r = this.requests.remove(seq);
                if (r != null && logger.isDebugEnabled() && (rtt = RetransmissionRequesterImpl.this.stream.getMediaStreamStats().getSendStats().getRtt()) > 0L) {
                    long firstRequestSentAt = r.firstRequestSentAt;
                    long delta = firstRequestSentAt > 0L ? System.currentTimeMillis() - r.firstRequestSentAt : 0L;
                    logger.debug(Logger.Category.STATISTICS, "retr_received,stream=" + RetransmissionRequesterImpl.this.stream.hashCode() + " delay=" + delta + ",rtt=" + rtt);
                }
            } else if (diff == 1) {
                this.lastReceivedSeq = seq;
            } else if (diff <= 100) {
                int missing = (this.lastReceivedSeq + 1) % 65536;
                while (missing != seq) {
                    Request request = new Request(missing);
                    this.requests.put(missing, request);
                    missing = (missing + 1) % 65536;
                }
                this.lastReceivedSeq = seq;
                this.nextRequestAt = 0L;
                Thread thread = RetransmissionRequesterImpl.this.thread;
                synchronized (thread) {
                    RetransmissionRequesterImpl.this.thread.notifyAll();
                }
            } else {
                this.lastReceivedSeq = seq;
                if (logger.isDebugEnabled()) {
                    logger.debug("Resetting retransmission requester state. SSRC: " + this.ssrc + ", last received: " + this.lastReceivedSeq + ", current: " + seq + ". Removing " + this.requests.size() + " unsatisfied requests.");
                }
                this.requests.clear();
                this.nextRequestAt = -1L;
            }
        }

        private synchronized Set<Integer> getMissing() {
            long now = System.currentTimeMillis();
            HashSet<Integer> missingPackets = null;
            if (this.nextRequestAt == -1L || this.nextRequestAt > now) {
                return null;
            }
            Iterator<Map.Entry<Integer, Request>> iter = this.requests.entrySet().iterator();
            while (iter.hasNext()) {
                Request request = iter.next().getValue();
                if (missingPackets == null) {
                    missingPackets = new HashSet<Integer>();
                }
                missingPackets.add(request.seq);
                ++request.timesRequested;
                if (request.timesRequested == 1) {
                    request.firstRequestSentAt = now;
                    continue;
                }
                if (request.timesRequested != 10) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending the last NACK for SSRC=" + this.ssrc + " seq=" + request.seq + ". Time since the first request: " + (now - request.firstRequestSentAt));
                }
                iter.remove();
            }
            this.nextRequestAt = this.requests.size() > 0 ? now + 150L : -1L;
            return missingPackets;
        }
    }
}

