/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLWrapperLoader;

public class OpenSSLHMAC
implements Mac {
    private static final String algorithmName = "SHA-1/HMAC";
    private long ctx;
    private byte[] key;
    private final int macSize;
    private final long md;
    public static final int SHA1 = 1;

    private static native int EVP_MD_size(long var0);

    private static native long EVP_sha1();

    private static native long HMAC_CTX_create();

    private static native void HMAC_CTX_destroy(long var0);

    private static native int HMAC_Final(long var0, byte[] var2, int var3, int var4);

    private static native boolean HMAC_Init_ex(long var0, byte[] var2, int var3, long var4, long var6);

    private static native boolean HMAC_Update(long var0, byte[] var2, int var3, int var4);

    public OpenSSLHMAC(int digestAlgorithm) {
        if (!OpenSSLWrapperLoader.isLoaded()) {
            throw new RuntimeException("OpenSSL wrapper not loaded");
        }
        if (digestAlgorithm != 1) {
            throw new IllegalArgumentException("digestAlgorithm " + digestAlgorithm);
        }
        this.md = OpenSSLHMAC.EVP_sha1();
        if (this.md == 0L) {
            throw new IllegalStateException("EVP_sha1 == 0");
        }
        this.macSize = OpenSSLHMAC.EVP_MD_size(this.md);
        if (this.macSize == 0) {
            throw new IllegalStateException("EVP_MD_size == 0");
        }
        this.ctx = OpenSSLHMAC.HMAC_CTX_create();
        if (this.ctx == 0L) {
            throw new RuntimeException("HMAC_CTX_create == 0");
        }
    }

    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (outOff < 0 || out.length <= outOff) {
            throw new ArrayIndexOutOfBoundsException(outOff);
        }
        int outLen = out.length - outOff;
        int macSize = this.getMacSize();
        if (outLen < macSize) {
            throw new DataLengthException("Space in out must be at least " + macSize + "bytes but is " + outLen + " bytes!");
        }
        long ctx = this.ctx;
        if (ctx == 0L) {
            throw new IllegalStateException("ctx");
        }
        if ((outLen = OpenSSLHMAC.HMAC_Final(ctx, out, outOff, outLen)) < 0) {
            throw new RuntimeException("HMAC_Final");
        }
        this.reset();
        return outLen;
    }

    protected void finalize() throws Throwable {
        try {
            long ctx = this.ctx;
            if (ctx != 0L) {
                this.ctx = 0L;
                OpenSSLHMAC.HMAC_CTX_destroy(ctx);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void init(CipherParameters params) throws IllegalArgumentException {
        byte[] byArray = this.key = params instanceof KeyParameter ? ((KeyParameter)params).getKey() : null;
        if (this.key == null) {
            throw new IllegalStateException("key == null");
        }
        if (this.ctx == 0L) {
            throw new IllegalStateException("ctx == 0");
        }
        if (!OpenSSLHMAC.HMAC_Init_ex(this.ctx, this.key, this.key.length, this.md, 0L)) {
            throw new RuntimeException("HMAC_Init_ex() init failed");
        }
    }

    public void reset() {
        if (this.key == null) {
            throw new IllegalStateException("key == null");
        }
        if (this.ctx == 0L) {
            throw new IllegalStateException("ctx == 0");
        }
        if (!OpenSSLHMAC.HMAC_Init_ex(this.ctx, null, 0, 0L, 0L)) {
            throw new RuntimeException("HMAC_Init_ex() reset failed");
        }
    }

    public void update(byte in) throws IllegalStateException {
    }

    public void update(byte[] in, int off, int len) throws DataLengthException, IllegalStateException {
        if (len != 0) {
            if (in == null) {
                throw new NullPointerException("in");
            }
            if (off < 0 || in.length <= off) {
                throw new ArrayIndexOutOfBoundsException(off);
            }
            if (len < 0 || in.length < off + len) {
                throw new IllegalArgumentException("len " + len);
            }
            long ctx = this.ctx;
            if (ctx == 0L) {
                throw new IllegalStateException("ctx");
            }
            if (!OpenSSLHMAC.HMAC_Update(ctx, in, off, len)) {
                throw new RuntimeException("HMAC_Update");
            }
        }
    }
}

