/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.security.cert.X509Certificate;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.trust.CertificatePairHolder;

public final class BuddyCertificateInfo
implements CertificatePairHolder {
    private final Screenname buddy;
    private final ByteBlock hash;
    private final X509Certificate encryptionCert;
    private final X509Certificate signingCert;
    private final boolean upToDate;

    public BuddyCertificateInfo(Screenname buddy, ByteBlock hash) {
        this(buddy, hash, null, null, false);
    }

    public BuddyCertificateInfo(Screenname buddy, ByteBlock hash, X509Certificate encCert, X509Certificate signingCert) {
        this(buddy, hash, encCert, signingCert, true);
    }

    public BuddyCertificateInfo(Screenname buddy, ByteBlock hash, X509Certificate encCert, X509Certificate signingCert, boolean upToDate) {
        this.upToDate = upToDate;
        DefensiveTools.checkNull(buddy, "buddy");
        DefensiveTools.checkNull(hash, "hash");
        this.buddy = buddy;
        this.hash = hash;
        this.encryptionCert = encCert;
        this.signingCert = signingCert;
    }

    public final Screenname getBuddy() {
        return this.buddy;
    }

    public ByteBlock getCertificateInfoHash() {
        return this.hash;
    }

    public boolean hasAnyCertificates() {
        return this.encryptionCert != null || this.signingCert != null;
    }

    public boolean hasBothCertificates() {
        return this.encryptionCert != null && this.signingCert != null;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public X509Certificate getEncryptionCertificate() {
        return this.encryptionCert;
    }

    public X509Certificate getSigningCertificate() {
        return this.signingCert;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuddyCertificateInfo)) {
            return false;
        }
        BuddyCertificateInfo buddyCertificateInfo = (BuddyCertificateInfo)o;
        if (this.upToDate != buddyCertificateInfo.upToDate) {
            return false;
        }
        if (!this.buddy.equals(buddyCertificateInfo.buddy)) {
            return false;
        }
        return this.hash.equals(buddyCertificateInfo.hash);
    }

    public int hashCode() {
        int result = this.buddy.hashCode();
        result = 29 * result + this.hash.hashCode();
        result = 29 * result + (this.upToDate ? 1 : 0);
        return result;
    }
}

