/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.IAppWidgetFactory;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListClickListener;
import com.explodingpixels.macwidgets.SourceListColorScheme;
import com.explodingpixels.macwidgets.SourceListContextMenuProvider;
import com.explodingpixels.macwidgets.SourceListControlBar;
import com.explodingpixels.macwidgets.SourceListItem;
import com.explodingpixels.macwidgets.SourceListModel;
import com.explodingpixels.macwidgets.SourceListModelListener;
import com.explodingpixels.macwidgets.SourceListSelectionListener;
import com.explodingpixels.macwidgets.plaf.SourceListTreeUI;
import com.explodingpixels.widgets.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SourceList {
    private final SourceListModel fModel;
    private final SourceListModelListener fModelListener = this.createSourceListModelListener();
    private final List<SourceListSelectionListener> fSourceListSelectionListeners = new ArrayList<SourceListSelectionListener>();
    private DefaultMutableTreeNode fRoot = new DefaultMutableTreeNode("root");
    private DefaultTreeModel fTreeModel = new DefaultTreeModel(this.fRoot);
    private JTree fTree = new CustomJTree(this.fTreeModel);
    private JScrollPane fScrollPane = MacWidgetFactory.createSourceListScrollPane(this.fTree);
    private final JPanel fComponent = new JPanel(new BorderLayout());
    private TreeSelectionListener fTreeSelectionListener = this.createTreeSelectionListener();
    private MouseListener fMouseListener = this.createMouseListener();
    private SourceListControlBar fSourceListControlBar;
    private SourceListContextMenuProvider fContextMenuProvider = new EmptySourceListContextMenuProvider();
    private List<SourceListClickListener> fSourceListClickListeners = new ArrayList<SourceListClickListener>();

    public SourceList() {
        this(new SourceListModel());
    }

    public SourceList(SourceListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Groups cannot be null.");
        }
        this.fModel = model;
        this.fModel.addSourceListModelListener(this.fModelListener);
        this.initUi();
        for (int i = 0; i < model.getCategories().size(); ++i) {
            this.doAddCategory(model.getCategories().get(i), i);
        }
    }

    private void initUi() {
        this.fComponent.add((Component)this.fScrollPane, "Center");
        this.fTree.addTreeSelectionListener(this.fTreeSelectionListener);
        this.fTree.addMouseListener(this.fMouseListener);
    }

    public void installSourceListControlBar(SourceListControlBar sourceListControlBar) {
        if (this.fSourceListControlBar != null) {
            throw new IllegalStateException("A SourceListControlBar has already been installed on this SourceList.");
        }
        if (sourceListControlBar == null) {
            throw new IllegalArgumentException("SourceListControlBar cannot be null.");
        }
        this.fSourceListControlBar = sourceListControlBar;
        this.fComponent.add((Component)this.fSourceListControlBar.getComponent(), "South");
    }

    public boolean isSourceListControlBarInstalled() {
        return this.fSourceListControlBar != null;
    }

    public void setSourceListContextMenuProvider(SourceListContextMenuProvider contextMenuProvider) {
        if (contextMenuProvider == null) {
            throw new IllegalArgumentException("SourceListContextMenuProvider cannot be null.");
        }
        this.fContextMenuProvider = contextMenuProvider;
    }

    public void dispose() {
        this.fModel.removeSourceListModelListener(this.fModelListener);
    }

    public SourceListItem getSelectedItem() {
        SourceListItem selectedItem = null;
        if (this.fTree.getSelectionPath() != null && this.fTree.getSelectionPath().getLastPathComponent() != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.fTree.getSelectionPath().getLastPathComponent();
            assert (selectedNode.getUserObject() instanceof SourceListItem) : "Only SourceListItems can be selected.";
            selectedItem = (SourceListItem)selectedNode.getUserObject();
        }
        return selectedItem;
    }

    public void setSelectedItem(SourceListItem item) {
        this.getModel().validateItemIsInModel(item);
        DefaultMutableTreeNode treeNode = SourceList.getNodeForObject(this.fRoot, item);
        this.fTree.setSelectionPath(new TreePath(treeNode.getPath()));
    }

    public void setFocusable(boolean focusable) {
        this.fTree.setFocusable(focusable);
    }

    public void useIAppStyleScrollBars() {
        IAppWidgetFactory.makeIAppScrollPane(this.fScrollPane);
    }

    public SourceListColorScheme getColorScheme() {
        return ((SourceListTreeUI)this.fTree.getUI()).getColorScheme();
    }

    public void setColorScheme(SourceListColorScheme colorScheme) {
        ((SourceListTreeUI)this.fTree.getUI()).setColorScheme(colorScheme);
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        this.fTree.setDragEnabled(transferHandler != null);
        this.fTree.setTransferHandler(transferHandler);
    }

    public void setExpanded(SourceListCategory category, boolean expanded) {
        DefaultMutableTreeNode categoryNode = this.getNodeForObject(category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        TreeUtils.setExpandedOnEdt(this.fTree, new TreePath(categoryNode.getPath()), expanded);
    }

    public void setExpanded(SourceListItem item, boolean expanded) {
        DefaultMutableTreeNode itemNode = this.getNodeForObject(item);
        SourceList.checkItemNodeNotNull(itemNode);
        TreeUtils.setExpandedOnEdt(this.fTree, new TreePath(itemNode.getPath()), expanded);
    }

    private DefaultMutableTreeNode getNodeForObject(Object userObject) {
        return SourceList.getNodeForObject(this.fRoot, userObject);
    }

    private static DefaultMutableTreeNode getNodeForObject(DefaultMutableTreeNode parentNode, Object userObject) {
        if (parentNode.getUserObject().equals(userObject)) {
            return parentNode;
        }
        if (parentNode.children().hasMoreElements()) {
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)parentNode.getChildAt(i);
                DefaultMutableTreeNode retVal = SourceList.getNodeForObject(childNode, userObject);
                if (retVal == null) continue;
                return retVal;
            }
        } else {
            return null;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public SourceListModel getModel() {
        return this.fModel;
    }

    private void doAddCategory(SourceListCategory category, int index) {
        DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(category);
        this.fTreeModel.insertNodeInto(categoryNode, this.fRoot, index);
        for (int i = 0; i < category.getItems().size(); ++i) {
            this.doAddItemToCategory(category.getItems().get(i), category, i);
        }
        TreeUtils.expandPathOnEdt(this.fTree, new TreePath(categoryNode.getPath()));
    }

    private void doRemoveCategory(SourceListCategory category) {
        DefaultMutableTreeNode categoryNode = SourceList.getNodeForObject(this.fRoot, category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        this.fTreeModel.removeNodeFromParent(categoryNode);
    }

    private void doAddItemToCategory(SourceListItem itemToAdd, SourceListCategory category, int index) {
        DefaultMutableTreeNode categoryNode = SourceList.getNodeForObject(this.fRoot, category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        this.doAddItemToNode(itemToAdd, categoryNode, index);
    }

    private void doRemoveItemFromCategory(SourceListItem itemToRemove, SourceListCategory category) {
        DefaultMutableTreeNode categoryNode = SourceList.getNodeForObject(this.fRoot, category);
        SourceList.checkCategoryNodeNotNull(categoryNode);
        DefaultMutableTreeNode itemNode = SourceList.getNodeForObject(categoryNode, itemToRemove);
        SourceList.checkCategoryNodeNotNull(itemNode);
        this.fTreeModel.removeNodeFromParent(itemNode);
    }

    private void doAddItemToItem(SourceListItem itemToAdd, SourceListItem parentItem, int index) {
        DefaultMutableTreeNode parentItemNode = SourceList.getNodeForObject(this.fRoot, parentItem);
        SourceList.checkCategoryNodeNotNull(parentItemNode);
        this.doAddItemToNode(itemToAdd, parentItemNode, index);
    }

    private void doRemoveItemFromItem(SourceListItem itemToRemove, SourceListItem parentItem) {
        DefaultMutableTreeNode parentNode = SourceList.getNodeForObject(this.fRoot, parentItem);
        SourceList.checkCategoryNodeNotNull(parentNode);
        DefaultMutableTreeNode itemNode = SourceList.getNodeForObject(parentNode, itemToRemove);
        SourceList.checkCategoryNodeNotNull(itemNode);
        this.fTreeModel.removeNodeFromParent(itemNode);
    }

    private void doAddItemToNode(SourceListItem itemToAdd, DefaultMutableTreeNode parentNode, int index) {
        DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(itemToAdd);
        this.fTreeModel.insertNodeInto(itemNode, parentNode, index);
        for (int i = 0; i < itemToAdd.getChildItems().size(); ++i) {
            this.doAddItemToItem(itemToAdd.getChildItems().get(i), itemToAdd, i);
        }
        if (parentNode.getChildCount() == 1) {
            TreeUtils.expandPathOnEdt(this.fTree, new TreePath(parentNode.getPath()));
        }
    }

    private void doItemChanged(SourceListItem item) {
        DefaultMutableTreeNode itemNode = SourceList.getNodeForObject(this.fRoot, item);
        SourceList.checkItemNodeNotNull(itemNode);
        this.fTreeModel.nodeChanged(itemNode);
    }

    private void doShowContextMenu(MouseEvent event) {
        Object itemOrCategory = this.getItemOrCategoryUnderPoint(event.getPoint());
        JPopupMenu popup = null;
        if (itemOrCategory == null) {
            popup = this.fContextMenuProvider.createContextMenu();
        } else if (itemOrCategory instanceof SourceListItem) {
            popup = this.fContextMenuProvider.createContextMenu((SourceListItem)itemOrCategory);
        } else if (itemOrCategory instanceof SourceListCategory) {
            popup = this.fContextMenuProvider.createContextMenu((SourceListCategory)itemOrCategory);
        }
        if (popup != null && popup.getComponentCount() > 0) {
            popup.show(this.fTree, event.getX(), event.getY());
        }
    }

    private void doSourceListClicked(MouseEvent event) {
        Object itemOrCategory = this.getItemOrCategoryUnderPoint(event.getPoint());
        SourceListClickListener.Button button = SourceListClickListener.Button.getButton(event.getButton());
        int clickCount = event.getClickCount();
        if (itemOrCategory != null) {
            if (itemOrCategory instanceof SourceListItem) {
                this.fireSourceListItemClicked((SourceListItem)itemOrCategory, button, clickCount);
            } else if (itemOrCategory instanceof SourceListCategory) {
                this.fireSourceListCategoryClicked((SourceListCategory)itemOrCategory, button, clickCount);
            }
        }
    }

    private Object getItemOrCategoryUnderPoint(Point point) {
        TreePath path = this.fTree.getPathForLocation(point.x, point.y);
        return path == null ? null : ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
    }

    private TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                SourceList.this.fireSourceListItemSelected(SourceList.this.getSelectedItem());
            }
        };
    }

    private SourceListModelListener createSourceListModelListener() {
        return new SourceListModelListener(){

            public void categoryAdded(SourceListCategory category, int index) {
                SourceList.this.doAddCategory(category, index);
            }

            public void categoryRemoved(SourceListCategory category) {
                SourceList.this.doRemoveCategory(category);
            }

            public void itemAddedToCategory(SourceListItem item, SourceListCategory category, int index) {
                SourceList.this.doAddItemToCategory(item, category, index);
            }

            public void itemRemovedFromCategory(SourceListItem item, SourceListCategory category) {
                SourceList.this.doRemoveItemFromCategory(item, category);
            }

            public void itemAddedToItem(SourceListItem item, SourceListItem parentItem, int index) {
                SourceList.this.doAddItemToItem(item, parentItem, index);
            }

            public void itemRemovedFromItem(SourceListItem item, SourceListItem parentItem) {
                SourceList.this.doRemoveItemFromItem(item, parentItem);
            }

            public void itemChanged(SourceListItem item) {
                SourceList.this.doItemChanged(item);
            }
        };
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SourceList.this.doShowContextMenu(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SourceList.this.doShowContextMenu(e);
                }
            }

            public void mouseClicked(MouseEvent e) {
                SourceList.this.doSourceListClicked(e);
            }
        };
    }

    private void fireSourceListItemClicked(SourceListItem item, SourceListClickListener.Button button, int clickCount) {
        for (SourceListClickListener listener : this.fSourceListClickListeners) {
            listener.sourceListItemClicked(item, button, clickCount);
        }
    }

    private void fireSourceListCategoryClicked(SourceListCategory category, SourceListClickListener.Button button, int clickCount) {
        for (SourceListClickListener listener : this.fSourceListClickListeners) {
            listener.sourceListCategoryClicked(category, button, clickCount);
        }
    }

    public void addSourceListClickListener(SourceListClickListener listener) {
        this.fSourceListClickListeners.add(listener);
    }

    public void removeSourceListClickListener(SourceListClickListener listener) {
        this.fSourceListClickListeners.remove(listener);
    }

    private void fireSourceListItemSelected(SourceListItem item) {
        for (SourceListSelectionListener listener : this.fSourceListSelectionListeners) {
            listener.sourceListItemSelected(item);
        }
    }

    public void addSourceListSelectionListener(SourceListSelectionListener listener) {
        this.fSourceListSelectionListeners.add(listener);
    }

    public void removeSourceListSelectionListener(SourceListSelectionListener listener) {
        this.fSourceListSelectionListeners.remove(listener);
    }

    private static void checkCategoryNodeNotNull(MutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("The given SourceListCategory does not exist in this SourceList.");
        }
    }

    private static void checkItemNodeNotNull(MutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException("The given SourceListItem does not exist in this SourceList.");
        }
    }

    private static class CustomJTree
    extends JTree {
        public CustomJTree(TreeModel newModel) {
            super(newModel);
        }

        public void updateUI() {
            this.setUI(new SourceListTreeUI());
            this.invalidate();
        }
    }

    private static class EmptySourceListContextMenuProvider
    implements SourceListContextMenuProvider {
        private EmptySourceListContextMenuProvider() {
        }

        public JPopupMenu createContextMenu() {
            return null;
        }

        public JPopupMenu createContextMenu(SourceListItem item) {
            return null;
        }

        public JPopupMenu createContextMenu(SourceListCategory category) {
            return null;
        }
    }
}

