/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui;

import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.service.contacteventhandler.ContactEventHandler;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.protocol.Contact;

public class DefaultContactEventHandler
implements ContactEventHandler {
    private final MainFrame mainFrame;

    public DefaultContactEventHandler(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void contactClicked(Contact contact, int clickCount) {
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
        SwingUtilities.invokeLater(new RunMessageWindow(metaContact, contact));
    }

    public static class RunMessageWindow
    implements Runnable {
        private final MetaContact metaContact;
        private final Contact protocolContact;

        public RunMessageWindow(MetaContact metaContact, Contact protocolContact) {
            this.metaContact = metaContact;
            this.protocolContact = protocolContact;
        }

        @Override
        public void run() {
            ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
            ChatPanel chatPanel = chatWindowManager.getContactChat(this.metaContact, this.protocolContact);
            chatWindowManager.openChat(chatPanel, true);
        }
    }
}

