/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist.joinforms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.util.skin.Skinnable;

public class JoinChatRoomWindow
extends SIPCommFrame
implements Skinnable {
    private static final long serialVersionUID = -5377426011460074319L;
    private Vector<ChatRoomProviderWrapper> chatRoomProviders = new Vector();
    private JComboBox jcb_chatRoomProviders;
    private JComboBox jcb_roomName = new JComboBox();
    private JTextField editor;
    private Vector<ImageIcon> providerIcons = new Vector();
    private Vector<String> providerNames = new Vector();
    private List<String> serverRooms = null;
    private String searchStateValue = GuiActivator.getResources().getI18NString("service.gui.LOADING_ROOMS");
    private JLabel jl_searchState = new JLabel(this.searchStateValue, 2);

    public JoinChatRoomWindow() {
        this(null);
    }

    public JoinChatRoomWindow(ChatRoomProviderWrapper chatRoomProvider) {
        Iterator providers = GuiActivator.getMUCService().getChatRoomProviders();
        while (providers.hasNext()) {
            this.chatRoomProviders.add((ChatRoomProviderWrapper)providers.next());
            ChatRoomProviderWrapper provider = this.chatRoomProviders.get(this.chatRoomProviders.size() - 1);
            if (provider.getProtocolProvider().getRegistrationState() != RegistrationState.REGISTERED) continue;
            this.providerNames.add(provider.getProtocolProvider().getAccountID().getAccountAddress());
            this.providerIcons.add(new ImageIcon(provider.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16")));
        }
        this.buildGUI();
        this.setVisible(true);
        this.loadProviderRooms();
        if (chatRoomProvider != null) {
            this.jcb_chatRoomProviders.setSelectedItem(chatRoomProvider.getProtocolProvider().getAccountID().getAccountAddress());
        }
    }

    private void buildGUI() {
        String title = GuiActivator.getResources().getI18NString("service.gui.JOIN_CHAT_ROOM_TITLE");
        this.setLayout(new BorderLayout());
        this.setTitle(title);
        this.jcb_chatRoomProviders = new JComboBox<String>(this.providerNames);
        this.jcb_chatRoomProviders.setRenderer(new ComboBoxRenderer());
        this.jcb_roomName.setEditable(true);
        this.jcb_roomName.setPreferredSize(this.jcb_chatRoomProviders.getPreferredSize());
        TransparentPanel jp_buttons = new TransparentPanel((LayoutManager)new FlowLayout(2));
        final JButton jb_join = new JButton(GuiActivator.getResources().getI18NString("service.gui.JOIN"));
        JButton jb_back = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
        jp_buttons.add(jb_back);
        jp_buttons.add(jb_join);
        jb_back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JoinChatRoomWindow.this.dispose();
            }
        });
        jb_join.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiActivator.getMUCService().joinChatRoom(JoinChatRoomWindow.this.editor.getText(), JoinChatRoomWindow.this.getSelectedProvider());
                JoinChatRoomWindow.this.dispose();
            }
        });
        this.editor = (JTextField)this.jcb_roomName.getEditor().getEditorComponent();
        this.editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JoinChatRoomWindow.this.handleChange();
            }
        });
        this.jcb_chatRoomProviders.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    new Thread(){

                        @Override
                        public void run() {
                            jb_join.setEnabled(false);
                            JoinChatRoomWindow.this.jcb_roomName.setEnabled(false);
                            JoinChatRoomWindow.this.jl_searchState.setVisible(true);
                            JoinChatRoomWindow.this.loadProviderRooms();
                            JoinChatRoomWindow.this.jl_searchState.setVisible(false);
                            JoinChatRoomWindow.this.jcb_roomName.setEnabled(true);
                            jb_join.setEnabled(true);
                        }
                    }.start();
                }
            }
        });
        TransparentPanel jp_formFields = new TransparentPanel();
        TransparentPanel jp_accountField = new TransparentPanel((LayoutManager)new FlowLayout(2));
        TransparentPanel jp_roomField = new TransparentPanel((LayoutManager)new FlowLayout(2));
        TransparentPanel jp_indication = new TransparentPanel((LayoutManager)new FlowLayout(2));
        jp_formFields.setLayout(new BoxLayout((Container)jp_formFields, 1));
        jp_accountField.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        jp_roomField.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
        jp_accountField.add(new JLabel(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT") + ": "));
        jp_accountField.add(this.jcb_chatRoomProviders);
        jp_roomField.add(new JLabel(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_NAME") + ": "));
        jp_roomField.add(this.jcb_roomName);
        this.jl_searchState.setBorder(BorderFactory.createEmptyBorder(3, 7, 0, 0));
        this.jl_searchState.setFont(this.jl_searchState.getFont().deriveFont(2, 11.0f));
        this.jl_searchState.setForeground(Color.DARK_GRAY);
        this.jl_searchState.setVisible(false);
        JLabel jl_indication = new JLabel(GuiActivator.getResources().getI18NString("service.gui.PRESS_ENTER_FOR_SUGGESTIONS"));
        jl_indication.setFont(this.jl_searchState.getFont());
        jl_indication.setForeground(this.jl_searchState.getForeground());
        jl_indication.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 8));
        jp_indication.add(jl_indication);
        jp_formFields.add(this.jl_searchState);
        jp_formFields.add((Component)jp_accountField);
        jp_formFields.add((Component)jp_roomField);
        jp_formFields.add((Component)jp_indication);
        this.add((Component)jp_formFields, "Center");
        this.add((Component)jp_buttons, "South");
        this.setSize(new Dimension(415, 190));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public Vector<String> getChatRoomList(String match) {
        Vector<String> rooms = new Vector<String>();
        if (this.serverRooms != null) {
            for (String room : this.serverRooms) {
                if (!room.startsWith(match)) continue;
                rooms.add(room);
            }
        }
        Collections.sort(rooms);
        return rooms;
    }

    protected void close(boolean escaped) {
        this.dispose();
    }

    public ChatRoomProviderWrapper getSelectedProvider() {
        for (ChatRoomProviderWrapper crp : this.chatRoomProviders) {
            if (!crp.getProtocolProvider().getAccountID().getAccountAddress().equals(this.jcb_chatRoomProviders.getSelectedItem())) continue;
            return crp;
        }
        return null;
    }

    public void loadProviderRooms() {
        this.serverRooms = GuiActivator.getMUCService().getExistingChatRooms(this.getSelectedProvider());
    }

    public void handleChange() {
        final String match = this.editor.getText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < JoinChatRoomWindow.this.jcb_roomName.getItemCount(); ++i) {
                    JoinChatRoomWindow.this.jcb_roomName.removeItemAt(i);
                }
                for (String room : JoinChatRoomWindow.this.getChatRoomList(match)) {
                    JoinChatRoomWindow.this.jcb_roomName.addItem(room);
                }
                JoinChatRoomWindow.this.editor.setText(match);
                JoinChatRoomWindow.this.jcb_roomName.showPopup();
            }
        });
    }

    public void loadSkin() {
        this.providerIcons.clear();
        for (ChatRoomProviderWrapper provider : this.chatRoomProviders) {
            if (provider.getProtocolProvider().getRegistrationState() != RegistrationState.REGISTERED) continue;
            this.providerIcons.add(new ImageIcon(provider.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16")));
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label = (String)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            int idx = JoinChatRoomWindow.this.providerNames.indexOf(label);
            ImageIcon icon = (ImageIcon)JoinChatRoomWindow.this.providerIcons.get(idx);
            this.setText(label);
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

