/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.InviteUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTransferHandler;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class InviteContactTransferHandler
extends ExtendedTransferHandler {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(InviteContactTransferHandler.class);
    protected static final DataFlavor uiContactDataFlavor = new DataFlavor(UIContact.class, "UIContact");
    private final ContactList contactList;
    private ProtocolProviderService backupProvider;
    private final boolean selected;
    public static final int SOURCE_TRANSFER_HANDLER = 0;
    public static final int DEST_TRANSFER_HANDLER = 1;
    private final int type;

    public InviteContactTransferHandler(ContactList contactList, int type, boolean selected) {
        this.contactList = contactList;
        this.type = type;
        this.selected = selected;
    }

    protected Transferable createTransferable(JComponent component) {
        List c;
        if (this.type != 0) {
            return null;
        }
        if (component instanceof ContactList && (c = ((ContactList)component).getSelectedContacts()) != null) {
            return new UIContactTransferable(c);
        }
        return super.createTransferable(component);
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        if (this.type != 1) {
            return false;
        }
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            if (!flavor[i].equals(uiContactDataFlavor)) continue;
            return comp instanceof ContactList;
        }
        return false;
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (t.isDataFlavorSupported(uiContactDataFlavor)) {
            UIContactImpl uiContact;
            Object o;
            block10: {
                if (!this.selected) {
                    return false;
                }
                o = null;
                try {
                    o = t.getTransferData(uiContactDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                }
            }
            if (o instanceof Collection) {
                for (Object nextO : (Collection)o) {
                    if (!(nextO instanceof UIContact)) continue;
                    this.contactList.addContact((UIContact)new InviteUIContact((UIContact)nextO, this.backupProvider), null, false, false);
                }
                return true;
            }
            if (o instanceof UIContact) {
                this.contactList.addContact((UIContact)new InviteUIContact((UIContact)o, this.backupProvider), null, false, false);
                return true;
            }
            if (o instanceof ContactNode && (uiContact = ((ContactNode)o).getContactDescriptor()) != null) {
                this.contactList.addContact((UIContact)new InviteUIContact(uiContact, this.backupProvider), null, false, false);
                return true;
            }
        }
        return false;
    }

    public void setBackupProvider(ProtocolProviderService backupProvider) {
        this.backupProvider = backupProvider;
    }

    public class UIContactTransferable
    implements Transferable {
        private final List<UIContact> uiContacts;

        public UIContactTransferable(List<UIContact> uiContacts) {
            this.uiContacts = uiContacts;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{uiContactDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return uiContactDataFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.uiContacts;
        }

        public List<UIContact> getUIContacts() {
            return this.uiContacts;
        }
    }
}

