/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.branding;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import net.java.sip.communicator.plugin.branding.Constants;
import net.java.sip.communicator.util.Logger;

public class StyledHTMLEditorPane
extends JEditorPane {
    private final Logger logger = Logger.getLogger(StyledHTMLEditorPane.class);
    private final HTMLDocument document;

    public StyledHTMLEditorPane() {
        this.setContentType("text/html");
        this.document = (HTMLDocument)this.getDocument();
        this.setDocument(this.document);
        Constants.loadSimpleStyle(this.document.getStyleSheet());
    }

    public void appendToEnd(String text) {
        Element root = this.document.getDefaultRootElement();
        try {
            this.document.insertAfterEnd(root.getElement(root.getElementCount() - 1), text);
        }
        catch (BadLocationException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
    }

    public void insertAfterStart(String text) {
        Element root = this.document.getDefaultRootElement();
        try {
            this.document.insertBeforeStart(root.getElement(0), text);
        }
        catch (BadLocationException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
    }
}

