/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ComponentMover {
    public static void registerComponent(Component c) {
        MoverMouseListener l = new MoverMouseListener();
        c.addMouseListener(l);
        c.addMouseMotionListener(l);
    }

    private static class MoverMouseListener
    implements MouseListener,
    MouseMotionListener {
        private boolean inDrag = false;
        private int previousX = 0;
        private int previousY = 0;

        private MoverMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Point p = event.getPoint();
            if (this.inDrag) {
                Component c = (Component)event.getSource();
                int newX = c.getX() + p.x - this.previousX;
                int newY = c.getY() + p.y - this.previousY;
                c.setLocation(newX, newY);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Point p = event.getPoint();
            this.previousX = p.x;
            this.previousY = p.y;
            this.inDrag = true;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.inDrag = false;
            this.previousX = 0;
            this.previousY = 0;
        }
    }
}

