/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public final class DirInfo
implements LiveWritable {
    private static final int TYPE_CHARSET = 24;
    private static final int TYPE_SN = 9;
    private static final int TYPE_EMAIL = 5;
    private static final int TYPE_FIRSTNAME = 1;
    private static final int TYPE_MIDDLENAME = 3;
    private static final int TYPE_LASTNAME = 2;
    private static final int TYPE_MAIDENNAME = 4;
    private static final int TYPE_NICKNAME = 12;
    private static final int TYPE_ADDRESS = 33;
    private static final int TYPE_CITY = 8;
    private static final int TYPE_STATE = 7;
    private static final int TYPE_ZIP = 13;
    private static final int TYPE_COUNTRY = 6;
    private static final int TYPE_LANGUAGE = 15;
    private final String sn;
    private final String email;
    private final String first;
    private final String middle;
    private final String last;
    private final String maiden;
    private final String nickname;
    private final String address;
    private final String city;
    private final String state;
    private final String zip;
    private final String country;
    private final String language;
    private final int totalSize;
    private ByteBlock block = null;
    private int tlvCount = -1;

    public static DirInfo readDirInfo(ByteBlock block) {
        return DirInfo.readDirInfo(TlvTools.readChain(block));
    }

    public static DirInfo readDirInfo(ByteBlock block, int maxTlvs) {
        return DirInfo.readDirInfo(TlvTools.readChain(block, maxTlvs));
    }

    @Nullable
    public static DirInfo readDirInfo(TlvChain chain) {
        DefensiveTools.checkNull(chain, "chain");
        if (chain.getTlvCount() == 0) {
            return null;
        }
        String charset = chain.getString(24);
        String sn = chain.getString(9, charset);
        String email = chain.getString(5, charset);
        String first = chain.getString(1, charset);
        String middle = chain.getString(3, charset);
        String last = chain.getString(2, charset);
        String nickname = chain.getString(12, charset);
        String maiden = chain.getString(4, charset);
        String address = chain.getString(33, charset);
        String city = chain.getString(8, charset);
        String state = chain.getString(7, charset);
        String zip = chain.getString(13, charset);
        String country = chain.getString(6, charset);
        String language = chain.getString(15, charset);
        return new DirInfo(sn, email, first, middle, last, maiden, nickname, address, city, state, zip, country, language, chain.getTotalSize());
    }

    private DirInfo(String sn, String email, String first, String middle, String last, String maiden, String nickname, String address, String city, String state, String zip, String country, String language, int totalSize) {
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.sn = sn;
        this.email = email;
        this.first = first;
        this.middle = middle;
        this.last = last;
        this.maiden = maiden;
        this.nickname = nickname;
        this.address = address;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.country = country;
        this.language = language;
        this.totalSize = totalSize;
    }

    public DirInfo(String email, String first, String middle, String last, String maiden, String nickname, String address, String city, String state, String zip, String country, String language) {
        this(null, email, first, middle, last, maiden, nickname, address, city, state, zip, country, language, -1);
    }

    public DirInfo(String sn, String email, String first, String middle, String last, String maiden, String nickname, String address, String city, String state, String zip, String country, String language) {
        this(sn, email, first, middle, last, maiden, nickname, address, city, state, zip, country, language, -1);
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getFirstname() {
        return this.first;
    }

    public final String getMiddlename() {
        return this.middle;
    }

    public final String getLastname() {
        return this.last;
    }

    public final String getMaiden() {
        return this.maiden;
    }

    public final String getNickname() {
        return this.nickname;
    }

    public final String getStreetAddress() {
        return this.address;
    }

    public final String getCity() {
        return this.city;
    }

    public final String getState() {
        return this.state;
    }

    public final String getZip() {
        return this.zip;
    }

    public final String getCountryCode() {
        return this.country;
    }

    public final String getLanguageCode() {
        return this.language;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    private static boolean writeString(OutputStream out, int type, String str, MinimalEncoder encoder) throws IOException {
        if (str == null) {
            return false;
        }
        Tlv tlv = new Tlv(type, ByteBlock.wrap(encoder.encode(str).getData()));
        tlv.write(out);
        return true;
    }

    private void writeTo(OutputStream out) throws IOException {
        int count = 0;
        MinimalEncoder menc = new MinimalEncoder();
        menc.updateAll(Arrays.asList(this.sn, this.email, this.first, this.middle, this.last, this.maiden, this.nickname, this.address, this.city, this.state, this.zip, this.country, this.language));
        Tlv.getStringInstance(24, menc.getCharset()).write(out);
        ++count;
        if (DirInfo.writeString(out, 9, this.sn, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 5, this.email, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 1, this.first, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 3, this.middle, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 2, this.last, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 4, this.maiden, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 12, this.nickname, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 33, this.address, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 8, this.city, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 7, this.state, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 13, this.zip, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 6, this.country, menc)) {
            ++count;
        }
        if (DirInfo.writeString(out, 15, this.language, menc)) {
            ++count;
        }
        this.tlvCount = count;
    }

    private void ensureBlockExists() {
        if (this.block != null && this.tlvCount != -1) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeTo(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.block = ByteBlock.wrap(out.toByteArray());
    }

    public final int getTlvCount() {
        if (this.tlvCount == -1) {
            this.ensureBlockExists();
        }
        return this.tlvCount;
    }

    public void write(OutputStream out) throws IOException {
        if (this.block == null) {
            this.writeTo(out);
        } else {
            this.block.write(out);
        }
    }

    public String toString() {
        return "DirInfo for " + this.sn + " (email=" + this.email + "): " + "first='" + this.first + "'" + ", middle='" + this.middle + "'" + ", last='" + this.last + "'" + ", maiden='" + this.maiden + "'" + ", nickname='" + this.nickname + "'" + ", address='" + this.address + "'" + ", city='" + this.city + "'" + ", state='" + this.state + "'" + ", zip='" + this.zip + "'" + ", country='" + this.country + "'" + ", language='" + this.language + "'";
    }
}

