/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia.codec.video.h264;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.sip.communicator.impl.neomedia.NeomediaActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jitsi.impl.neomedia.codec.video.h264.JNIEncoder;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class ConfigurationPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;

    public ConfigurationPanel() {
        super((LayoutManager)new BorderLayout());
        TransparentPanel contentPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        this.add((Component)contentPanel, "North");
        ResourceManagementService r = NeomediaActivator.getResources();
        GridBagConstraints cnstrnts = new GridBagConstraints();
        cnstrnts.anchor = 23;
        cnstrnts.fill = 2;
        Component defaultProfileLabel = this.createLineWrapLabel(r.getI18NString("impl.neomedia.configform.H264.defaultProfile"));
        cnstrnts.gridx = 0;
        cnstrnts.gridy = 0;
        cnstrnts.weightx = 1.0;
        contentPanel.add(defaultProfileLabel, (Object)cnstrnts);
        JComboBox<NameValuePair> defaultProfileComboBox = new JComboBox<NameValuePair>();
        defaultProfileComboBox.setEditable(false);
        defaultProfileComboBox.addItem(new NameValuePair(r.getI18NString("impl.neomedia.configform.H264.defaultProfile.baseline"), "baseline"));
        defaultProfileComboBox.addItem(new NameValuePair(r.getI18NString("impl.neomedia.configform.H264.defaultProfile.main"), "main"));
        defaultProfileComboBox.addItem(new NameValuePair(r.getI18NString("impl.neomedia.configform.H264.defaultProfile.high"), "high"));
        cnstrnts.gridx = 1;
        cnstrnts.gridy = 0;
        cnstrnts.weightx = 0.0;
        contentPanel.add(defaultProfileComboBox, (Object)cnstrnts);
        Component preferredKeyFrameRequesterLabel = this.createLineWrapLabel(r.getI18NString("impl.neomedia.configform.H264.preferredKeyFrameRequester"));
        cnstrnts.gridx = 0;
        cnstrnts.gridy = 1;
        cnstrnts.weightx = 1.0;
        contentPanel.add(preferredKeyFrameRequesterLabel, (Object)cnstrnts);
        JComboBox<NameValuePair> preferredKeyFrameRequesterComboBox = new JComboBox<NameValuePair>();
        preferredKeyFrameRequesterComboBox.setEditable(false);
        preferredKeyFrameRequesterComboBox.addItem(new NameValuePair(r.getI18NString("impl.neomedia.configform.H264.preferredKeyFrameRequester.rtcp"), "rtcp"));
        preferredKeyFrameRequesterComboBox.addItem(new NameValuePair(r.getI18NString("impl.neomedia.configform.H264.preferredKeyFrameRequester.signaling"), "signaling"));
        cnstrnts.gridx = 1;
        cnstrnts.gridy = 1;
        cnstrnts.weightx = 0.0;
        contentPanel.add(preferredKeyFrameRequesterComboBox, (Object)cnstrnts);
        Component presetLabel = this.createLineWrapLabel(r.getI18NString("impl.neomedia.configform.H264.preset"));
        cnstrnts.gridx = 0;
        cnstrnts.gridy = 2;
        cnstrnts.weightx = 1.0;
        contentPanel.add(presetLabel, (Object)cnstrnts);
        JComboBox<NameValuePair> presetComboBox = new JComboBox<NameValuePair>();
        presetComboBox.setEditable(false);
        for (String preset : JNIEncoder.AVAILABLE_PRESETS) {
            presetComboBox.addItem(new NameValuePair(preset, preset));
        }
        cnstrnts.gridx = 1;
        cnstrnts.gridy = 2;
        cnstrnts.weightx = 0.0;
        contentPanel.add(presetComboBox, (Object)cnstrnts);
        SIPCommCheckBox defaultIntraRefreshCheckBox = new SIPCommCheckBox(r.getI18NString("impl.neomedia.configform.H264.defaultIntraRefresh"));
        cnstrnts.gridwidth = 0;
        cnstrnts.gridx = 0;
        cnstrnts.gridy = 3;
        cnstrnts.weightx = 1.0;
        contentPanel.add((Component)defaultIntraRefreshCheckBox, (Object)cnstrnts);
        cnstrnts.gridwidth = 1;
        Component keyintLabel = this.createLineWrapLabel(r.getI18NString("impl.neomedia.configform.H264.keyint"));
        cnstrnts.gridx = 0;
        cnstrnts.gridy = 4;
        cnstrnts.weightx = 1.0;
        contentPanel.add(keyintLabel, (Object)cnstrnts);
        JSpinner keyintSpinner = new JSpinner(new SpinnerNumberModel(150, 1, 0x40000000, 15));
        cnstrnts.gridx = 1;
        cnstrnts.gridy = 4;
        cnstrnts.weightx = 0.0;
        contentPanel.add((Component)keyintSpinner, (Object)cnstrnts);
        ConfigurationService cfg = NeomediaActivator.getConfigurationService();
        this.setSelectedNameValuePair(defaultProfileComboBox, cfg.getString("net.java.sip.communicator.impl.neomedia.codec.video.h264.defaultProfile", "main"));
        this.addActionListener(defaultProfileComboBox, "net.java.sip.communicator.impl.neomedia.codec.video.h264.defaultProfile");
        this.setSelectedNameValuePair(preferredKeyFrameRequesterComboBox, cfg.getString("net.java.sip.communicator.impl.neomedia.codec.video.h264.preferredKeyFrameRequester", "rtcp"));
        this.addActionListener(preferredKeyFrameRequesterComboBox, "net.java.sip.communicator.impl.neomedia.codec.video.h264.preferredKeyFrameRequester");
        this.setSelectedNameValuePair(presetComboBox, cfg.getString("org.jitsi.impl.neomedia.codec.video.h264.preset", JNIEncoder.DEFAULT_PRESET));
        this.addActionListener(presetComboBox, "org.jitsi.impl.neomedia.codec.video.h264.preset");
        defaultIntraRefreshCheckBox.setSelected(cfg.getBoolean("org.jitsi.impl.neomedia.codec.video.h264.defaultIntraRefresh", true));
        defaultIntraRefreshCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                NeomediaActivator.getConfigurationService().setProperty("org.jitsi.impl.neomedia.codec.video.h264.defaultIntraRefresh", (Object)Boolean.toString(checkBox.isSelected()));
            }
        });
        keyintSpinner.setValue(cfg.getInt("org.jitsi.impl.neomedia.codec.video.h264.keyint", 150));
        keyintSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                int value = model.getNumber().intValue();
                NeomediaActivator.getConfigurationService().setProperty("org.jitsi.impl.neomedia.codec.video.h264.keyint", (Object)Integer.toString(value));
            }
        });
    }

    private void addActionListener(final JComboBox comboBox, final String property) {
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NameValuePair nameValuePair = (NameValuePair)comboBox.getSelectedItem();
                if (nameValuePair != null) {
                    NeomediaActivator.getConfigurationService().setProperty(property, (Object)nameValuePair.value);
                }
            }
        });
    }

    private Component createLineWrapLabel(String text) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setFocusable(false);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        textArea.setWrapStyleWord(true);
        textArea.setText(text);
        return textArea;
    }

    private void setSelectedNameValuePair(JComboBox comboBox, String value) {
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            NameValuePair nameValuePair = (NameValuePair)comboBox.getItemAt(i);
            if (!nameValuePair.value.equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    private static class NameValuePair {
        public final String name;
        public final String value;

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }
}

