/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.Utils;

public class UtilsTest
extends TestCase {
    public void testNullText() {
        Assert.assertEquals(null, (String)Utils.parseIrcMessage(null));
    }

    public void testParseEmptyString() {
        Assert.assertEquals((String)"", (String)Utils.parseIrcMessage(""));
    }

    public void testParseStringWithoutControlCodes() {
        String message = "My normal message without any control codes.";
        Assert.assertEquals((String)"My normal message without any control codes.", (String)Utils.parseIrcMessage("My normal message without any control codes."));
    }

    public void testParseStringWithBoldCode() {
        String ircMessage = "My \u0002bold\u0002 message \u0002BOLD!\u0002.";
        String htmlMessage = "My <b>bold</b> message <b>BOLD!</b>.";
        Assert.assertEquals((String)"My <b>bold</b> message <b>BOLD!</b>.", (String)Utils.parseIrcMessage("My \u0002bold\u0002 message \u0002BOLD!\u0002."));
    }

    public void testParseStringWithItalicsCode() {
        String ircMessage = "My \u0016italics\u0016 message \u0016ITALICS!\u0016.";
        String htmlMessage = "My <i>italics</i> message <i>ITALICS!</i>.";
        Assert.assertEquals((String)"My <i>italics</i> message <i>ITALICS!</i>.", (String)Utils.parseIrcMessage("My \u0016italics\u0016 message \u0016ITALICS!\u0016."));
    }

    public void testParseStringWithUnderlineCode() {
        String ircMessage = "My \u001funderlined\u001f message \u001fUNDERLINED!!!\u001f.";
        String htmlMessage = "My <u>underlined</u> message <u>UNDERLINED!!!</u>.";
        Assert.assertEquals((String)"My <u>underlined</u> message <u>UNDERLINED!!!</u>.", (String)Utils.parseIrcMessage("My \u001funderlined\u001f message \u001fUNDERLINED!!!\u001f."));
    }

    public void testParseStringWithForegroundColorCode() {
        String ircMessage = "My \u000304RED\u0003 message.";
        String htmlMessage = "My <font color=\"Red\">RED</font> message.";
        Assert.assertEquals((String)"My <font color=\"Red\">RED</font> message.", (String)Utils.parseIrcMessage("My \u000304RED\u0003 message."));
    }

    public void testParseStringWithForegroundAndBackgroundColorCode() {
        String ircMessage = "My \u000304,12RED on Light Blue\u0003 message.";
        String htmlMessage = "My <font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue</font> message.";
        Assert.assertEquals((String)"My <font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue</font> message.", (String)Utils.parseIrcMessage("My \u000304,12RED on Light Blue\u0003 message."));
    }

    public void testParseStringWithInvalidBgColorCode() {
        String ircMessage = "My \u000304,BRIGHT RED on Light Blue\u0003 message.";
        String htmlMessage = "My <font color=\"Red\">,BRIGHT RED on Light Blue</font> message.";
        Assert.assertEquals((String)"My <font color=\"Red\">,BRIGHT RED on Light Blue</font> message.", (String)Utils.parseIrcMessage("My \u000304,BRIGHT RED on Light Blue\u0003 message."));
    }

    public void testParseStringWithInvalidColorControlCode() {
        String ircMessage = "My \u0003BRIGHT RED on Light Blue\u0003 message.";
        String htmlMessage = "My BRIGHT RED on Light Blue message.";
        Assert.assertEquals((String)"My BRIGHT RED on Light Blue message.", (String)Utils.parseIrcMessage("My \u0003BRIGHT RED on Light Blue\u0003 message."));
    }

    public void testParseStringWithInvalidSecondControlCode() {
        String ircMessage = "My \u000304,12RED on Light Blue\u000304,12 message.";
        String htmlMessage = "My <font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue<font color=\"Red\" bgcolor=\"RoyalBlue\"> message.</font></font>";
        Assert.assertEquals((String)"My <font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue<font color=\"Red\" bgcolor=\"RoyalBlue\"> message.</font></font>", (String)Utils.parseIrcMessage("My \u000304,12RED on Light Blue\u000304,12 message."));
    }

    public void testParseStringWithIncompleteForegroundColorControlCode() {
        String ircMessage = "My \u0003";
        String htmlMessage = "My ";
        Assert.assertTrue((boolean)Utils.parseIrcMessage("My \u0003").startsWith("My "));
    }

    public void testParseStringWithIncompleteBackgroundColorControlCode() {
        String ircMessage = "My \u000310,";
        String htmlMessage = "My <font color=\"Teal\">,";
        Assert.assertTrue((boolean)Utils.parseIrcMessage("My \u000310,").startsWith("My <font color=\"Teal\">,"));
    }

    public void testParseSringAndNeutralizeWithNormalControlCode() {
        String ircMessage = "My \u0002\u0016\u001f\u000304,12RED on Light Blue\u000f message.";
        String htmlMessage = "My <b><i><u><font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue</font></u></i></b> message.";
        Assert.assertEquals((String)"My <b><i><u><font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue</font></u></i></b> message.", (String)Utils.parseIrcMessage("My \u0002\u0016\u001f\u000304,12RED on Light Blue\u000f message."));
    }

    public void testParseStringWithUnclosedFormattingI() {
        String ircMessage = "My \u0002\u0016\u001f\u000304,12RED on Light Blue message.";
        String htmlMessage = "My <b><i><u><font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue message.</font></u></i></b>";
        Assert.assertEquals((String)"My <b><i><u><font color=\"Red\" bgcolor=\"RoyalBlue\">RED on Light Blue message.</font></u></i></b>", (String)Utils.parseIrcMessage("My \u0002\u0016\u001f\u000304,12RED on Light Blue message."));
    }

    public void testParseUnknownForegroundColor() {
        String ircMessage = "\u000399TEST";
        String htmlMessage = "<font color=\"Green\">TEST</font>";
        Assert.assertEquals((String)"<font color=\"Green\">TEST</font>", (String)Utils.parseIrcMessage("\u000399TEST"));
    }

    public void testParseUnknownBackgroundColor() {
        String ircMessage = "\u000300,99TEST";
        String htmlMessage = "<font color=\"White\" bgcolor=\"Green\">TEST</font>";
        Assert.assertEquals((String)"<font color=\"White\" bgcolor=\"Green\">TEST</font>", (String)Utils.parseIrcMessage("\u000300,99TEST"));
    }

    public void testStackIncompatibleFormatToggling() {
        String ircMessage = "\u0002\u0016\u001fHello\u0002 W\u0016orld\u001f!";
        String htmlMessage = "<b><i><u>Hello</u></i></b><i><u> W</u></i><u>orld</u>!";
        Assert.assertEquals((String)"<b><i><u>Hello</u></i></b><i><u> W</u></i><u>orld</u>!", (String)Utils.parseIrcMessage("\u0002\u0016\u001fHello\u0002 W\u0016orld\u001f!"));
    }

    public void testColorSwitch() {
        String ircMessage = "\u000302,03Hello \u000308,09World\u000f!";
        String htmlMessage = "<font color=\"Navy\" bgcolor=\"Green\">Hello <font color=\"Yellow\" bgcolor=\"Lime\">World</font></font>!";
        Assert.assertEquals((String)"<font color=\"Navy\" bgcolor=\"Green\">Hello <font color=\"Yellow\" bgcolor=\"Lime\">World</font></font>!", (String)Utils.parseIrcMessage("\u000302,03Hello \u000308,09World\u000f!"));
    }

    public void testForegroundColorChange() {
        String ircMessage = "\u000302,03Hello \u000308World\u000f!";
        String htmlMessage = "<font color=\"Navy\" bgcolor=\"Green\">Hello <font color=\"Yellow\">World</font></font>!";
        Assert.assertEquals((String)"<font color=\"Navy\" bgcolor=\"Green\">Hello <font color=\"Yellow\">World</font></font>!", (String)Utils.parseIrcMessage("\u000302,03Hello \u000308World\u000f!"));
    }

    public void testCancelColorFormat() {
        String ircMessage = "\u000302With color\u0003 and without color.";
        String htmlMessage = "<font color=\"Navy\">With color</font> and without color.";
        Assert.assertEquals((String)"<font color=\"Navy\">With color</font> and without color.", (String)Utils.parseIrcMessage("\u000302With color\u0003 and without color."));
    }

    public void testMessageContainingHtmlEntities() {
        String ircMessage = "\u0002This<b> is very</b> bad &&& text!!!<!-- \u0002<i>";
        String parsedMessage = "<b>This&lt;b&gt; is very&lt;/b&gt; bad &amp;&amp;&amp; text!!!&lt;!-- </b>&lt;i&gt;";
        Assert.assertEquals((String)"<b>This&lt;b&gt; is very&lt;/b&gt; bad &amp;&amp;&amp; text!!!&lt;!-- </b>&lt;i&gt;", (String)Utils.parseIrcMessage("\u0002This<b> is very</b> bad &&& text!!!<!-- \u0002<i>"));
    }

    public void testStyleAsMessage() {
        String message = "hello world";
        Assert.assertEquals((String)message, (String)Utils.styleAsMessage(message));
    }

    public void testStyleAsNotice() {
        String message = "hello world";
        String nick = "MrNiceGuy";
        Assert.assertEquals((String)"<i>MrNiceGuy</i>: hello world", (String)Utils.styleAsNotice(message, nick));
    }
}

