/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import net.java.sip.communicator.service.notification.CommandNotificationAction;
import net.java.sip.communicator.service.notification.CommandNotificationHandler;
import net.java.sip.communicator.service.notification.LogMessageNotificationAction;
import net.java.sip.communicator.service.notification.LogMessageNotificationHandler;
import net.java.sip.communicator.service.notification.Notification;
import net.java.sip.communicator.service.notification.NotificationAction;
import net.java.sip.communicator.service.notification.NotificationChangeListener;
import net.java.sip.communicator.service.notification.NotificationData;
import net.java.sip.communicator.service.notification.NotificationHandler;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.NotificationServiceActivator;
import net.java.sip.communicator.service.notification.PopupMessageNotificationAction;
import net.java.sip.communicator.service.notification.PopupMessageNotificationHandler;
import net.java.sip.communicator.service.notification.SoundNotificationAction;
import net.java.sip.communicator.service.notification.SoundNotificationHandler;
import net.java.sip.communicator.service.notification.VibrateNotificationAction;
import net.java.sip.communicator.service.notification.VibrateNotificationHandler;
import net.java.sip.communicator.service.notification.event.NotificationActionTypeEvent;
import net.java.sip.communicator.service.notification.event.NotificationEventTypeEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;

class NotificationServiceImpl
implements NotificationService {
    private static final String NOTIFICATIONS_PREFIX = "net.java.sip.communicator.impl.notifications";
    public static final int NUM_ACTIONS = 4;
    private final List<NotificationChangeListener> changeListeners = new Vector<NotificationChangeListener>();
    private final ConfigurationService configService = NotificationServiceActivator.getConfigurationService();
    private final Map<String, Notification> defaultNotifications = new HashMap<String, Notification>();
    private final Map<String, NotificationHandler> handlers = new HashMap<String, NotificationHandler>();
    private final Logger logger = Logger.getLogger(NotificationServiceImpl.class);
    private Queue<NotificationData> notificationCache = new LinkedList<NotificationData>();
    private final Map<String, Notification> notifications = new HashMap<String, Notification>();

    NotificationServiceImpl() {
        this.loadNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionHandler(NotificationHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Map<String, NotificationHandler> map = this.handlers;
        synchronized (map) {
            this.handlers.put(handler.getActionType(), handler);
            if (this.handlers.size() == 4 && this.notificationCache != null) {
                for (NotificationData event : this.notificationCache) {
                    this.fireNotification(event);
                }
                this.notificationCache.clear();
                this.notificationCache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationChangeListener(NotificationChangeListener listener) {
        List<NotificationChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(listener);
        }
    }

    private void checkDefaultAgainstLoadedNotification(String eventType, NotificationAction defaultAction) {
        if (defaultAction instanceof SoundNotificationAction) {
            boolean isSoundPCSpeakerEnabledPropExist;
            boolean isSoundPlaybackEnabledPropExist;
            boolean isSoundNotificationEnabledPropExist;
            SoundNotificationAction soundDefaultAction = (SoundNotificationAction)defaultAction;
            SoundNotificationAction soundAction = (SoundNotificationAction)this.getEventNotificationAction(eventType, "SoundAction");
            boolean bl = isSoundNotificationEnabledPropExist = this.getNotificationActionProperty(eventType, defaultAction, "isSoundNotificationEnabled") != null;
            if (!isSoundNotificationEnabledPropExist) {
                soundAction.setSoundNotificationEnabled(soundDefaultAction.isSoundNotificationEnabled());
            }
            boolean bl2 = isSoundPlaybackEnabledPropExist = this.getNotificationActionProperty(eventType, defaultAction, "isSoundPlaybackEnabled") != null;
            if (!isSoundPlaybackEnabledPropExist) {
                soundAction.setSoundPlaybackEnabled(soundDefaultAction.isSoundPlaybackEnabled());
            }
            boolean bl3 = isSoundPCSpeakerEnabledPropExist = this.getNotificationActionProperty(eventType, defaultAction, "isSoundPCSpeakerEnabled") != null;
            if (!isSoundPCSpeakerEnabledPropExist) {
                soundAction.setSoundPCSpeakerEnabled(soundDefaultAction.isSoundPCSpeakerEnabled());
            }
            boolean fixDialingLoop = false;
            if (eventType.equals("Dialing") && soundAction.getLoopInterval() == 0) {
                soundAction.setLoopInterval(soundDefaultAction.getLoopInterval());
                fixDialingLoop = true;
            }
            if (!isSoundNotificationEnabledPropExist || !isSoundPCSpeakerEnabledPropExist || !isSoundPlaybackEnabledPropExist || fixDialingLoop) {
                this.saveNotification(eventType, soundAction, soundAction.isEnabled(), false);
            }
        }
    }

    private void fireNotification(NotificationData data) {
        Notification notification = this.notifications.get(data.getEventType());
        if (notification == null || !notification.isActive()) {
            return;
        }
        for (NotificationAction action : notification.getActions().values()) {
            NotificationHandler handler;
            String actionType = action.getActionType();
            if (!action.isEnabled() || (handler = this.handlers.get(actionType)) == null) continue;
            try {
                if (actionType.equals("PopupMessageAction")) {
                    ((PopupMessageNotificationHandler)handler).popupMessage((PopupMessageNotificationAction)action, data.getTitle(), data.getMessage(), data.getIcon(), data.getExtra("PopupMessageNotificationHandler.tag"));
                    continue;
                }
                if (actionType.equals("LogMessageAction")) {
                    ((LogMessageNotificationHandler)handler).logMessage((LogMessageNotificationAction)action, data.getMessage());
                    continue;
                }
                if (actionType.equals("SoundAction")) {
                    SoundNotificationAction soundNotificationAction = (SoundNotificationAction)action;
                    if (!soundNotificationAction.isSoundNotificationEnabled() && !soundNotificationAction.isSoundPlaybackEnabled() && !soundNotificationAction.isSoundPCSpeakerEnabled()) continue;
                    ((SoundNotificationHandler)handler).start((SoundNotificationAction)action, data);
                    continue;
                }
                if (actionType.equals("CommandAction")) {
                    Map cmdargs = (Map)data.getExtra("CommandNotificationHandler.cmdargs");
                    ((CommandNotificationHandler)handler).execute((CommandNotificationAction)action, cmdargs);
                    continue;
                }
                if (!actionType.equals("VibrateAction")) continue;
                ((VibrateNotificationHandler)handler).vibrate((VibrateNotificationAction)action);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error dispatching notification of type" + actionType + " from " + handler), (Throwable)e);
            }
        }
    }

    @Override
    public NotificationData fireNotification(String eventType) {
        return this.fireNotification(eventType, null, null, null);
    }

    @Override
    public NotificationData fireNotification(String eventType, String title, String message, byte[] icon) {
        return this.fireNotification(eventType, title, message, icon, null);
    }

    @Override
    public NotificationData fireNotification(String eventType, String title, String message, byte[] icon, Map<String, Object> extras) {
        Notification notification = this.notifications.get(eventType);
        if (notification == null || !notification.isActive()) {
            return null;
        }
        NotificationData data = new NotificationData(eventType, title, message, icon, extras);
        if (this.notificationCache != null) {
            this.notificationCache.add(data);
        } else {
            this.fireNotification(data);
        }
        return data;
    }

    private void fireNotificationActionTypeEvent(String eventType, String sourceEventType, NotificationAction action) {
        NotificationActionTypeEvent event = new NotificationActionTypeEvent(this, eventType, sourceEventType, action);
        for (NotificationChangeListener listener : this.changeListeners) {
            if (eventType.equals("ActionAdded")) {
                listener.actionAdded(event);
                continue;
            }
            if (eventType.equals("ActionRemoved")) {
                listener.actionRemoved(event);
                continue;
            }
            if (!eventType.equals("ActionChanged")) continue;
            listener.actionChanged(event);
        }
    }

    private void fireNotificationEventTypeEvent(String eventType, String sourceEventType) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatching NotificationEventType Change. Listeners=" + this.changeListeners.size() + " evt=" + eventType));
        }
        NotificationEventTypeEvent event = new NotificationEventTypeEvent(this, eventType, sourceEventType);
        for (NotificationChangeListener listener : this.changeListeners) {
            if (eventType.equals("EventTypeAdded")) {
                listener.eventTypeAdded(event);
                continue;
            }
            if (!eventType.equals("EventTypeRemoved")) continue;
            listener.eventTypeRemoved(event);
        }
    }

    @Override
    public Iterable<NotificationHandler> getActionHandlers(String actionType) {
        if (actionType != null) {
            NotificationHandler handler = this.handlers.get(actionType);
            Set<Object> ret = handler == null ? Collections.emptySet() : Collections.singleton(handler);
            return ret;
        }
        return this.handlers.values();
    }

    @Override
    public NotificationAction getEventNotificationAction(String eventType, String actionType) {
        Notification notification = this.notifications.get(eventType);
        return notification == null ? null : notification.getAction(actionType);
    }

    private String getNotificationActionProperty(String eventType, NotificationAction action, String property) throws IllegalArgumentException {
        String eventTypeNodeName = null;
        String actionTypeNodeName = null;
        List eventTypes = this.configService.getPropertyNamesByPrefix(NOTIFICATIONS_PREFIX, true);
        for (String eventTypeRootPropName : eventTypes) {
            String eType = this.configService.getString(eventTypeRootPropName);
            if (!eType.equals(eventType)) continue;
            eventTypeNodeName = eventTypeRootPropName;
        }
        if (eventTypeNodeName == null) {
            throw new IllegalArgumentException("Missing event type node");
        }
        String actionPrefix = eventTypeNodeName + ".actions";
        List actionTypes = this.configService.getPropertyNamesByPrefix(actionPrefix, true);
        for (String actionTypeRootPropName : actionTypes) {
            String aType = this.configService.getString(actionTypeRootPropName);
            if (!aType.equals(action.getActionType())) continue;
            actionTypeNodeName = actionTypeRootPropName;
        }
        if (actionTypeNodeName == null) {
            throw new IllegalArgumentException("Missing action type node");
        }
        return (String)this.configService.getProperty(actionTypeNodeName + "." + property);
    }

    @Override
    public Iterable<String> getRegisteredEvents() {
        return Collections.unmodifiableSet(this.notifications.keySet());
    }

    @Override
    public boolean isActive(String eventType) {
        Notification eventNotification = this.notifications.get(eventType);
        if (eventNotification == null) {
            return false;
        }
        return eventNotification.isActive();
    }

    private boolean isDefault(String eventType, String actionType) {
        List eventTypes = this.configService.getPropertyNamesByPrefix(NOTIFICATIONS_PREFIX, true);
        for (String eventTypeRootPropName : eventTypes) {
            String eType = this.configService.getString(eventTypeRootPropName);
            if (!eType.equals(eventType)) continue;
            List actions = this.configService.getPropertyNamesByPrefix(eventTypeRootPropName + ".actions", true);
            for (String actionPropName : actions) {
                String aType = this.configService.getString(actionPropName);
                if (!aType.equals(actionType)) continue;
                Object isDefaultdObj = this.configService.getProperty(actionPropName + ".default");
                if (isDefaultdObj == null) {
                    return true;
                }
                return Boolean.parseBoolean((String)isDefaultdObj);
            }
        }
        return true;
    }

    private boolean isEnabled(String configProperty) {
        Object isEnabledObj = this.configService.getProperty(configProperty);
        if (isEnabledObj == null) {
            return true;
        }
        return Boolean.parseBoolean((String)isEnabledObj);
    }

    private void loadNotifications() {
        List eventTypes = this.configService.getPropertyNamesByPrefix(NOTIFICATIONS_PREFIX, true);
        for (String eventTypeRootPropName : eventTypes) {
            boolean isEventActive = this.isEnabled(eventTypeRootPropName + ".active");
            String eventType = this.configService.getString(eventTypeRootPropName);
            List actions = this.configService.getPropertyNamesByPrefix(eventTypeRootPropName + ".actions", true);
            for (String actionPropName : actions) {
                String actionType = this.configService.getString(actionPropName);
                NotificationAction action = null;
                if (actionType.equals("SoundAction")) {
                    String soundFileDescriptor = this.configService.getString(actionPropName + ".soundFileDescriptor");
                    String loopInterval = this.configService.getString(actionPropName + ".loopInterval");
                    boolean isSoundNotificationEnabled = this.configService.getBoolean(actionPropName + ".isSoundNotificationEnabled", soundFileDescriptor != null);
                    boolean isSoundPlaybackEnabled = this.configService.getBoolean(actionPropName + ".isSoundPlaybackEnabled", false);
                    boolean isSoundPCSpeakerEnabled = this.configService.getBoolean(actionPropName + ".isSoundPCSpeakerEnabled", false);
                    action = new SoundNotificationAction(soundFileDescriptor, Integer.parseInt(loopInterval), isSoundNotificationEnabled, isSoundPlaybackEnabled, isSoundPCSpeakerEnabled);
                } else if (actionType.equals("PopupMessageAction")) {
                    String defaultMessage = this.configService.getString(actionPropName + ".defaultMessage");
                    long timeout = this.configService.getLong(actionPropName + ".timeout", -1L);
                    String groupName = this.configService.getString(actionPropName + ".groupName");
                    action = new PopupMessageNotificationAction(defaultMessage, timeout, groupName);
                } else if (actionType.equals("LogMessageAction")) {
                    String logType = this.configService.getString(actionPropName + ".logType");
                    action = new LogMessageNotificationAction(logType);
                } else if (actionType.equals("CommandAction")) {
                    String commandDescriptor = this.configService.getString(actionPropName + ".commandDescriptor");
                    action = new CommandNotificationAction(commandDescriptor);
                } else if (actionType.equals("VibrateAction")) {
                    String descriptor = this.configService.getString(actionPropName + ".descriptor");
                    int patternLen = this.configService.getInt(actionPropName + ".patternLength", -1);
                    if (patternLen == -1) {
                        this.logger.error((Object)("Invalid pattern length: " + patternLen));
                        continue;
                    }
                    long[] pattern = new long[patternLen];
                    for (int pIdx = 0; pIdx < patternLen; ++pIdx) {
                        pattern[pIdx] = this.configService.getLong(actionPropName + ".patternItem" + pIdx, -1L);
                        if (pattern[pIdx] != -1L) continue;
                        this.logger.error((Object)("Invalid pattern interval: " + pattern));
                    }
                    int repeat = this.configService.getInt(actionPropName + ".repeat", -1);
                    action = new VibrateNotificationAction(descriptor, pattern, repeat);
                }
                action.setEnabled(this.isEnabled(actionPropName + ".enabled"));
                Notification notification = this.notifications.get(eventType);
                if (notification == null) {
                    notification = new Notification(eventType);
                    this.notifications.put(eventType, notification);
                }
                notification.setActive(isEventActive);
                notification.addAction(action);
            }
        }
    }

    @Override
    public void registerDefaultNotificationForEvent(String eventType, NotificationAction action) {
        if (this.isDefault(eventType, action.getActionType())) {
            NotificationAction h = this.getEventNotificationAction(eventType, action.getActionType());
            boolean isNew = false;
            if (h == null) {
                isNew = true;
                h = action;
            }
            this.saveNotification(eventType, action, h.isEnabled(), true);
            Notification notification = null;
            if (this.notifications.containsKey(eventType)) {
                notification = this.notifications.get(eventType);
            } else {
                notification = new Notification(eventType);
                this.notifications.put(eventType, notification);
            }
            notification.addAction(action);
            this.fireNotificationActionTypeEvent(isNew ? "ActionAdded" : "ActionChanged", eventType, action);
        } else {
            this.checkDefaultAgainstLoadedNotification(eventType, action);
        }
        Notification notification = null;
        if (this.defaultNotifications.containsKey(eventType)) {
            notification = this.defaultNotifications.get(eventType);
        } else {
            notification = new Notification(eventType);
            this.defaultNotifications.put(eventType, notification);
        }
        notification.addAction(action);
    }

    @Override
    public void registerDefaultNotificationForEvent(String eventType, String actionType, String actionDescriptor, String defaultMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering default event " + eventType + "/" + actionType + "/" + actionDescriptor + "/" + defaultMessage));
        }
        if (this.isDefault(eventType, actionType)) {
            NotificationAction action = this.getEventNotificationAction(eventType, actionType);
            boolean isNew = false;
            if (action == null) {
                isNew = true;
                if (actionType.equals("SoundAction")) {
                    action = new SoundNotificationAction(actionDescriptor, -1);
                } else if (actionType.equals("LogMessageAction")) {
                    action = new LogMessageNotificationAction("InfoLog");
                } else if (actionType.equals("PopupMessageAction")) {
                    action = new PopupMessageNotificationAction(defaultMessage);
                } else if (actionType.equals("CommandAction")) {
                    action = new CommandNotificationAction(actionDescriptor);
                }
            }
            this.saveNotification(eventType, action, action.isEnabled(), true);
            Notification notification = null;
            if (this.notifications.containsKey(eventType)) {
                notification = this.notifications.get(eventType);
            } else {
                notification = new Notification(eventType);
                this.notifications.put(eventType, notification);
            }
            notification.addAction(action);
            this.fireNotificationActionTypeEvent(isNew ? "ActionAdded" : "ActionChanged", eventType, action);
        }
        Notification notification = null;
        if (this.defaultNotifications.containsKey(eventType)) {
            notification = this.defaultNotifications.get(eventType);
        } else {
            notification = new Notification(eventType);
            this.defaultNotifications.put(eventType, notification);
        }
        NotificationAction action = null;
        if (actionType.equals("SoundAction")) {
            action = new SoundNotificationAction(actionDescriptor, -1);
        } else if (actionType.equals("LogMessageAction")) {
            action = new LogMessageNotificationAction("InfoLog");
        } else if (actionType.equals("PopupMessageAction")) {
            action = new PopupMessageNotificationAction(defaultMessage);
        } else if (actionType.equals("CommandAction")) {
            action = new CommandNotificationAction(actionDescriptor);
        }
        notification.addAction(action);
    }

    @Override
    public void registerNotificationForEvent(String eventType, NotificationAction action) {
        Notification notification = null;
        if (this.notifications.containsKey(eventType)) {
            notification = this.notifications.get(eventType);
        } else {
            notification = new Notification(eventType);
            this.notifications.put(eventType, notification);
            this.fireNotificationEventTypeEvent("EventTypeAdded", eventType);
        }
        Object existingAction = notification.addAction(action);
        if (existingAction != null) {
            this.fireNotificationActionTypeEvent("ActionChanged", eventType, action);
        } else {
            this.fireNotificationActionTypeEvent("ActionAdded", eventType, action);
        }
        this.saveNotification(eventType, action, true, false);
    }

    @Override
    public void registerNotificationForEvent(String eventType, String actionType, String actionDescriptor, String defaultMessage) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering event " + eventType + "/" + actionType + "/" + actionDescriptor + "/" + defaultMessage));
        }
        if (actionType.equals("SoundAction")) {
            Notification notification = this.defaultNotifications.get(eventType);
            SoundNotificationAction action = (SoundNotificationAction)notification.getAction("SoundAction");
            this.registerNotificationForEvent(eventType, new SoundNotificationAction(actionDescriptor, action.getLoopInterval()));
        } else if (actionType.equals("LogMessageAction")) {
            this.registerNotificationForEvent(eventType, new LogMessageNotificationAction("InfoLog"));
        } else if (actionType.equals("PopupMessageAction")) {
            this.registerNotificationForEvent(eventType, new PopupMessageNotificationAction(defaultMessage));
        } else if (actionType.equals("CommandAction")) {
            this.registerNotificationForEvent(eventType, new CommandNotificationAction(actionDescriptor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionHandler(String actionType) {
        if (actionType == null) {
            throw new IllegalArgumentException("actionType cannot be null");
        }
        Map<String, NotificationHandler> map = this.handlers;
        synchronized (map) {
            this.handlers.remove(actionType);
        }
    }

    @Override
    public void removeEventNotification(String eventType) {
        this.notifications.remove(eventType);
        this.fireNotificationEventTypeEvent("EventTypeRemoved", eventType);
    }

    @Override
    public void removeEventNotificationAction(String eventType, String actionType) {
        Notification notification = this.notifications.get(eventType);
        if (notification == null) {
            return;
        }
        NotificationAction action = notification.getAction(actionType);
        if (action == null) {
            return;
        }
        notification.removeAction(actionType);
        this.saveNotification(eventType, action, false, false);
        this.fireNotificationActionTypeEvent("ActionRemoved", eventType, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationChangeListener(NotificationChangeListener listener) {
        List<NotificationChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(listener);
        }
    }

    @Override
    public void restoreDefaults() {
        for (String string : new Vector<String>(this.notifications.keySet())) {
            Notification notification = this.notifications.get(string);
            for (String actionType : new Vector<String>(notification.getActions().keySet())) {
                this.removeEventNotificationAction(string, actionType);
            }
            this.removeEventNotification(string);
        }
        for (Map.Entry entry : this.defaultNotifications.entrySet()) {
            String eventType = (String)entry.getKey();
            Notification notification = (Notification)entry.getValue();
            for (NotificationAction action : notification.getActions().values()) {
                this.registerNotificationForEvent(eventType, action);
            }
        }
    }

    private void saveNotification(String eventType, NotificationAction action, boolean isActive, boolean isDefault) {
        String eventTypeNodeName = null;
        String actionTypeNodeName = null;
        List eventTypes = this.configService.getPropertyNamesByPrefix(NOTIFICATIONS_PREFIX, true);
        for (String eventTypeRootPropName : eventTypes) {
            String eType = this.configService.getString(eventTypeRootPropName);
            if (!eType.equals(eventType)) continue;
            eventTypeNodeName = eventTypeRootPropName;
        }
        if (eventTypeNodeName == null) {
            eventTypeNodeName = "net.java.sip.communicator.impl.notifications.eventType" + Long.toString(System.currentTimeMillis());
            this.configService.setProperty(eventTypeNodeName, (Object)eventType);
        }
        if (action == null) {
            this.configService.setProperty(eventTypeNodeName + ".active", (Object)Boolean.toString(isActive));
            return;
        }
        String actionPrefix = eventTypeNodeName + ".actions";
        List actionTypes = this.configService.getPropertyNamesByPrefix(actionPrefix, true);
        for (String actionTypeRootPropName : actionTypes) {
            String aType = this.configService.getString(actionTypeRootPropName);
            if (!aType.equals(action.getActionType())) continue;
            actionTypeNodeName = actionTypeRootPropName;
        }
        HashMap<String, Object> configProperties = new HashMap<String, Object>();
        if (actionTypeNodeName == null) {
            actionTypeNodeName = actionPrefix + ".actionType" + Long.toString(System.currentTimeMillis());
            configProperties.put(actionTypeNodeName, action.getActionType());
        }
        if (action instanceof SoundNotificationAction) {
            SoundNotificationAction soundAction = (SoundNotificationAction)action;
            configProperties.put(actionTypeNodeName + ".soundFileDescriptor", soundAction.getDescriptor());
            configProperties.put(actionTypeNodeName + ".loopInterval", soundAction.getLoopInterval());
            configProperties.put(actionTypeNodeName + ".isSoundNotificationEnabled", soundAction.isSoundNotificationEnabled());
            configProperties.put(actionTypeNodeName + ".isSoundPlaybackEnabled", soundAction.isSoundPlaybackEnabled());
            configProperties.put(actionTypeNodeName + ".isSoundPCSpeakerEnabled", soundAction.isSoundPCSpeakerEnabled());
        } else if (action instanceof PopupMessageNotificationAction) {
            PopupMessageNotificationAction messageAction = (PopupMessageNotificationAction)action;
            configProperties.put(actionTypeNodeName + ".defaultMessage", messageAction.getDefaultMessage());
            configProperties.put(actionTypeNodeName + ".timeout", messageAction.getTimeout());
            configProperties.put(actionTypeNodeName + ".groupName", messageAction.getGroupName());
        } else if (action instanceof LogMessageNotificationAction) {
            LogMessageNotificationAction logMessageAction = (LogMessageNotificationAction)action;
            configProperties.put(actionTypeNodeName + ".logType", logMessageAction.getLogType());
        } else if (action instanceof CommandNotificationAction) {
            CommandNotificationAction commandAction = (CommandNotificationAction)action;
            configProperties.put(actionTypeNodeName + ".commandDescriptor", commandAction.getDescriptor());
        } else if (action instanceof VibrateNotificationAction) {
            VibrateNotificationAction vibrateAction = (VibrateNotificationAction)action;
            configProperties.put(actionTypeNodeName + ".descriptor", vibrateAction.getDescriptor());
            long[] pattern = vibrateAction.getPattern();
            configProperties.put(actionTypeNodeName + ".patternLength", pattern.length);
            for (int pIdx = 0; pIdx < pattern.length; ++pIdx) {
                configProperties.put(actionTypeNodeName + ".patternItem" + pIdx, pattern[pIdx]);
            }
            configProperties.put(actionTypeNodeName + ".repeat", vibrateAction.getRepeat());
        }
        configProperties.put(actionTypeNodeName + ".enabled", Boolean.toString(isActive));
        configProperties.put(actionTypeNodeName + ".default", Boolean.toString(isDefault));
        this.configService.setProperties(configProperties);
    }

    @Override
    public void setActive(String eventType, boolean isActive) {
        Notification eventNotification = this.notifications.get(eventType);
        if (eventNotification == null) {
            return;
        }
        eventNotification.setActive(isActive);
        this.saveNotification(eventType, null, isActive, false);
    }

    @Override
    public void stopNotification(NotificationData data) {
        Iterable<NotificationHandler> vibrateHandlers;
        Iterable<NotificationHandler> soundHandlers = this.getActionHandlers("SoundAction");
        if (soundHandlers != null) {
            for (NotificationHandler handler : soundHandlers) {
                if (!(handler instanceof SoundNotificationHandler)) continue;
                ((SoundNotificationHandler)handler).stop(data);
            }
        }
        if ((vibrateHandlers = this.getActionHandlers("VibrateAction")) != null) {
            for (NotificationHandler handler : vibrateHandlers) {
                ((VibrateNotificationHandler)handler).cancel();
            }
        }
    }

    @Override
    public boolean isPlayingNotification(NotificationData data) {
        boolean isPlaying = false;
        Iterable<NotificationHandler> soundHandlers = this.getActionHandlers("SoundAction");
        if (soundHandlers != null) {
            for (NotificationHandler handler : soundHandlers) {
                if (!(handler instanceof SoundNotificationHandler)) continue;
                isPlaying |= ((SoundNotificationHandler)handler).isPlaying(data);
            }
        }
        return isPlaying;
    }
}

