/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.batch;

import com.google.gdata.data.batch.BatchOperationType;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.util.Namespaces;

public class BatchOperation
extends Element {
    public static final ElementKey<Void, BatchOperation> KEY = ElementKey.of(new QName(Namespaces.batchNs, "operation"), BatchOperation.class);
    public static final AttributeKey<BatchOperationType> TYPE = AttributeKey.of(new QName("type"), BatchOperationType.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(TYPE).setRequired(true);
    }

    public BatchOperation() {
        super(KEY);
    }

    public BatchOperation(BatchOperationType type) {
        this();
        this.setType(type);
    }

    public BatchOperationType getType() {
        return this.getAttributeValue(TYPE);
    }

    public BatchOperation setType(BatchOperationType type) {
        this.setAttributeValue(TYPE, (Object)type);
        return this;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BatchOperation other = (BatchOperation)obj;
        return BatchOperation.eq((Object)this.getType(), (Object)other.getType());
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.getType() != null) {
            result = 37 * result + this.getType().hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        return "{BatchOperation type=" + (Object)((Object)this.getAttributeValue(TYPE)) + "}";
    }
}

