/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts.configform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsConnectionImpl;
import net.java.sip.communicator.impl.googlecontacts.configform.AccountSettingsForm;
import net.java.sip.communicator.impl.googlecontacts.configform.GoogleContactsTableModel;
import net.java.sip.communicator.impl.googlecontacts.configform.Resources;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.util.Logger;

public class GoogleContactsConfigForm
extends TransparentPanel
implements ConfigurationForm,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 0L;
    private static Logger logger = Logger.getLogger(GoogleContactsConfigForm.class);
    private JButton newButton = new JButton("+");
    private JButton modifyButton = new JButton(Resources.getString("impl.googlecontacts.EDIT"));
    private JButton removeButton = new JButton("-");
    private JTable accountTable = new JTable();
    private TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel rightPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private JPanel mainPanel = this;
    private GoogleContactsTableModel tableModel = new GoogleContactsTableModel();
    private final AccountSettingsForm settingsForm = new AccountSettingsForm();

    public GoogleContactsConfigForm() {
        super((LayoutManager)new BorderLayout());
        logger.trace((Object)"GoogleContacts configuration form.");
        this.initComponents();
    }

    private void initComponents() {
        this.modifyButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.newButton.setSize(this.newButton.getMinimumSize());
        this.modifyButton.setSize(this.modifyButton.getMinimumSize());
        this.removeButton.setSize(this.removeButton.getMinimumSize());
        this.accountTable.setRowHeight(22);
        this.accountTable.setSelectionMode(0);
        this.accountTable.setShowHorizontalLines(false);
        this.accountTable.setShowVerticalLines(false);
        this.accountTable.setModel(this.tableModel);
        this.accountTable.setAutoResizeMode(3);
        this.accountTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    // empty if block
                }
            }
        });
        this.settingsForm.setModal(true);
        this.rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rightPanel.add((Component)this.buttonsPanel, "North");
        this.scrollPane.getViewport().add(this.accountTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.mainPanel.add((Component)this.rightPanel, "South");
        this.mainPanel.setPreferredSize(new Dimension(500, 400));
        this.buttonsPanel.add((Component)this.newButton);
        this.buttonsPanel.add((Component)this.removeButton);
        this.buttonsPanel.add((Component)this.modifyButton);
        this.accountTable.getSelectionModel().addListSelectionListener(this);
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.modifyButton.setActionCommand("modify");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
    }

    public String getTitle() {
        return Resources.getString("impl.googlecontacts.CONFIG_FORM_TITLE");
    }

    public byte[] getIcon() {
        return Resources.getImageInBytes("GOOGLECONTACTS_CONFIG_FORM_ICON");
    }

    public Object getForm() {
        return this;
    }

    public int getIndex() {
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row = this.accountTable.getSelectedRow();
        if (e.getActionCommand().equals("new")) {
            this.settingsForm.setNameFieldEnabled(true);
            this.settingsForm.loadData(null);
            int ret = this.settingsForm.showDialog();
            if (ret == 1) {
                GoogleContactsConnectionImpl cnx = (GoogleContactsConnectionImpl)this.settingsForm.getConnection();
                this.tableModel.addAccount(cnx, true, cnx.getPrefix());
                new RefreshContactSourceThread(null, cnx).start();
                GoogleContactsActivator.getGoogleContactsService().saveConfig(cnx);
                this.refresh();
            }
        }
        if (e.getActionCommand().equals("modify") && row != -1) {
            this.settingsForm.setNameFieldEnabled(false);
            GoogleContactsConnectionImpl cnx = this.tableModel.getAccountAt(row);
            this.settingsForm.loadData(cnx);
            int ret = this.settingsForm.showDialog();
            if (ret == 1) {
                GoogleContactsActivator.getGoogleContactsService().saveConfig(cnx);
                if (cnx.isEnabled()) {
                    new RefreshContactSourceThread(cnx, cnx).start();
                }
                this.refresh();
            }
        }
        if (e.getActionCommand().equals("remove") && row != -1) {
            GoogleContactsConnectionImpl cnx = this.tableModel.getAccountAt(row);
            this.tableModel.removeAccount(cnx.getLogin());
            GoogleContactsActivator.getGoogleContactsService().removeConfig(cnx);
            new RefreshContactSourceThread(cnx, null).start();
            this.refresh();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.accountTable.getSelectedRow() == -1) {
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        if (!e.getValueIsAdjusting()) {
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            GoogleContactsActivator.getGoogleContactsService().saveConfig(this.tableModel.getAccountAt(this.accountTable.getSelectedRow()));
        }
    }

    private void refresh() {
        this.tableModel.fireTableStructureChanged();
    }

    public boolean isAdvanced() {
        return true;
    }

    public static class RefreshContactSourceThread
    extends Thread {
        private GoogleContactsConnection oldCnx = null;
        private GoogleContactsConnection newCnx = null;

        RefreshContactSourceThread(GoogleContactsConnection oldCnx, GoogleContactsConnection newCnx) {
            this.oldCnx = oldCnx;
            this.newCnx = newCnx;
        }

        @Override
        public void run() {
            if (this.oldCnx != null) {
                GoogleContactsActivator.getGoogleContactsService().removeContactSource(this.oldCnx);
            }
            if (this.newCnx != null) {
                GoogleContactsActivator.getGoogleContactsService().addContactSource(this.newCnx, true);
            }
        }
    }
}

