/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.notificationwiring;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import net.java.sip.communicator.plugin.notificationwiring.NotificationWiringActivator;
import net.java.sip.communicator.plugin.notificationwiring.SoundProperties;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.notification.NotificationAction;
import net.java.sip.communicator.service.notification.NotificationData;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.SoundNotificationAction;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityMessageEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityStatusEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationsListener;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class NotificationManager
implements AdHocChatRoomMessageListener,
CallChangeListener,
CallListener,
CallPeerConferenceListener,
CallPeerListener,
CallPeerSecurityListener,
ChatRoomMessageListener,
FileTransferListener,
LocalUserAdHocChatRoomPresenceListener,
LocalUserChatRoomPresenceListener,
MessageListener,
Recorder.Listener,
ServiceListener,
TypingNotificationsListener {
    public static final String BUSY_CALL = "BusyCall";
    public static final String CALL_SAVED = "CallSaved";
    public static final String CALL_SECURITY_ERROR = "CallSecurityError";
    public static final String CALL_SECURITY_ON = "CallSecurityOn";
    public static final ImageID DEFAULT_USER_PHOTO = new ImageID("service.gui.DEFAULT_USER_PHOTO");
    public static final String DIALING = "Dialing";
    public static final String HANG_UP = "HangUp";
    public static final String INCOMING_CALL = "IncomingCall";
    public static final String INCOMING_FILE = "IncomingFile";
    public static final String INCOMING_MESSAGE = "IncomingMessage";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final Logger logger = Logger.getLogger(NotificationManager.class);
    public static final String OUTGOING_CALL = "OutgoingCall";
    public static final String PROACTIVE_NOTIFICATION = "ProactiveNotification";
    public static final String SECURITY_MESSAGE = "SecurityMessage";
    private final Map<Call, NotificationData> callNotifications = new WeakHashMap<Call, NotificationData>();
    private final Map<Contact, Long> proactiveTimer = new HashMap<Contact, Long>();

    public static void fireChatNotification(Object chatContact, String eventType, String messageTitle, String message, String messageUID) {
        NotificationService notificationService = NotificationWiringActivator.getNotificationService();
        if (notificationService == null) {
            return;
        }
        NotificationAction popupActionHandler = null;
        UIService uiService = NotificationWiringActivator.getUIService();
        Chat chatPanel = null;
        byte[] contactIcon = null;
        if (chatContact instanceof Contact) {
            Contact contact = (Contact)chatContact;
            if (uiService != null) {
                chatPanel = uiService.getChat(contact, messageUID);
            }
            if ((contactIcon = contact.getImage()) == null) {
                contactIcon = NotificationWiringActivator.getImageLoaderService().getImageBytes(DEFAULT_USER_PHOTO);
            }
        } else if (chatContact instanceof ChatRoom) {
            ChatRoom chatRoom = (ChatRoom)chatContact;
            if (chatRoom.isSystem()) {
                return;
            }
            if (uiService != null) {
                chatPanel = uiService.getChat(chatRoom);
            }
        }
        if (chatPanel != null && eventType.equals(INCOMING_MESSAGE) && chatPanel.isChatFocused()) {
            popupActionHandler = notificationService.getEventNotificationAction(eventType, "PopupMessageAction");
            popupActionHandler.setEnabled(false);
        }
        HashMap<String, Object> extras = new HashMap<String, Object>();
        extras.put("PopupMessageNotificationHandler.tag", chatContact);
        notificationService.fireNotification(eventType, messageTitle, message, contactIcon, extras);
        if (popupActionHandler != null) {
            popupActionHandler.setEnabled(true);
        }
    }

    private static void fireNotification(String eventType) {
        NotificationService notificationService = NotificationWiringActivator.getNotificationService();
        if (notificationService != null) {
            notificationService.fireNotification(eventType);
        }
    }

    private static NotificationData fireNotification(String eventType, Callable<Boolean> loopCondition) {
        return NotificationManager.fireNotification(eventType, null, null, null, loopCondition);
    }

    private static void fireNotification(String eventType, String messageTitle, String message) {
        NotificationService notificationService = NotificationWiringActivator.getNotificationService();
        if (notificationService != null) {
            notificationService.fireNotification(eventType, messageTitle, message, null);
        }
    }

    private static NotificationData fireNotification(String eventType, String messageTitle, String message, Map<String, String> cmdargs, Callable<Boolean> loopCondition) {
        NotificationService notificationService = NotificationWiringActivator.getNotificationService();
        if (notificationService == null) {
            return null;
        }
        HashMap<String, Object> extras = new HashMap<String, Object>();
        if (cmdargs != null) {
            extras.put("CommandNotificationHandler.cmdargs", cmdargs);
        }
        if (loopCondition != null) {
            extras.put("SoundNotificationHandler.loopCondition", loopCondition);
        }
        return notificationService.fireNotification(eventType, messageTitle, message, null, extras);
    }

    public static Map<Object, ProtocolProviderFactory> getProtocolProviderFactories() {
        ServiceReference[] serRefs = null;
        try {
            serRefs = NotificationWiringActivator.bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("NotificationManager : " + (Object)((Object)e)));
        }
        Hashtable<Object, ProtocolProviderFactory> providerFactoriesMap = new Hashtable<Object, ProtocolProviderFactory>();
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)NotificationWiringActivator.bundleContext.getService(serRef);
                providerFactoriesMap.put(serRef.getProperty("PROTOCOL_NAME"), providerFactory);
            }
        }
        return providerFactoriesMap;
    }

    public static List<ProtocolProviderService> getProtocolProviders() {
        ServiceReference[] serRefs = null;
        try {
            serRefs = NotificationWiringActivator.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("NotificationManager : " + (Object)((Object)e)));
        }
        ArrayList<ProtocolProviderService> providersList = new ArrayList<ProtocolProviderService>();
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderService pp = (ProtocolProviderService)NotificationWiringActivator.bundleContext.getService(serRef);
                providersList.add(pp);
            }
        }
        return providersList;
    }

    private static boolean isPrivate(ChatRoom chatRoom) {
        String nickname;
        if (!chatRoom.isSystem() && chatRoom.isJoined() && chatRoom.getMembersCount() == 1 && (nickname = chatRoom.getUserNickname()) != null) {
            for (ChatRoomMember member : chatRoom.getMembers()) {
                if (!nickname.equals(member.getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean shouldPlayDialingSound(WeakReference<CallPeer> weakPeer) {
        CallPeer peer = (CallPeer)weakPeer.get();
        if (peer == null) {
            return false;
        }
        Call call = peer.getCall();
        if (call == null) {
            return false;
        }
        CallConference conference = call.getConference();
        if (conference == null) {
            return false;
        }
        boolean play = false;
        for (Call aCall : conference.getCalls()) {
            Iterator peerIter = aCall.getCallPeers();
            while (peerIter.hasNext()) {
                CallPeerState state;
                CallPeer aPeer = (CallPeer)peerIter.next();
                if (peer == aPeer) {
                    play = true;
                }
                if (CallPeerState.INITIATING_CALL.equals(state = peer.getState()) || CallPeerState.CONNECTING.equals(state)) {
                    if (peer == aPeer) continue;
                    return false;
                }
                return false;
            }
        }
        return play;
    }

    public void callEnded(CallEvent ev) {
        try {
            NotificationData notification = this.callNotifications.get(ev.getSourceCall());
            if (notification != null) {
                this.stopSound(notification);
            }
            NotificationManager.fireNotification(HANG_UP);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while trying to notify about the end of a call.", t);
        }
    }

    public void callPeerAdded(CallPeerEvent evt) {
        CallPeer peer = evt.getSourceCallPeer();
        if (peer == null) {
            return;
        }
        peer.addCallPeerListener((CallPeerListener)this);
        peer.addCallPeerSecurityListener((CallPeerSecurityListener)this);
        peer.addCallPeerConferenceListener((CallPeerConferenceListener)this);
    }

    public void callPeerRemoved(CallPeerEvent evt) {
        CallPeer peer = evt.getSourceCallPeer();
        if (peer == null) {
            return;
        }
        peer.removeCallPeerListener((CallPeerListener)this);
        peer.removeCallPeerSecurityListener((CallPeerSecurityListener)this);
        peer.addCallPeerConferenceListener((CallPeerConferenceListener)this);
    }

    public void callStateChanged(CallChangeEvent ev) {
    }

    public void conferenceFocusChanged(CallPeerConferenceEvent ev) {
    }

    public void conferenceMemberAdded(CallPeerConferenceEvent conferenceEvent) {
        try {
            CallPeerSecurityStatusEvent securityEvent;
            CallPeer peer = conferenceEvent.getConferenceMember().getConferenceFocusCallPeer();
            if (peer.getConferenceMemberCount() > 0 && (securityEvent = peer.getCurrentSecuritySettings()) instanceof CallPeerSecurityOnEvent) {
                NotificationManager.fireNotification(CALL_SECURITY_ON);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"Error notifying for secured call member", t);
        }
    }

    public void conferenceMemberErrorReceived(CallPeerConferenceEvent ev) {
    }

    public void conferenceMemberRemoved(CallPeerConferenceEvent ev) {
    }

    public void fileTransferCreated(FileTransferCreatedEvent ev) {
    }

    public void fileTransferRequestCanceled(FileTransferRequestEvent ev) {
    }

    public void fileTransferRequestReceived(FileTransferRequestEvent event) {
        try {
            IncomingFileTransferRequest request = event.getRequest();
            Contact sourceContact = request.getSender();
            String title = NotificationWiringActivator.getResources().getI18NString("service.gui.FILE_RECEIVING_FROM", new String[]{sourceContact.getDisplayName()});
            NotificationManager.fireChatNotification(sourceContact, INCOMING_FILE, title, request.getFileName(), request.getID());
        }
        catch (Throwable t) {
            logger.error((Object)"Error notifying for file transfer req received", t);
        }
    }

    public void fileTransferRequestRejected(FileTransferRequestEvent ev) {
    }

    private void handleProviderAdded(ProtocolProviderService protocolProvider) {
        OperationSetBasicTelephony basicTelephonyOpSet;
        OperationSetAdHocMultiUserChat multiAdHocChatOpSet;
        OperationSetMultiUserChat multiChatOpSet;
        OperationSetFileTransfer fileTransferOpSet;
        String tnOpSetClassName;
        String imOpSetClassName;
        if (!protocolProvider.getAccountID().isEnabled()) {
            return;
        }
        Map supportedOperationSets = protocolProvider.getSupportedOperationSets();
        if (supportedOperationSets.containsKey(imOpSetClassName = OperationSetBasicInstantMessaging.class.getName())) {
            OperationSetBasicInstantMessaging im = (OperationSetBasicInstantMessaging)supportedOperationSets.get(imOpSetClassName);
            im.addMessageListener((MessageListener)this);
        }
        if (supportedOperationSets.containsKey(tnOpSetClassName = OperationSetTypingNotifications.class.getName())) {
            OperationSetTypingNotifications tn = (OperationSetTypingNotifications)supportedOperationSets.get(tnOpSetClassName);
            tn.addTypingNotificationsListener((TypingNotificationsListener)this);
        }
        if ((fileTransferOpSet = (OperationSetFileTransfer)protocolProvider.getOperationSet(OperationSetFileTransfer.class)) != null) {
            fileTransferOpSet.addFileTransferListener((FileTransferListener)this);
        }
        if ((multiChatOpSet = (OperationSetMultiUserChat)protocolProvider.getOperationSet(OperationSetMultiUserChat.class)) != null) {
            multiChatOpSet.addPresenceListener((LocalUserChatRoomPresenceListener)this);
        }
        if ((multiAdHocChatOpSet = (OperationSetAdHocMultiUserChat)protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class)) != null) {
            multiAdHocChatOpSet.addPresenceListener((LocalUserAdHocChatRoomPresenceListener)this);
        }
        if ((basicTelephonyOpSet = (OperationSetBasicTelephony)protocolProvider.getOperationSet(OperationSetBasicTelephony.class)) != null) {
            basicTelephonyOpSet.addCallListener((CallListener)this);
        }
    }

    private void handleProviderRemoved(ProtocolProviderService protocolProvider) {
        OperationSetBasicTelephony basicTelephonyOpSet;
        OperationSetAdHocMultiUserChat multiAdHocChatOpSet;
        OperationSetMultiUserChat multiChatOpSet;
        OperationSetFileTransfer fileTransferOpSet;
        String tnOpSetClassName;
        String imOpSetClassName;
        Map supportedOperationSets = protocolProvider.getSupportedOperationSets();
        if (supportedOperationSets.containsKey(imOpSetClassName = OperationSetBasicInstantMessaging.class.getName())) {
            OperationSetBasicInstantMessaging im = (OperationSetBasicInstantMessaging)supportedOperationSets.get(imOpSetClassName);
            im.removeMessageListener((MessageListener)this);
        }
        if (supportedOperationSets.containsKey(tnOpSetClassName = OperationSetTypingNotifications.class.getName())) {
            OperationSetTypingNotifications tn = (OperationSetTypingNotifications)supportedOperationSets.get(tnOpSetClassName);
            tn.removeTypingNotificationsListener((TypingNotificationsListener)this);
        }
        if ((fileTransferOpSet = (OperationSetFileTransfer)protocolProvider.getOperationSet(OperationSetFileTransfer.class)) != null) {
            fileTransferOpSet.removeFileTransferListener((FileTransferListener)this);
        }
        if ((multiChatOpSet = (OperationSetMultiUserChat)protocolProvider.getOperationSet(OperationSetMultiUserChat.class)) != null) {
            multiChatOpSet.removePresenceListener((LocalUserChatRoomPresenceListener)this);
        }
        if ((multiAdHocChatOpSet = (OperationSetAdHocMultiUserChat)protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class)) != null) {
            multiAdHocChatOpSet.removePresenceListener((LocalUserAdHocChatRoomPresenceListener)this);
        }
        if ((basicTelephonyOpSet = (OperationSetBasicTelephony)protocolProvider.getOperationSet(OperationSetBasicTelephony.class)) != null) {
            basicTelephonyOpSet.removeCallListener((CallListener)this);
        }
    }

    public void incomingCallReceived(CallEvent ev) {
        try {
            Call call = ev.getSourceCall();
            CallPeer peer = (CallPeer)call.getCallPeers().next();
            HashMap<String, String> peerInfo = new HashMap<String, String>();
            String peerName = peer.getDisplayName();
            peerInfo.put("caller.uri", peer.getURI());
            peerInfo.put("caller.address", peer.getAddress());
            peerInfo.put("caller.name", peerName);
            peerInfo.put("caller.id", peer.getPeerID());
            final WeakReference<Call> weakCall = new WeakReference<Call>(call);
            NotificationData notification = NotificationManager.fireNotification(INCOMING_CALL, "", ev.isDesktopStreaming() ? NotificationWiringActivator.getResources().getI18NString("service.gui.INCOMING_SCREEN_SHARE", new String[]{peerName}) : NotificationWiringActivator.getResources().getI18NString("service.gui.INCOMING_CALL", new String[]{peerName}), peerInfo, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    Call call = (Call)weakCall.get();
                    if (call == null) {
                        return false;
                    }
                    Iterator peerIter = call.getCallPeers();
                    boolean loop = false;
                    while (peerIter.hasNext()) {
                        CallPeer peer = (CallPeer)peerIter.next();
                        if (!CallPeerState.INCOMING_CALL.equals(peer.getState())) continue;
                        loop = true;
                        break;
                    }
                    return loop;
                }
            });
            if (notification != null) {
                this.callNotifications.put(call, notification);
            }
            call.addCallChangeListener((CallChangeListener)this);
            peer.addCallPeerListener((CallPeerListener)this);
            peer.addCallPeerSecurityListener((CallPeerSecurityListener)this);
            peer.addCallPeerConferenceListener((CallPeerConferenceListener)this);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while trying to notify about an incoming call", t);
        }
    }

    void init() {
        this.registerDefaultNotifications();
        NotificationWiringActivator.bundleContext.addServiceListener((ServiceListener)this);
        for (ProtocolProviderService pp : NotificationManager.getProtocolProviders()) {
            this.handleProviderAdded(pp);
        }
        NotificationWiringActivator.getMediaService().addRecorderListener((Recorder.Listener)this);
    }

    public boolean isConference(Call call) {
        if (call.isConferenceFocus()) {
            return true;
        }
        Iterator callPeers = call.getCallPeers();
        while (callPeers.hasNext()) {
            CallPeer callPeer = (CallPeer)callPeers.next();
            if (!callPeer.isConferenceFocus()) continue;
            return true;
        }
        return call.getCallPeerCount() > 1;
    }

    public void localUserAdHocPresenceChanged(LocalUserAdHocChatRoomPresenceChangeEvent evt) {
        String eventType = evt.getEventType();
        if ("LocalUserJoined".equals(eventType)) {
            evt.getAdHocChatRoom().addMessageListener((AdHocChatRoomMessageListener)this);
        } else if ("LocalUserLeft".equals(eventType) || "LocalUserDropped".equals(eventType)) {
            evt.getAdHocChatRoom().removeMessageListener((AdHocChatRoomMessageListener)this);
        }
    }

    public void localUserPresenceChanged(LocalUserChatRoomPresenceChangeEvent evt) {
        ChatRoom sourceChatRoom = evt.getChatRoom();
        String eventType = evt.getEventType();
        if ("LocalUserJoined".equals(eventType)) {
            sourceChatRoom.addMessageListener((ChatRoomMessageListener)this);
        } else if ("LocalUserLeft".equals(eventType) || "LocalUserKicked".equals(eventType) || "LocalUserDropped".equals(eventType)) {
            sourceChatRoom.removeMessageListener((ChatRoomMessageListener)this);
        }
    }

    public void messageDelivered(AdHocChatRoomMessageDeliveredEvent ev) {
    }

    public void messageDelivered(ChatRoomMessageDeliveredEvent ev) {
    }

    public void messageDelivered(MessageDeliveredEvent ev) {
    }

    public void messageDeliveryFailed(AdHocChatRoomMessageDeliveryFailedEvent ev) {
    }

    public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent ev) {
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent ev) {
    }

    public void messageReceived(AdHocChatRoomMessageReceivedEvent evt) {
        try {
            boolean fireChatNotification;
            AdHocChatRoom sourceChatRoom = evt.getSourceChatRoom();
            Contact sourceParticipant = evt.getSourceChatRoomParticipant();
            String nickname = sourceChatRoom.getName();
            String messageContent = evt.getMessage().getContent();
            boolean bl = fireChatNotification = nickname == null || messageContent.toLowerCase().contains(nickname.toLowerCase());
            if (fireChatNotification) {
                String title = NotificationWiringActivator.getResources().getI18NString("service.gui.MSG_RECEIVED", new String[]{sourceParticipant.getDisplayName()});
                String htmlContent = HTML_CONTENT_TYPE.equals(evt.getMessage().getContentType()) ? messageContent : StringEscapeUtils.escapeHtml4((String)messageContent);
                NotificationManager.fireChatNotification(sourceChatRoom, INCOMING_MESSAGE, title, htmlContent, evt.getMessage().getMessageUID());
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error notifying for adhoc message received", t);
        }
    }

    public void messageReceived(ChatRoomMessageReceivedEvent evt) {
        try {
            boolean fireChatNotification;
            ChatRoom sourceChatRoom = evt.getSourceChatRoom();
            ChatRoomMember sourceMember = evt.getSourceChatRoomMember();
            Message sourceMsg = evt.getMessage();
            String messageContent = sourceMsg.getContent();
            if (sourceChatRoom.isSystem() || NotificationManager.isPrivate(sourceChatRoom) || messageContent == null) {
                fireChatNotification = true;
            } else {
                String nickname = sourceChatRoom.getUserNickname();
                int atIx = -1;
                if (nickname != null) {
                    atIx = nickname.indexOf("@");
                }
                boolean bl = fireChatNotification = nickname == null || messageContent.toLowerCase().contains(nickname.toLowerCase()) || atIx != -1 && messageContent.toLowerCase().contains(nickname.substring(0, atIx).toLowerCase());
            }
            if (fireChatNotification) {
                String title = NotificationWiringActivator.getResources().getI18NString("service.gui.MSG_RECEIVED", new String[]{sourceMember.getName()});
                String htmlContent = HTML_CONTENT_TYPE.equals(sourceMsg.getContentType()) ? messageContent : StringEscapeUtils.escapeHtml4((String)messageContent);
                NotificationManager.fireChatNotification(sourceChatRoom, INCOMING_MESSAGE, title, htmlContent, sourceMsg.getMessageUID());
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error notifying for chat room message received", t);
        }
    }

    public void messageReceived(MessageReceivedEvent evt) {
        try {
            String title = NotificationWiringActivator.getResources().getI18NString("service.gui.MSG_RECEIVED", new String[]{evt.getSourceContact().getDisplayName()});
            Message sourceMsg = evt.getSourceMessage();
            String htmlContent = HTML_CONTENT_TYPE.equals(sourceMsg.getContentType()) ? sourceMsg.getContent() : StringEscapeUtils.escapeHtml4((String)sourceMsg.getContent());
            NotificationManager.fireChatNotification(evt.getSourceContact(), INCOMING_MESSAGE, title, htmlContent, sourceMsg.getMessageUID());
        }
        catch (Throwable t) {
            logger.error((Object)"Error notifying for message received", t);
        }
    }

    public void outgoingCallCreated(CallEvent event) {
        Call call = event.getSourceCall();
        call.addCallChangeListener((CallChangeListener)this);
        if (call.getCallPeers().hasNext()) {
            CallPeer peer = (CallPeer)call.getCallPeers().next();
            peer.addCallPeerListener((CallPeerListener)this);
            peer.addCallPeerSecurityListener((CallPeerSecurityListener)this);
            peer.addCallPeerConferenceListener((CallPeerConferenceListener)this);
        }
    }

    public void peerAddressChanged(CallPeerChangeEvent ev) {
    }

    public void peerDisplayNameChanged(CallPeerChangeEvent ev) {
    }

    public void peerImageChanged(CallPeerChangeEvent ev) {
    }

    public void peerStateChanged(CallPeerChangeEvent ev) {
        try {
            NotificationData notification;
            WeakReference<CallPeer> weakPeer;
            CallPeer peer = ev.getSourceCallPeer();
            Call call = peer.getCall();
            CallPeerState newState = (CallPeerState)ev.getNewValue();
            CallPeerState oldState = (CallPeerState)ev.getOldValue();
            if (newState == CallPeerState.INITIATING_CALL || newState == CallPeerState.CONNECTING) {
                weakPeer = new WeakReference<CallPeer>(peer);
                if (NotificationManager.shouldPlayDialingSound(weakPeer) && (notification = NotificationManager.fireNotification(DIALING, new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return NotificationManager.shouldPlayDialingSound(weakPeer);
                    }
                })) != null) {
                    this.callNotifications.put(call, notification);
                }
            } else {
                NotificationData notification2 = this.callNotifications.get(call);
                if (notification2 != null) {
                    this.stopSound(notification2);
                }
            }
            if (newState == CallPeerState.ALERTING_REMOTE_SIDE && oldState != CallPeerState.CONNECTING_WITH_EARLY_MEDIA) {
                weakPeer = new WeakReference<CallPeer>(peer);
                notification = NotificationManager.fireNotification(OUTGOING_CALL, new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        CallPeer peer = (CallPeer)weakPeer.get();
                        return peer != null && CallPeerState.ALERTING_REMOTE_SIDE.equals(peer.getState());
                    }
                });
                if (notification != null) {
                    this.callNotifications.put(call, notification);
                }
            } else if (newState == CallPeerState.BUSY) {
                if (!this.isConference(call) && (notification = NotificationManager.fireNotification(BUSY_CALL, new Callable<Boolean>(weakPeer = new WeakReference<CallPeer>(peer)){
                    final /* synthetic */ WeakReference val$weakPeer;
                    {
                        this.val$weakPeer = weakReference;
                    }

                    @Override
                    public Boolean call() {
                        CallPeer peer = (CallPeer)this.val$weakPeer.get();
                        return peer != null && CallPeerState.BUSY.equals(peer.getState());
                    }
                })) != null) {
                    this.callNotifications.put(call, notification);
                }
            } else if (newState == CallPeerState.DISCONNECTED || newState == CallPeerState.FAILED) {
                NotificationManager.fireNotification(HANG_UP);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while trying to notify about a change in the state of a call peer.", t);
        }
    }

    public void peerTransportAddressChanged(CallPeerChangeEvent ev) {
    }

    public void recorderStopped(Recorder recorder) {
        try {
            ResourceManagementService resources = NotificationWiringActivator.getResources();
            NotificationManager.fireNotification(CALL_SAVED, resources.getI18NString("plugin.callrecordingconfig.CALL_SAVED"), resources.getI18NString("plugin.callrecordingconfig.CALL_SAVED_TO", new String[]{recorder.getFilename()}));
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while trying to notify that the recording of a call has stopped.", t);
        }
    }

    private void registerDefaultNotifications() {
        NotificationService notificationService = NotificationWiringActivator.getNotificationService();
        if (notificationService == null) {
            return;
        }
        notificationService.registerDefaultNotificationForEvent(INCOMING_MESSAGE, "PopupMessageAction", null, null);
        notificationService.registerDefaultNotificationForEvent(INCOMING_MESSAGE, (NotificationAction)new SoundNotificationAction(SoundProperties.INCOMING_MESSAGE, -1, true, false, false));
        notificationService.registerDefaultNotificationForEvent(INCOMING_CALL, "PopupMessageAction", null, null);
        SoundNotificationAction inCallSoundHandler = new SoundNotificationAction(SoundProperties.INCOMING_CALL, 2000, true, true, true);
        notificationService.registerDefaultNotificationForEvent(INCOMING_CALL, (NotificationAction)inCallSoundHandler);
        notificationService.registerDefaultNotificationForEvent(OUTGOING_CALL, (NotificationAction)new SoundNotificationAction(SoundProperties.OUTGOING_CALL, 3000, false, true, false));
        notificationService.registerDefaultNotificationForEvent(BUSY_CALL, (NotificationAction)new SoundNotificationAction(SoundProperties.BUSY, 1, false, true, false));
        notificationService.registerDefaultNotificationForEvent(DIALING, (NotificationAction)new SoundNotificationAction(SoundProperties.DIALING, -1, false, true, false));
        notificationService.registerDefaultNotificationForEvent(HANG_UP, (NotificationAction)new SoundNotificationAction(SoundProperties.HANG_UP, -1, false, true, false));
        notificationService.registerDefaultNotificationForEvent(PROACTIVE_NOTIFICATION, "PopupMessageAction", null, null);
        notificationService.registerDefaultNotificationForEvent(SECURITY_MESSAGE, "PopupMessageAction", null, null);
        notificationService.registerDefaultNotificationForEvent(CALL_SECURITY_ON, (NotificationAction)new SoundNotificationAction(SoundProperties.CALL_SECURITY_ON, -1, false, true, false));
        notificationService.registerDefaultNotificationForEvent(CALL_SECURITY_ERROR, (NotificationAction)new SoundNotificationAction(SoundProperties.CALL_SECURITY_ERROR, -1, false, true, false));
        notificationService.registerDefaultNotificationForEvent(INCOMING_FILE, "PopupMessageAction", null, null);
        notificationService.registerDefaultNotificationForEvent(INCOMING_FILE, (NotificationAction)new SoundNotificationAction(SoundProperties.INCOMING_FILE, -1, true, false, false));
        notificationService.registerDefaultNotificationForEvent(CALL_SAVED, "PopupMessageAction", null, null);
    }

    public void securityMessageRecieved(CallPeerSecurityMessageEvent ev) {
        try {
            String messageTitleKey;
            switch (ev.getEventSeverity()) {
                case 0: {
                    messageTitleKey = "service.gui.SECURITY_INFO";
                    break;
                }
                case 1: {
                    messageTitleKey = "service.gui.SECURITY_WARNING";
                    break;
                }
                case 2: 
                case 3: {
                    messageTitleKey = "service.gui.SECURITY_ERROR";
                    NotificationManager.fireNotification(CALL_SECURITY_ERROR);
                    break;
                }
                default: {
                    messageTitleKey = null;
                }
            }
            if (messageTitleKey != null) {
                NotificationManager.fireNotification(SECURITY_MESSAGE, NotificationWiringActivator.getResources().getI18NString(messageTitleKey), ev.getI18nMessage());
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while trying to notify about a security message", t);
        }
    }

    public void securityNegotiationStarted(CallPeerSecurityNegotiationStartedEvent ev) {
    }

    public void securityOff(CallPeerSecurityOffEvent ev) {
    }

    public void securityOn(CallPeerSecurityOnEvent ev) {
        try {
            SrtpControl securityController = ev.getSecurityController();
            CallPeer peer = (CallPeer)ev.getSource();
            if (!securityController.requiresSecureSignalingTransport() || peer.getProtocolProvider().isSignalingTransportSecure()) {
                NotificationManager.fireNotification(CALL_SECURITY_ON);
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while trying to notify about a security-related event", t);
        }
    }

    public void securityTimeout(CallPeerSecurityTimeoutEvent ev) {
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = NotificationWiringActivator.bundleContext.getService(serviceRef);
        if (service instanceof ProtocolProviderService) {
            switch (event.getType()) {
                case 1: {
                    this.handleProviderAdded((ProtocolProviderService)service);
                    break;
                }
                case 4: {
                    this.handleProviderRemoved((ProtocolProviderService)service);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSound(NotificationData data) {
        if (data == null) {
            return;
        }
        try {
            NotificationService notificationService = NotificationWiringActivator.getNotificationService();
            if (notificationService != null) {
                notificationService.stopNotification(data);
            }
        }
        finally {
            Iterator<Map.Entry<Call, NotificationData>> i = this.callNotifications.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Call, NotificationData> e = i.next();
                if (!data.equals(e.getValue())) continue;
                i.remove();
            }
        }
    }

    public void typingNotificationDeliveryFailed(TypingNotificationEvent ev) {
    }

    public void typingNotificationReceived(TypingNotificationEvent ev) {
        try {
            MetaContact metaContact;
            Chat chat;
            Contact contact = ev.getSourceContact();
            if (ev.getTypingState() != 1) {
                return;
            }
            UIService uiService = NotificationWiringActivator.getUIService();
            if (uiService != null && (chat = uiService.getCurrentChat()) != null && (metaContact = uiService.getChatContact(chat)) != null && metaContact.containsContact(contact) && chat.isChatFocused()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.proactiveTimer.size() > 0) {
                Iterator<Map.Entry<Contact, Long>> entries = this.proactiveTimer.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<Contact, Long> entry = entries.next();
                    Long lastNotificationDate = entry.getValue();
                    if (lastNotificationDate + 30000L >= currentTime) continue;
                    entries.remove();
                }
                if (this.proactiveTimer.containsKey(contact)) {
                    return;
                }
            }
            this.proactiveTimer.put(contact, currentTime);
            NotificationManager.fireChatNotification(contact, PROACTIVE_NOTIFICATION, contact.getDisplayName(), NotificationWiringActivator.getResources().getI18NString("service.gui.PROACTIVE_NOTIFICATION"), null);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            logger.error((Object)"An error occurred while handling a typing notification.", t);
        }
    }
}

