/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.OperationSetVideoBridge;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

public class OperationSetVideoBridgeImpl
implements OperationSetVideoBridge,
PacketFilter,
PacketListener,
RegistrationStateChangeListener {
    private static final Logger logger = Logger.getLogger(OperationSetVideoBridgeImpl.class);
    private final ProtocolProviderServiceJabberImpl protocolProvider;

    public OperationSetVideoBridgeImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
        this.protocolProvider.addRegistrationStateChangeListener(this);
    }

    public boolean accept(Packet packet) {
        return packet instanceof ColibriConferenceIQ;
    }

    public Call createConfCall(String[] callees) throws OperationFailedException, OperationNotSupportedException {
        return ((OperationSetTelephonyConferencing)this.protocolProvider.getOperationSet(OperationSetTelephonyConferencing.class)).createConfCall(callees, (CallConference)new MediaAwareCallConference(true));
    }

    public CallPeer inviteCalleeToCall(String uri, Call call) throws OperationFailedException, OperationNotSupportedException {
        return ((OperationSetTelephonyConferencing)this.protocolProvider.getOperationSet(OperationSetTelephonyConferencing.class)).inviteCalleeToCall(uri, call);
    }

    public boolean isActive() {
        String jitsiVideobridge = this.protocolProvider.getJitsiVideobridge();
        return jitsiVideobridge != null && jitsiVideobridge.length() > 0;
    }

    private void processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        block1: {
            CallJabberImpl callJabberImpl;
            MediaAwareCallConference conference;
            Call call;
            OperationSetBasicTelephony basicTelephony;
            if (!IQ.Type.SET.equals(conferenceIQ.getType()) || conferenceIQ.getID() == null || (basicTelephony = (OperationSetBasicTelephony)this.protocolProvider.getOperationSet(OperationSetBasicTelephony.class)) == null) break block1;
            Iterator i = basicTelephony.getActiveCalls();
            while (!(!i.hasNext() || (call = (Call)i.next()) instanceof CallJabberImpl && (conference = (callJabberImpl = (CallJabberImpl)call).getConference()) != null && conference.isJitsiVideobridge() && callJabberImpl.processColibriConferenceIQ(conferenceIQ))) {
            }
        }
    }

    public void processPacket(Packet packet) {
        boolean interrupted;
        block5: {
            IQ iq = (IQ)packet;
            if (iq.getType() == IQ.Type.SET) {
                this.protocolProvider.getConnection().sendPacket((Packet)IQ.createResultIQ((IQ)iq));
            }
            ColibriConferenceIQ conferenceIQ = (ColibriConferenceIQ)iq;
            interrupted = false;
            try {
                this.processColibriConferenceIQ(conferenceIQ);
            }
            catch (Throwable t) {
                logger.error((Object)("An error occurred during the processing of a " + packet.getClass().getName() + " packet"), t);
                if (t instanceof InterruptedException) {
                    interrupted = true;
                }
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent ev) {
        Connection connection;
        RegistrationState registrationState = ev.getNewState();
        if (RegistrationState.REGISTERED.equals((Object)registrationState)) {
            this.protocolProvider.getConnection().addPacketListener((PacketListener)this, (PacketFilter)this);
        } else if (RegistrationState.UNREGISTERED.equals((Object)registrationState) && (connection = this.protocolProvider.getConnection()) != null) {
            connection.removePacketListener((PacketListener)this);
        }
    }
}

