/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ReasonPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SessionInfoPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

public class JingleIQ
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String ELEMENT_NAME = "jingle";
    public static final String ACTION_ATTR_NAME = "action";
    public static final String INITIATOR_ATTR_NAME = "initiator";
    public static final String RESPONDER_ATTR_NAME = "responder";
    public static final String SID_ATTR_NAME = "sid";
    private JingleAction action;
    private String initiator;
    private String responder;
    private String sid;
    private ReasonPacketExtension reason;
    private SessionInfoPacketExtension sessionInfo;
    private final List<ContentPacketExtension> contentList = new ArrayList<ContentPacketExtension>();

    public String getChildElementXML() {
        StringBuilder bldr = new StringBuilder("<jingle");
        bldr.append(" xmlns='urn:xmpp:jingle:1'");
        bldr.append(" action='" + (Object)((Object)this.getAction()) + "'");
        if (this.initiator != null) {
            bldr.append(" initiator='" + this.getInitiator() + "'");
        }
        if (this.responder != null) {
            bldr.append(" responder='" + this.getResponder() + "'");
        }
        bldr.append(" sid='" + this.getSID() + "'");
        String extensionsXMLSeq = this.getExtensionsXML();
        String extensionsXML = extensionsXMLSeq.toString();
        if (this.contentList.size() == 0 && this.reason == null && this.sessionInfo == null && (extensionsXML == null || extensionsXML.length() == 0)) {
            bldr.append("/>");
        } else {
            bldr.append(">");
            for (ContentPacketExtension cpe : this.contentList) {
                bldr.append(cpe.toXML());
            }
            if (this.reason != null) {
                bldr.append(this.reason.toXML());
            }
            if (this.sessionInfo != null) {
                bldr.append(this.sessionInfo.toXML());
            }
            if (extensionsXML != null && extensionsXML.length() != 0) {
                bldr.append(extensionsXML);
            }
            bldr.append("</jingle>");
        }
        return bldr.toString();
    }

    public void setSID(String sid) {
        this.sid = sid;
    }

    public String getSID() {
        return this.sid;
    }

    public static String generateSID() {
        return new BigInteger(64, new SecureRandom()).toString(32);
    }

    public void setResponder(String responder) {
        this.responder = responder;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setAction(JingleAction action) {
        this.action = action;
    }

    public JingleAction getAction() {
        return this.action;
    }

    public void setReason(ReasonPacketExtension reason) {
        this.reason = reason;
    }

    public ReasonPacketExtension getReason() {
        return this.reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContentPacketExtension> getContentList() {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            return new ArrayList<ContentPacketExtension>(this.contentList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(ContentPacketExtension contentPacket) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            this.contentList.add(contentPacket);
        }
    }

    public boolean containsContentChildOfType(Class<? extends PacketExtension> contentType) {
        return this.getContentForType(contentType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentPacketExtension getContentForType(Class<? extends PacketExtension> contentType) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            for (ContentPacketExtension content : this.contentList) {
                PacketExtension child = content.getFirstChildOfType(contentType);
                if (child == null) continue;
                return content;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentPacketExtension getContentByName(String contentName) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            for (ContentPacketExtension content : this.contentList) {
                if (!contentName.equals(content.getName())) continue;
                return content;
            }
        }
        return null;
    }

    public void setSessionInfo(SessionInfoPacketExtension si) {
        this.sessionInfo = si;
    }

    public SessionInfoPacketExtension getSessionInfo() {
        return this.sessionInfo;
    }
}

