/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.message.SIPRequest;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.CallInfoHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.UserAgentHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.ConfigHeaders;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipApplicationData;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetCusaxUtils;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class SipMessageFactory
implements MessageFactory {
    public static final Logger logger = Logger.getLogger(SipMessageFactory.class);
    private final ProtocolProviderServiceSipImpl protocolProvider;
    private final MessageFactory wrappedFactory;
    private static Random localTagGenerator = null;

    public SipMessageFactory(ProtocolProviderServiceSipImpl service, MessageFactory wrappedFactory) {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        if (wrappedFactory == null) {
            throw new NullPointerException("wrappedFactory is null");
        }
        this.protocolProvider = service;
        this.wrappedFactory = wrappedFactory;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, Object content) throws ParseException {
        Request request = this.wrappedFactory.createRequest(requestURI, method, callId, cSeq, from, to, via, maxForwards, contentType, content);
        return (Request)this.attachScSpecifics((Message)request);
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, byte[] content) throws ParseException {
        Request request = this.wrappedFactory.createRequest(requestURI, method, callId, cSeq, from, to, via, maxForwards, contentType, content);
        return (Request)this.attachScSpecifics((Message)request);
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards) throws ParseException {
        Request request = this.wrappedFactory.createRequest(requestURI, method, callId, cSeq, from, to, via, maxForwards);
        return (Request)this.attachScSpecifics((Message)request);
    }

    public Request createRequest(String requestParam) throws ParseException {
        Request request = this.wrappedFactory.createRequest(requestParam);
        return (Request)this.attachScSpecifics((Message)request);
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, Object content) throws ParseException {
        Response response = this.wrappedFactory.createResponse(statusCode, callId, cSeq, from, to, via, maxForwards, contentType, content);
        return (Response)this.attachScSpecifics((Message)response);
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, byte[] content) throws ParseException {
        Response response = this.wrappedFactory.createResponse(statusCode, callId, cSeq, from, to, via, maxForwards, contentType, content);
        return (Response)this.attachScSpecifics((Message)response);
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards) throws ParseException {
        Response response = this.wrappedFactory.createResponse(statusCode, callId, cSeq, from, to, via, maxForwards);
        return (Response)this.attachScSpecifics((Message)response);
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, Object content) throws ParseException {
        Response response = this.wrappedFactory.createResponse(statusCode, request, contentType, content);
        this.extractAndApplyDialogToTag((SIPRequest)request, response);
        return (Response)this.attachScSpecifics((Message)response);
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, byte[] content) throws ParseException {
        Response response = this.wrappedFactory.createResponse(statusCode, request, contentType, content);
        this.extractAndApplyDialogToTag((SIPRequest)request, response);
        return (Response)this.attachScSpecifics((Message)response);
    }

    public Response createResponse(int statusCode, Request request) throws ParseException {
        Response response = this.wrappedFactory.createResponse(statusCode, request);
        this.extractAndApplyDialogToTag((SIPRequest)request, response);
        return (Response)this.attachScSpecifics((Message)response);
    }

    public Response createResponse(String responseParam) throws ParseException {
        Response response = this.wrappedFactory.createResponse(responseParam);
        return (Response)this.attachScSpecifics((Message)response);
    }

    private void extractAndApplyDialogToTag(SIPRequest request, Response response) {
        block6: {
            ServerTransaction tran = (ServerTransaction)request.getTransaction();
            if (tran == null) {
                return;
            }
            Dialog dialog = tran.getDialog();
            if (dialog == null) {
                return;
            }
            String localDialogTag = dialog.getLocalTag();
            if (localDialogTag == null || localDialogTag.length() == 0) {
                return;
            }
            ToHeader to = (ToHeader)response.getHeader("To");
            if (to == null) {
                return;
            }
            try {
                to.setTag(localDialogTag);
            }
            catch (ParseException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)"Failed to attach a to tag", (Throwable)e);
            }
        }
    }

    private Message attachScSpecifics(Message message) {
        UserAgentHeader userAgentHeader;
        SipApplicationData.setApplicationData(message, "service", (Object)this.protocolProvider);
        if (message instanceof Response) {
            FromHeader from = (FromHeader)message.getHeader("From");
            String fromTag = from == null ? null : from.getTag();
            Response response = (Response)message;
            if (fromTag != null && fromTag.trim().length() > 0 && response.getStatusCode() > 100 && response.getStatusCode() < 300) {
                this.attachToTag(response, null);
            }
        }
        this.attachContactHeader(message);
        if (message instanceof Request && !"ACK".equals(((Request)message).getMethod())) {
            this.preAuthenticateRequest((Request)message);
        }
        if ((userAgentHeader = this.protocolProvider.getSipCommUserAgentHeader()) != null) {
            message.setHeader((Header)userAgentHeader);
        }
        ConfigHeaders.attachConfigHeaders(message, this.protocolProvider);
        return message;
    }

    private Message attachContactHeader(Message message) {
        SipURI intendedDestinationURI;
        if (message instanceof Request) {
            Request request = (Request)message;
            SipURI requestURI = (SipURI)request.getRequestURI();
            request.setHeader((Header)this.protocolProvider.getContactHeader(requestURI));
            return request;
        }
        Response response = (Response)message;
        ViaHeader via = (ViaHeader)response.getHeader("Via");
        String transport = via.getTransport();
        String host = via.getHost();
        int port = via.getPort();
        try {
            intendedDestinationURI = this.protocolProvider.getAddressFactory().createSipURI(null, host);
            intendedDestinationURI.setPort(port);
            if (transport != null) {
                intendedDestinationURI.setTransportParam(transport);
            }
        }
        catch (ParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(via + " does not seem to be a valid header."));
            }
            FromHeader from = (FromHeader)response.getHeader("From");
            intendedDestinationURI = (SipURI)from.getAddress().getURI();
        }
        ContactHeader contactHeader = this.protocolProvider.getContactHeader(intendedDestinationURI);
        response.setHeader((Header)contactHeader);
        return response;
    }

    public static synchronized String generateLocalTag() {
        if (localTagGenerator == null) {
            localTagGenerator = new Random();
        }
        return Integer.toHexString(localTagGenerator.nextInt());
    }

    private void attachToTag(Response response, Dialog containingDialog) {
        ToHeader to = (ToHeader)response.getHeader("To");
        if (to == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Strange ... no to To header in response:" + response));
            }
            return;
        }
        if (containingDialog != null && containingDialog.getLocalTag() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"We seem to already have a tag in this dialog. Returning");
            }
            return;
        }
        try {
            if (to.getTag() == null || to.getTag().trim().length() == 0) {
                String toTag = SipMessageFactory.generateLocalTag();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("generated to tag: " + toTag));
                }
                to.setTag(toTag);
            }
        }
        catch (ParseException ex) {
            logger.error((Object)"Failed to attach a to tag to an outgoing response.", (Throwable)ex);
        }
    }

    public Request createRequest(Dialog dialog, String method) throws OperationFailedException {
        Request request = null;
        try {
            request = dialog.createRequest(method);
        }
        catch (SipException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create " + method + " request.", 4, ex, logger);
        }
        ArrayList<ViaHeader> viaHeaders = this.protocolProvider.getLocalViaHeaders(dialog.getRemoteParty());
        request.setHeader((Header)viaHeaders.get(0));
        this.attachScSpecifics((Message)request);
        return request;
    }

    public Request createInviteRequest(Address toAddress) throws OperationFailedException, IllegalArgumentException {
        CallIdHeader callIdHeader = this.protocolProvider.getDefaultJainSipProvider().getNewCallId();
        HeaderFactory headerFactory = this.protocolProvider.getHeaderFactory();
        CSeqHeader cSeqHeader = null;
        try {
            cSeqHeader = headerFactory.createCSeqHeader(1L, "INVITE");
        }
        catch (InvalidArgumentException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Error occurred while constructing the CSeqHeadder", 4, ex, logger);
        }
        catch (ParseException exc) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Error while constructing a CSeqHeadder", 4, exc, logger);
        }
        Header replacesHeader = this.stripReplacesHeader(toAddress);
        String localTag = SipMessageFactory.generateLocalTag();
        FromHeader fromHeader = null;
        ToHeader toHeader = null;
        try {
            fromHeader = headerFactory.createFromHeader(this.protocolProvider.getOurSipAddress(toAddress), localTag);
            toHeader = headerFactory.createToHeader(toAddress, null);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("An unexpected erro occurred whileconstructing the ToHeader", 4, ex, logger);
        }
        ArrayList<ViaHeader> viaHeaders = this.protocolProvider.getLocalViaHeaders(toAddress);
        MaxForwardsHeader maxForwards = this.protocolProvider.getMaxForwardsHeader();
        Request invite = null;
        try {
            invite = this.protocolProvider.getMessageFactory().createRequest(toHeader.getAddress().getURI(), "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        }
        catch (ParseException ex) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to create invite Request!", 4, ex, logger);
        }
        CallInfoHeader callInfoHeader = null;
        try {
            ProtocolProviderService cusaxProvider = null;
            OperationSetCusaxUtils cusaxOpSet = (OperationSetCusaxUtils)this.protocolProvider.getOperationSet(OperationSetCusaxUtils.class);
            if (cusaxOpSet != null) {
                cusaxProvider = cusaxOpSet.getLinkedCusaxProvider();
            }
            String alternativeImppAddress = null;
            if (cusaxProvider != null) {
                alternativeImppAddress = cusaxProvider.getAccountID().getAccountAddress();
            }
            if (alternativeImppAddress != null) {
                callInfoHeader = headerFactory.createCallInfoHeader((URI)new GenericURI("xmpp:" + alternativeImppAddress));
                callInfoHeader.setParameter("purpose", "impp");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (callInfoHeader != null) {
            invite.setHeader(callInfoHeader);
        }
        if (replacesHeader != null) {
            invite.setHeader(replacesHeader);
        }
        return invite;
    }

    public Request createInviteRequest(Address toAddress, Message cause) throws OperationFailedException, IllegalArgumentException {
        Request invite = this.createInviteRequest(toAddress);
        if (cause != null) {
            this.reflectCauseOnEffect(cause, (Message)invite);
        }
        return invite;
    }

    private void reflectCauseOnEffect(Message cause, Message effect) {
        Header referredBy = cause.getHeader("Referred-By");
        if (referredBy != null) {
            effect.setHeader(referredBy);
        }
    }

    private Header stripReplacesHeader(Address address) throws OperationFailedException {
        SipURI sipURI;
        String replacesHeaderValue;
        URI uri = address.getURI();
        Header replacesHeader = null;
        if (uri.isSipURI() && (replacesHeaderValue = (sipURI = (SipURI)uri).getHeader("Replaces")) != null) {
            Iterator headerNameIter = sipURI.getHeaderNames();
            while (headerNameIter.hasNext()) {
                if (!"Replaces".equals(headerNameIter.next())) continue;
                headerNameIter.remove();
                break;
            }
            try {
                replacesHeader = this.protocolProvider.getHeaderFactory().createHeader("Replaces", URLDecoder.decode(replacesHeaderValue, "UTF-8"));
            }
            catch (Exception ex) {
                throw new OperationFailedException("Failed to create ReplacesHeader from " + replacesHeaderValue, 4, (Throwable)ex);
            }
        }
        return replacesHeader;
    }

    public Request createAck(ClientTransaction clientTransaction) throws InvalidArgumentException, SipException {
        CSeqHeader cseq = (CSeqHeader)clientTransaction.getRequest().getHeader("CSeq");
        Request ack = clientTransaction.getDialog().createAck(cseq.getSeqNumber());
        this.attachScSpecifics((Message)ack);
        return ack;
    }

    public void preAuthenticateRequest(Request request) {
        CallIdHeader callIdHeader = (CallIdHeader)request.getHeader("Call-ID");
        if (callIdHeader == null) {
            return;
        }
        String callid = callIdHeader.getCallId();
        AuthorizationHeader authorization = this.protocolProvider.getSipSecurityManager().getCachedAuthorizationHeader(callid);
        if (authorization != null) {
            request.setHeader((Header)authorization);
        }
    }

    public Request createRegisterRequest(Address addressOfRecord, int registrationsExpiration, CallIdHeader callIdHeader, long cSeqValue) throws InvalidArgumentException, ParseException, OperationFailedException {
        FromHeader fromHeader = this.protocolProvider.getHeaderFactory().createFromHeader(addressOfRecord, SipMessageFactory.generateLocalTag());
        CSeqHeader cSeqHeader = this.protocolProvider.getHeaderFactory().createCSeqHeader(cSeqValue, "REGISTER");
        ToHeader toHeader = this.protocolProvider.getHeaderFactory().createToHeader(addressOfRecord, null);
        MaxForwardsHeader maxForwardsHeader = this.protocolProvider.getMaxForwardsHeader();
        SipURI requestURI = this.protocolProvider.getRegistrarConnection().getRegistrarURI();
        ArrayList<ViaHeader> viaHeaders = this.protocolProvider.getLocalViaHeaders(requestURI);
        Request request = this.createRequest((URI)requestURI, "REGISTER", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
        ExpiresHeader expHeader = null;
        for (int retry = 0; retry < 2; ++retry) {
            try {
                expHeader = this.protocolProvider.getHeaderFactory().createExpiresHeader(registrationsExpiration);
                continue;
            }
            catch (InvalidArgumentException ex) {
                if (retry == 0) {
                    registrationsExpiration = 3600;
                    continue;
                }
                throw new IllegalArgumentException("Invalid registrations expiration parameter - " + registrationsExpiration, ex);
            }
        }
        request.addHeader(expHeader);
        ContactHeader contactHeader = (ContactHeader)request.getHeader("Contact");
        contactHeader.setExpires(registrationsExpiration);
        request.setHeader((Header)contactHeader);
        return request;
    }

    public Request createUnRegisterRequest(Request registerRequest, long cSeqValue) throws InvalidArgumentException {
        Request unregisterRequest = (Request)registerRequest.clone();
        unregisterRequest.getExpires().setExpires(0);
        CSeqHeader cSeqHeader = (CSeqHeader)unregisterRequest.getHeader("CSeq");
        cSeqHeader.setSeqNumber(cSeqValue);
        ViaHeader via = (ViaHeader)unregisterRequest.getHeader("Via");
        if (via != null) {
            via.removeParameter("branch");
        }
        ContactHeader contact = (ContactHeader)unregisterRequest.getHeader("Contact");
        contact.setExpires(0);
        this.attachScSpecifics((Message)unregisterRequest);
        return unregisterRequest;
    }
}

