/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.connectioninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.connectioninfo.ConnectionDetailsPanel;
import net.java.sip.communicator.plugin.connectioninfo.ConnectionInfoActivator;
import net.java.sip.communicator.plugin.connectioninfo.ConnectionInfoMenuItemComponent;
import net.java.sip.communicator.plugin.connectioninfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ConnectionInfoPanel
extends TransparentPanel
implements ServiceListener,
RegistrationStateChangeListener {
    private static final long serialVersionUID = 0L;
    private final JPanel centerPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private ConnectionDetailsPanel currentDetailsPanel;
    private final JComboBox accountsComboBox;
    private final Map<AccountID, ConnectionDetailsPanel> accountsTable = new HashMap<AccountID, ConnectionDetailsPanel>();
    private ConnectionInfoMenuItemComponent.ConnectionInfoDialog dialog;

    public ConnectionInfoPanel(ConnectionInfoMenuItemComponent.ConnectionInfoDialog dialog) {
        this.dialog = dialog;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.accountsComboBox = new JComboBox();
        this.accountsComboBox.setOpaque(false);
        this.accountsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConnectionDetailsPanel panel = (ConnectionDetailsPanel)e.getItem();
                    panel.setOpaque(false);
                    ConnectionInfoPanel.this.centerPanel.removeAll();
                    ConnectionInfoPanel.this.centerPanel.add((Component)((Object)panel), "Center");
                    ConnectionInfoPanel.this.centerPanel.revalidate();
                    ConnectionInfoPanel.this.centerPanel.repaint();
                    ConnectionInfoPanel.this.currentDetailsPanel = panel;
                }
            }
        });
        this.init();
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ComboBoxRenderer renderer = new ComboBoxRenderer();
        this.accountsComboBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.accountsComboBox.setRenderer(renderer);
        JLabel comboLabel = new JLabel(Resources.getString("plugin.accountinfo.SELECT_ACCOUNT"));
        comboLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        TransparentPanel comboBoxPanel = new TransparentPanel();
        comboBoxPanel.setLayout(new BoxLayout((Container)comboBoxPanel, 0));
        comboBoxPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        comboBoxPanel.add(comboLabel);
        comboBoxPanel.add(this.accountsComboBox);
        this.add((Component)comboBoxPanel);
        this.add(this.centerPanel);
    }

    private void init() {
        ConnectionInfoActivator.bundleContext.addServiceListener((ServiceListener)this);
        for (ProtocolProviderFactory providerFactory : ConnectionInfoActivator.getProtocolProviderFactories().values()) {
            ArrayList accountsList = providerFactory.getRegisteredAccounts();
            for (AccountID accountID : accountsList) {
                ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
                ProtocolProviderService protocolProvider = (ProtocolProviderService)ConnectionInfoActivator.bundleContext.getService(serRef);
                this.currentDetailsPanel = new ConnectionDetailsPanel(this.dialog, protocolProvider);
                this.accountsTable.put(protocolProvider.getAccountID(), this.currentDetailsPanel);
                this.accountsComboBox.addItem(this.currentDetailsPanel);
                protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
            }
        }
    }

    public void dispose() {
        ConnectionInfoActivator.bundleContext.removeServiceListener((ServiceListener)this);
        for (ConnectionDetailsPanel pan : this.accountsTable.values()) {
            pan.getProtocolProvider().removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }

    public void registrationStateChanged(final RegistrationStateChangeEvent evt) {
        ConnectionDetailsPanel panel;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionInfoPanel.this.registrationStateChanged(evt);
                }
            });
            return;
        }
        ProtocolProviderService protocolProvider = evt.getProvider();
        if (evt.getNewState() == RegistrationState.REGISTERED) {
            if (this.accountsTable.containsKey(protocolProvider.getAccountID())) {
                ConnectionDetailsPanel detailsPanel = this.accountsTable.get(protocolProvider.getAccountID());
                detailsPanel.loadDetails();
            } else {
                ConnectionDetailsPanel panel2 = new ConnectionDetailsPanel(this.dialog, protocolProvider);
                this.accountsTable.put(protocolProvider.getAccountID(), panel2);
                this.accountsComboBox.addItem(panel2);
            }
        } else if (evt.getNewState() == RegistrationState.UNREGISTERING && (panel = this.accountsTable.get(protocolProvider.getAccountID())) != null) {
            this.accountsTable.remove(protocolProvider.getAccountID());
            this.accountsComboBox.removeItem(panel);
            if (this.currentDetailsPanel == panel) {
                this.currentDetailsPanel = null;
                this.centerPanel.removeAll();
                this.centerPanel.revalidate();
                this.centerPanel.repaint();
            }
        }
    }

    public void serviceChanged(final ServiceEvent event) {
        ConnectionDetailsPanel panel;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionInfoPanel.this.serviceChanged(event);
                }
            });
            return;
        }
        Object service = ConnectionInfoActivator.bundleContext.getService(event.getServiceReference());
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        ProtocolProviderService protocolProvider = (ProtocolProviderService)service;
        if (event.getType() == 1) {
            if (this.accountsTable.get(protocolProvider.getAccountID()) == null) {
                ConnectionDetailsPanel panel2 = new ConnectionDetailsPanel(this.dialog, protocolProvider);
                this.accountsTable.put(protocolProvider.getAccountID(), panel2);
                this.accountsComboBox.addItem(panel2);
                protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
            }
        } else if (event.getType() == 4 && (panel = this.accountsTable.get(protocolProvider.getAccountID())) != null) {
            this.accountsTable.remove(protocolProvider.getAccountID());
            this.accountsComboBox.removeItem(panel);
            if (this.currentDetailsPanel == panel) {
                this.currentDetailsPanel = null;
                this.centerPanel.removeAll();
                this.centerPanel.revalidate();
                this.centerPanel.repaint();
            }
        }
    }

    public JComboBox getAccountsComboBox() {
        return this.accountsComboBox;
    }

    public Map<AccountID, ConnectionDetailsPanel> getAccountsTable() {
        return this.accountsTable;
    }

    private class ComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;

        private ComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value != null) {
                ConnectionDetailsPanel panel = (ConnectionDetailsPanel)value;
                renderer.setText(panel.protocolProvider.getAccountID().getUserID());
                ImageIcon protocolIcon = new ImageIcon(panel.protocolProvider.getProtocolIcon().getIcon("IconSize16x16"));
                renderer.setIcon(protocolIcon);
            }
            return renderer;
        }
    }
}

